/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.NatTableLayerDim;
import org.eclipse.statet.ecommons.waltable.command.DisposeResourcesCommand;
import org.eclipse.statet.ecommons.waltable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.conflation.EventConflaterChain;
import org.eclipse.statet.ecommons.waltable.conflation.IEventConflater;
import org.eclipse.statet.ecommons.waltable.conflation.VisualChangeEventConflater;
import org.eclipse.statet.ecommons.waltable.core.Persistable;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.config.BasicConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.ClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerListener;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.events.VisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.top.OverlayPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.top.TopLayer;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.TableLayerPainter;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.grid.core.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.refresh.core.StructuralRefreshCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.CellSelectionEvent;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.ecommons.waltable.ui.mode.ConfigurableModeEventHandler;
import org.eclipse.statet.ecommons.waltable.ui.mode.ModeSupport;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.statet.ecommons.waltable.viewport.core.RecalculateScrollBarsCommand;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class NatTable
extends Canvas
implements TopLayer,
PaintListener,
LayerListener,
Persistable {
    public static final int DEFAULT_STYLE_OPTIONS = 538182400;
    private final NatTableLayerDim hDim;
    private final NatTableLayerDim vDim;
    private ClientAreaProvider clientAreaProvider = new ClientAreaProvider(){

        @Override
        public LRectangle getClientArea() {
            if (!NatTable.this.isDisposed()) {
                return SwtUtils.toNatTable(NatTable.this.getClientArea());
            }
            return new LRectangle(0L, 0L, 0L, 0L);
        }
    };
    private UiBindingRegistry uiBindingRegistry;
    private ModeSupport modeSupport;
    private final EventConflaterChain conflaterChain = new EventConflaterChain();
    private final CopyOnWriteIdentityListSet<OverlayPainter> overlayPainters = new CopyOnWriteIdentityListSet();
    private final List<Persistable> persistables = new LinkedList<Persistable>();
    private Layer underlyingLayer;
    private ConfigRegistry configRegistry;
    protected final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();
    protected String id = GUIHelper.getSequenceNumber();
    private LayerPainter layerPainter = new TableLayerPainter(this);
    private final boolean autoconfigure;
    private final CopyOnWriteIdentityListSet<LayerListener> listeners = new CopyOnWriteIdentityListSet();

    public NatTable(Composite parent, Layer layer) {
        this(parent, 538182400, layer);
    }

    public NatTable(Composite parent, Layer layer, boolean autoconfigure) {
        this(parent, 538182400, layer, autoconfigure);
    }

    public NatTable(Composite parent, int style, Layer layer) {
        this(parent, style, layer, true);
    }

    public NatTable(Composite parent, int style, final Layer layer, boolean autoconfigure) {
        super(parent, style);
        this.hDim = new NatTableLayerDim(this, layer.getDim(Orientation.HORIZONTAL));
        this.vDim = new NatTableLayerDim(this, layer.getDim(Orientation.VERTICAL));
        this.disableScrollBar(this.getHorizontalBar());
        this.disableScrollBar(this.getVerticalBar());
        this.initInternalListener();
        this.internalSetLayer(layer);
        this.autoconfigure = autoconfigure;
        if (autoconfigure) {
            this.configurations.add(new DefaultNatTableStyleConfiguration());
            this.configure();
        }
        this.conflaterChain.add(this.getVisualChangeEventConflater());
        this.conflaterChain.start();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NatTable.this.doCommand(new DisposeResourcesCommand());
                NatTable.this.conflaterChain.stop();
                ActiveCellEditorRegistry.unregisterActiveCellEditor();
                layer.dispose();
            }
        });
    }

    @Override
    public NatTableLayerDim getDim(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? this.hDim : this.vDim;
    }

    protected IEventConflater getVisualChangeEventConflater() {
        return new VisualChangeEventConflater(this);
    }

    private void disableScrollBar(ScrollBar scrollBar) {
        if (scrollBar != null) {
            scrollBar.setMinimum(0);
            scrollBar.setMaximum(1);
            scrollBar.setThumb(1);
            scrollBar.setEnabled(false);
        }
    }

    public Layer getUnderlyingLayer() {
        return this.underlyingLayer;
    }

    private void internalSetLayer(Layer layer) {
        if (layer != null) {
            this.underlyingLayer = layer;
            this.underlyingLayer.setClientAreaProvider(this.getClientAreaProvider());
            this.underlyingLayer.addLayerListener(this);
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only add configurations post construction if autoconfigure is turned off");
        }
        this.configurations.add(configuration);
    }

    public ConfigRegistry getConfigRegistry() {
        if (this.configRegistry == null) {
            this.configRegistry = new BasicConfigRegistry();
        }
        return this.configRegistry;
    }

    public void setConfigRegistry(ConfigRegistry configRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set config registry post construction if autoconfigure is turned off");
        }
        this.configRegistry = configRegistry;
    }

    public UiBindingRegistry getUiBindingRegistry() {
        if (this.uiBindingRegistry == null) {
            this.uiBindingRegistry = new UiBindingRegistry(this);
        }
        return this.uiBindingRegistry;
    }

    public void setUiBindingRegistry(UiBindingRegistry uiBindingRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set UI binding registry post construction if autoconfigure is turned off");
        }
        this.uiBindingRegistry = uiBindingRegistry;
    }

    public String getID() {
        return this.id;
    }

    protected void checkSubclass() {
    }

    protected void initInternalListener() {
        this.modeSupport = new ModeSupport(this);
        this.modeSupport.registerModeEventHandler("NORMAL_MODE", new ConfigurableModeEventHandler(this.modeSupport, this));
        this.modeSupport.switchMode("NORMAL_MODE");
        this.addPaintListener(this);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NatTable.this.redraw();
            }

            public void focusGained(FocusEvent arg0) {
                NatTable.this.redraw();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                NatTable.this.doCommand(new ClientAreaResizeCommand((Scrollable)NatTable.this));
            }
        });
    }

    public boolean forceFocus() {
        return super.forceFocus();
    }

    public ImList<OverlayPainter> getOverlayPainters() {
        return this.overlayPainters.toList();
    }

    public void addOverlayPainter(OverlayPainter overlayPainter) {
        this.overlayPainters.add((Object)overlayPainter);
    }

    public void removeOverlayPainter(OverlayPainter overlayPainter) {
        this.overlayPainters.remove((Object)overlayPainter);
    }

    public void paintControl(PaintEvent event) {
        this.paintNatTable(event);
    }

    private void paintNatTable(PaintEvent event) {
        Rectangle eventRectangle = new Rectangle(event.x, event.y, event.width, event.height);
        if (!eventRectangle.isEmpty()) {
            this.getLayerPainter().paintLayer(this, event.gc, 0, 0, eventRectangle, this.getConfigRegistry());
        }
    }

    @Override
    public LayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void setLayerPainter(LayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    public void repaintColumn(long columnPosition) {
        this.hDim.repaintPosition(columnPosition);
    }

    public void repaintRow(long rowPosition) {
        this.vDim.repaintPosition(rowPosition);
    }

    protected void repaint(Orientation orientation, long start, long size) {
        if (orientation == Orientation.HORIZONTAL) {
            this.redraw(SwtUtils.toSWT(start), 0, SwtUtils.toSWT(size), GraphicsUtils.safe(this.getHeight()), true);
        } else {
            this.redraw(0, SwtUtils.toSWT(start), GraphicsUtils.safe(this.getWidth()), SwtUtils.toSWT(size), true);
        }
    }

    public void updateResize() {
        this.updateResize(true);
    }

    private void updateResize(boolean redraw) {
        if (this.isDisposed()) {
            return;
        }
        this.doCommand(new RecalculateScrollBarsCommand());
        if (redraw) {
            this.redraw();
        }
    }

    public void refresh() {
        this.doCommand(new StructuralRefreshCommand());
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        throw new UnsupportedOperationException("Cannot use this method to configure NatTable. Use no-argument configure() instead.");
    }

    public void configure() {
        if (this.underlyingLayer == null) {
            throw new IllegalStateException("Layer must be set before configure is called");
        }
        if (this.underlyingLayer != null) {
            this.underlyingLayer.configure(this.getConfigRegistry(), this.getUiBindingRegistry());
        }
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(this.getConfigRegistry());
            configuration.configureUiBindings(this.getUiBindingRegistry());
        }
    }

    @Override
    public void handleLayerEvent(LayerEvent event) {
        for (LayerListener layerListener : this.listeners) {
            layerListener.handleLayerEvent(event);
        }
        if (event instanceof VisualChangeEvent) {
            this.conflaterChain.addEvent(event);
        }
        if (event instanceof CellSelectionEvent) {
            Event e = new Event();
            e.widget = this;
            try {
                this.notifyListeners(13, e);
            }
            catch (RuntimeException re) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "An error occurred when fireing SWT selection event.", (Throwable)re));
            }
        }
    }

    @Override
    public void saveState(final String prefix, final Map<String, String> properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NatTable.this.underlyingLayer.saveState(prefix, properties);
            }
        });
    }

    @Override
    public void loadState(final String prefix, final Map<String, String> properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NatTable.this.underlyingLayer.loadState(prefix, properties);
            }
        });
    }

    @Override
    public void registerPersistable(Persistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(Persistable persistable) {
        this.persistables.remove(persistable);
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void registerCommandHandler(LayerCommandHandler<?> commandHandler) {
        this.underlyingLayer.registerCommandHandler(commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends LayerCommand> commandClass) {
        this.underlyingLayer.unregisterCommandHandler(commandClass);
    }

    @Override
    public void fireLayerEvent(LayerEvent event) {
        this.underlyingLayer.fireLayerEvent(event);
    }

    @Override
    public void addLayerListener(LayerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeLayerListener(LayerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public long getColumnCount() {
        return this.hDim.getPositionCount();
    }

    @Override
    public long getWidth() {
        return this.hDim.getSize();
    }

    @Override
    public long getColumnPositionByX(long x) {
        try {
            return this.hDim.getPositionByPixel(x);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public long getRowCount() {
        return this.vDim.getPositionCount();
    }

    @Override
    public long getHeight() {
        return this.vDim.getSize();
    }

    @Override
    public long getRowPositionByY(long y) {
        try {
            return this.vDim.getPositionByPixel(y);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public Layer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer;
    }

    @Override
    public ClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(ClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
        this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }
}

