/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.lang;

import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public final class ObjectUtils {
    public static final Class<@NonNull Object> NonNull_Object_TYPE = Object.class;
    public static final Class<@Nullable Object> Nullable_Object_TYPE = Object.class;
    public static final Class<@NonNull String> NonNull_String_TYPE = String.class;
    public static final Class<@Nullable String> Nullable_String_TYPE = String.class;

    public static boolean isNull(@Nullable Object object) {
        return object == null;
    }

    public static boolean isAnyNull(@Nullable Object object1, @Nullable Object object2) {
        return object1 == null || object2 == null;
    }

    @SafeVarargs
    public static <T> boolean isAnyNull(T ... objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> @NonNull T nonNullAssert(@Nullable T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static <T> @NonNull T nonNullElse(@Nullable T object, @NonNull T elseObj) {
        return object != null ? object : elseObj;
    }

    public static <T> @NonNull T nonNullElse(@Nullable T object, Supplier<? extends @NonNull T> elseSupplier) {
        return object != null ? object : elseSupplier.get();
    }

    public static <T> @NonNull T nonNullLateInit() {
        return null;
    }

    public static <T> @Nullable T nullable(@Nullable T object) {
        return object;
    }

    private ObjectUtils() {
    }

    public static class ToStringBuilder {
        private static final String INDENT = "  ";
        private static final String CONT_INDENT = "    ";
        private static final String LINE_PREFIX = "\n";
        private static final String PROP_PREFIX = "\n  ";
        private static final String PROP_ASSIGN = "= ";
        private static final Object NULL = "<null>";
        private final StringBuilder sb;
        private @Nullable Formatter formatter;

        public ToStringBuilder() {
            this.sb = new StringBuilder();
        }

        public ToStringBuilder(String name) {
            this.sb = new StringBuilder(name);
        }

        public ToStringBuilder(String name, Class<?> clazz) {
            this.sb = new StringBuilder(name);
            this.sb.append(" (");
            this.sb.append(clazz.getName());
            this.sb.append(")");
        }

        public ToStringBuilder(Class<?> defClazz, Class<?> clazz) {
            this(defClazz.getSimpleName(), clazz);
        }

        public ToStringBuilder(Class<?> defClazz) {
            this(defClazz.getSimpleName());
        }

        public StringBuilder getStringBuilder() {
            return this.sb;
        }

        public final void append(String s) {
            this.sb.append(s);
        }

        public final void append(String s, int begin, int end) {
            this.sb.append(s, begin, end);
        }

        public final void append(char c) {
            this.sb.append(c);
        }

        public final void append(int number) {
            this.sb.append(number);
        }

        public final void append(long number) {
            this.sb.append(number);
        }

        public final void append(char sep, String s) {
            this.sb.append(sep);
            this.sb.append(s);
        }

        public final void append(char sep, int number) {
            this.sb.append(sep);
            this.sb.append(number);
        }

        public final void append(char sep, long number) {
            this.sb.append(sep);
            this.sb.append(number);
        }

        public final void append(char open, String s, char close) {
            this.sb.append(open);
            this.sb.append(s);
            this.sb.append(close);
        }

        public final void append(char open, int number, char close) {
            this.sb.append(open);
            this.sb.append(number);
            this.sb.append(close);
        }

        public final void append(char open, long number, char close) {
            this.sb.append(open);
            this.sb.append(number);
            this.sb.append(close);
        }

        public final void appendFormat(String valueFormat, Object ... valueArgs) {
            Formatter formatter = this.formatter;
            if (formatter == null) {
                this.formatter = formatter = new Formatter(this.sb, Locale.ENGLISH);
            }
            formatter.format(valueFormat, valueArgs);
        }

        public final void appendLines(String lines) {
            this.appendLines(lines, "\n    ");
        }

        public final void appendLines(char sep, String lines) {
            this.sb.append(sep);
            this.appendLines(lines, "\n    ");
        }

        public final void appendLines(List<@NonNull String> lines) {
            int n = lines.size();
            if (n == 0) {
                return;
            }
            this.append(lines.get(0));
            int i = 1;
            while (i < n) {
                this.append("\n    ");
                lines.get(i);
                ++i;
            }
        }

        private void appendLines(String s, String contPrefix) {
            int start = 0;
            int end = s.indexOf(10, start);
            if (end < 0) {
                this.append(s);
                return;
            }
            if (end > 0 && s.charAt(end - 1) == '\r') {
                this.append(s, start, end - 1);
            } else {
                this.append(s, start, end);
            }
            start = end + 1;
            while ((end = s.indexOf(10, start)) >= 0) {
                this.append(contPrefix);
                if (end > 0 && s.charAt(end - 1) == '\r') {
                    this.append(s, start, end - 1);
                } else {
                    this.append(s, start, end);
                }
                start = end + 1;
            }
            if (start < s.length()) {
                this.append(contPrefix);
                this.append(s, start, s.length());
            }
        }

        public void addProp(String name) {
            this.sb.append(PROP_PREFIX);
            this.sb.append(name);
            this.sb.append(PROP_ASSIGN);
        }

        public void addProp(String name, @Nullable String value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            this.appendLines(value, "\n      ");
        }

        public void addProp(String name, boolean value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, int value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, long value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, float value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, double value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, @Nullable Object value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            this.appendLines(value.toString(), "\n      ");
        }

        public void addProp(String name, @Nullable Collection<?> value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            if (value instanceof List) {
                this.sb.append('[');
            } else {
                this.sb.append('{');
            }
            if (!value.isEmpty()) {
                for (Object e : value) {
                    this.sb.append("\n    ");
                    if (e == null) {
                        this.sb.append(NULL);
                        continue;
                    }
                    this.appendLines(e.toString(), "\n        ");
                }
                this.sb.append(PROP_PREFIX);
            }
            if (value instanceof List) {
                this.sb.append(']');
            } else {
                this.sb.append('}');
            }
        }

        public void addProp(String name, String valueFormat, Object ... valueArgs) {
            this.addProp(name);
            this.appendFormat(valueFormat, valueArgs);
        }

        public String build() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

