/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractComplexStore;
import org.eclipse.statet.rj.data.impl.AbstractLogicalStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;
import org.eclipse.statet.rj.data.impl.AbstractRawStore;

public abstract class AbstractCharacterStore
extends AbstractRStore<String>
implements RCharacterStore {
    protected static final boolean toLogi(String character) {
        switch (character.length()) {
            case 1: {
                switch (character.charAt(0)) {
                    case 'F': {
                        return false;
                    }
                    case 'T': {
                        return true;
                    }
                }
                break;
            }
            case 4: {
                if (!"true".regionMatches(0, character, 0, 4)) break;
                return true;
            }
            case 5: {
                if (!"false".regionMatches(0, character, 0, 5)) break;
                return false;
            }
        }
        throw new NumberFormatException(character);
    }

    @Override
    public final byte getStoreType() {
        return 5;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "character";
    }

    @Override
    public void setLogi(int idx, boolean logi) {
        this.setChar(idx, AbstractLogicalStore.toChar(logi));
    }

    @Override
    public void setLogi(long idx, boolean logi) {
        this.setChar(idx, AbstractLogicalStore.toChar(logi));
    }

    @Override
    public boolean getLogi(int idx) {
        return AbstractCharacterStore.toLogi(this.getChar(idx));
    }

    @Override
    public boolean getLogi(long idx) {
        return AbstractCharacterStore.toLogi(this.getChar(idx));
    }

    @Override
    public final void setInt(int idx, int integer) {
        this.setChar(idx, Integer.toString(integer));
    }

    @Override
    public final void setInt(long idx, int integer) {
        this.setChar(idx, Integer.toString(integer));
    }

    @Override
    public void setCplx(int idx, double real, double imaginary) {
        this.setChar(idx, AbstractComplexStore.toChar(real, imaginary));
    }

    @Override
    public void setCplx(long idx, double real, double imaginary) {
        this.setChar(idx, AbstractComplexStore.toChar(real, imaginary));
    }

    @Override
    public final void setRaw(int idx, byte raw) {
        this.setChar(idx, AbstractRawStore.toChar(raw));
    }

    @Override
    public final void setRaw(long idx, byte raw) {
        this.setChar(idx, AbstractRawStore.toChar(raw));
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        return this.indexOf(Integer.toString(integer), fromIdx);
    }

    @Override
    public abstract String[] toArray();

    @Override
    public boolean allEqual(RStore<?> other) {
        long length = this.getLength();
        if (5 != other.getStoreType() || length != other.getLength()) {
            return false;
        }
        if (length < 0L) {
            return true;
        }
        if (length <= Integer.MAX_VALUE) {
            int ilength = (int)length;
            int idx = 0;
            while (idx < ilength) {
                if (this.isNA(idx) ? !other.isNA(idx) : !this.getChar(idx).equals(other.getChar(idx))) {
                    return false;
                }
                ++idx;
            }
        } else {
            long idx = 0L;
            while (idx < length) {
                if (this.isNA(idx) ? !other.isNA(idx) : !this.getChar(idx).equals(other.getChar(idx))) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }
}

