/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.workspace;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.ui.components.TreeAndListGroup;
import org.eclipse.statet.ecommons.ui.workbench.workspace.AbstractResourceSelectionDialog;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceContentProvider;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourceFileSelectionDialog
extends AbstractResourceSelectionDialog<IFile> {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 100;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 20;
    private TreeAndListGroup selectionGroup;

    public ResourceFileSelectionDialog(Shell parent, String message) {
        super(parent);
        this.setTitle(Messages.ResourceSelectionDialog_title);
        this.setMessage(message);
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.ResourceSelectionDialog_SelectContainer_message;
    }

    @Override
    protected int getResourceTypes() {
        return 1;
    }

    public void addFileFilter(String label, String fileNamePattern) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        TreeAndListGroup group = new TreeAndListGroup(composite, this.getRootElement(), (ITreeContentProvider)new ResourceContentProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)new ResourceContentProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ViewerComparator)new ResourceComparator(1), false);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(100);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        group.getControl().setLayoutData((Object)gd);
        this.selectionGroup = group;
        this.selectionGroup.addSelectionChangedListener(this.createSelectionChangeListener());
        this.selectionGroup.addDoubleClickListener(this.createSelectionDoubleClickListener());
        this.createTextField(composite);
        return composite;
    }

    @Override
    protected void initSelection(List<IResource> checkedResources) {
        IResource resource = checkedResources.get(0);
        if (resource instanceof IFile) {
            this.selectionGroup.selectListElement(resource);
        } else {
            this.selectionGroup.selectTreeElement(resource);
        }
    }

    @Override
    protected void initDialog() {
        this.selectionGroup.initFields();
        super.initDialog();
    }
}

