/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IIndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableStore;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RList;

@NonNullByDefault
public class RListValue
extends RElementVariableValue<CombinedRList>
implements IRIndexValueInternal {
    protected static final VariablePartitionFactory<IRIndexElementValue> LIST_PARTITION_FACTORY = new VariablePartitionFactory<IRIndexElementValue>(){

        protected IRVariable createPartition(IRIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            return new RListPartition(value, partition);
        }
    };
    private final RElementVariableStore childVariables;

    public RListValue(RElementVariable variable) {
        super(variable);
        this.childVariables = new RElementVariableStore(((CombinedRList)this.element).getLength());
    }

    public final @Nullable RListValue getVariablePreviousValue() {
        return (RListValue)this.variable.getPreviousValue();
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return ((CombinedRList)this.element).getRClassName();
    }

    @Override
    public String getValueString() throws DebugException {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(((CombinedRList)this.element).getLength());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDetailString() {
        return "";
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return ((CombinedRList)this.element).hasModelChildren(null);
    }

    @Override
    public @NonNull IVariable[] getVariables() throws DebugException {
        return this.getPartitionFactory().getVariables((IIndexedValue)this);
    }

    @Override
    public final VariablePartitionFactory<IRIndexElementValue> getPartitionFactory() {
        return LIST_PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return ((CombinedRList)this.element).getLength();
    }

    public @NonNull IRVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this.variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IRVariable[] getVariables(long offset, int length, IRVariable parent) {
        RListValue previousValue;
        Object object = this.variable;
        synchronized (object) {
            if (this != this.variable.getCurrentValue()) {
                return NO_VARIABLES;
            }
            previousValue = this.getVariablePreviousValue();
        }
        object = this.childVariables;
        synchronized (object) {
            @NonNull IRVariable[] variables = new IRVariable[length];
            boolean direct = parent == this.variable;
            int i = 0;
            while (i < length) {
                long idx = offset + (long)i;
                RElementVariable childVariable = this.childVariables.get(idx);
                if (childVariable == null) {
                    CombinedRElement childElement = ((CombinedRList)this.element).get(idx);
                    if (previousValue != null) {
                        childVariable = this.checkPreviousVariable(previousValue, idx, childElement);
                    }
                    if (childVariable == null) {
                        childVariable = new RElementVariable(childElement, this.variable.getThread(), this.stamp, this.variable);
                    }
                    this.childVariables.set(idx, childVariable);
                }
                variables[i] = direct ? childVariable : RVariableProxy.create(childVariable, parent);
                ++i;
            }
            return variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable RElementVariable checkPreviousVariable(RListValue previousValue, long idx, CombinedRElement element) {
        if (idx >= 0L && idx < ((CombinedRList)previousValue.element).getLength()) {
            RElementVariable previousVariable;
            RListValue rListValue = previousValue;
            synchronized (rListValue) {
                previousVariable = previousValue.childVariables.clear(idx);
            }
            if (previousVariable != null && previousVariable.update(element, this.stamp)) {
                return previousVariable;
            }
        }
        return null;
    }

    protected static class ByName
    extends RListValue {
        public ByName(RElementVariable variable) {
            super(variable);
        }

        @Override
        protected @Nullable RElementVariable checkPreviousVariable(RListValue previousValue, long idx, CombinedRElement element) {
            RCharacterStore names = ((CombinedRList)previousValue.element).getNames();
            if (names != null) {
                return super.checkPreviousVariable(previousValue, names.indexOf(((CombinedRList)this.element).getName(idx)), element);
            }
            return null;
        }
    }

    protected static class RListPartition
    extends RElementValue.RVariablePartition {
        public RListPartition(IRIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            super(value, partition);
        }

        protected @Nullable String getNameIndexLabel(long idx) {
            return ((RList)((IRIndexElementValue)this.value).getElement()).getName(idx);
        }
    }
}

