/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public final class DeactivateFiltersCommand
extends RecordingCommand {
    private final Collection<FilterDescription> oldElements;
    private final DDiagram diagram;

    public DeactivateFiltersCommand(TransactionalEditingDomain domain, DDiagram diagram, Collection<FilterDescription> oldElements) {
        super(domain, Messages.DeactivateFiltersCommand_label);
        this.oldElements = oldElements;
        this.diagram = diagram;
    }

    protected void doExecute() {
        if (this.diagram == null || this.oldElements == null) {
            return;
        }
        for (FilterDescription filter : this.oldElements) {
            this.diagram.getActivatedFilters().remove((Object)filter);
        }
        if (this.oldElements.size() > 0) {
            ConcernService.resetCurrentConcern((DDiagram)this.diagram);
            NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)5);
        }
    }
}

