/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.diagram.ui.business.internal.image.ImageSelectorDescriptor;

public final class ImageSelectorDescriptorRegistry {
    private static final List<ImageSelectorDescriptor> EXTENSIONS = new ArrayList<ImageSelectorDescriptor>();
    private static final Map<String, ImageSelectorDescriptor> ID_TO_DESCRITPOR_MAP = new HashMap<String, ImageSelectorDescriptor>();

    private ImageSelectorDescriptorRegistry() {
    }

    public static void addExtension(ImageSelectorDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRITPOR_MAP.put(extension.getId(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRITPOR_MAP.clear();
    }

    public static List<ImageSelectorDescriptor> getRegisteredExtensions() {
        return new ArrayList<ImageSelectorDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (ImageSelectorDescriptor extension : ImageSelectorDescriptorRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRITPOR_MAP.remove(extension.getId());
        }
    }

    public static ImageSelectorDescriptor getDescriptorFromId(String id) {
        return ID_TO_DESCRITPOR_MAP.get(id);
    }
}

