/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.display;

import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.internal.helper.display.CreationDisplayServiceImpl;
import org.eclipse.sirius.diagram.business.internal.helper.display.DisplayAllDisplayServiceImpl;
import org.eclipse.sirius.diagram.business.internal.helper.display.DisplayServiceImpl;

public final class DisplayServiceManagerImpl
implements DisplayServiceManager {
    private static DisplayService defaultService = DisplayServiceImpl.init();
    private static DisplayService displayAllService = DisplayAllDisplayServiceImpl.init();
    private static DisplayService displayCreationService = CreationDisplayServiceImpl.init();
    private DisplayService service = defaultService;
    private DisplayMode mode = DisplayMode.NORMAL;

    private DisplayServiceManagerImpl() {
    }

    public static DisplayServiceManager init() {
        return new DisplayServiceManagerImpl();
    }

    @Override
    public DisplayService getDisplayService() {
        return this.service;
    }

    @Override
    public void activateMode(DisplayMode modeToActivate) {
        this.mode = modeToActivate;
        switch (this.mode) {
            case ALL_IS_DISPLAYED: {
                this.service = displayAllService;
                break;
            }
            case CREATION: {
                this.service = displayCreationService;
                break;
            }
            case NORMAL: {
                this.service = defaultService;
                break;
            }
        }
    }

    @Override
    public DisplayMode getMode() {
        return this.mode;
    }

    @Override
    public DisplayService getDisplayService(DisplayMode wantedMode) {
        DisplayService wantedService = null;
        switch (wantedMode) {
            case ALL_IS_DISPLAYED: {
                wantedService = displayAllService;
                break;
            }
            case CREATION: {
                wantedService = displayCreationService;
                break;
            }
            case NORMAL: {
                wantedService = defaultService;
                break;
            }
        }
        return wantedService;
    }
}

