/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.components.SimpleRowGraphPlacer;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public class ModelOrderRowGraphPlacer
extends SimpleRowGraphPlacer {
    @Override
    public void sortComponents(List<LGraph> components, LGraph target) {
    }

    @Override
    public void placeComponents(List<LGraph> components, LGraph target, double maxRowWidth, double componentSpacing) {
        double xpos = 0.0;
        double ypos = 0.0;
        double highestBox = 0.0;
        double broadestRow = componentSpacing;
        LGraph lastComponent = null;
        double startXOfRow = 0.0;
        for (LGraph graph : components) {
            KVector size = graph.getSize();
            if (xpos + size.x > maxRowWidth && !((Set)graph.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)).contains(PortSide.NORTH) || lastComponent != null && ((Set)lastComponent.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)).contains(PortSide.EAST) || ((Set)graph.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)).contains(PortSide.WEST)) {
                xpos = startXOfRow;
                ypos += highestBox + componentSpacing;
                highestBox = 0.0;
            }
            KVector offset = graph.getOffset();
            if (((Set)graph.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)).contains(PortSide.NORTH)) {
                xpos = broadestRow + componentSpacing;
            }
            this.offsetGraph(graph, xpos + offset.x, ypos + offset.y);
            broadestRow = Math.max(broadestRow, xpos + size.x);
            if (((Set)graph.getProperty(InternalProperties.EXT_PORT_CONNECTIONS)).contains(PortSide.SOUTH)) {
                startXOfRow = Math.max(startXOfRow, xpos + size.x + componentSpacing);
            }
            offset.reset();
            highestBox = Math.max(highestBox, size.y);
            xpos += size.x + componentSpacing;
            lastComponent = graph;
        }
        target.getSize().x = broadestRow;
        target.getSize().y = ypos + highestBox;
    }
}

