/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.elk.ApplyLayoutRequest;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutConnector;
import org.eclipse.sirius.diagram.elk.GmfLayoutCommand;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;

public class GmfLayoutEditPolicy
extends AbstractEditPolicy {
    private Map<ElkEdgeSection, PrecisionPointList> pointListMap = new HashMap<ElkEdgeSection, PrecisionPointList>();
    private static final int SOURCE_LOCATION = 85;
    private static final int MIDDLE_LOCATION = 50;
    private static final int TARGET_LOCATION = 15;
    private static final String SPLINE_CONNECTION = "org.eclipse.elk.core.model.gmf.figures.SplineConnection";

    public boolean understandsRequest(Request req) {
        return "apply layout".equals(req.getType());
    }

    public Command getCommand(Request request) {
        if ("apply layout".equals(request.getType())) {
            if (request instanceof ApplyLayoutRequest) {
                ApplyLayoutRequest layoutRequest = (ApplyLayoutRequest)request;
                IGraphicalEditPart hostEditPart = (IGraphicalEditPart)this.getHost();
                GmfLayoutCommand command = new GmfLayoutCommand(hostEditPart.getEditingDomain(), "Automatic Layout", (IAdaptable)new EObjectAdapter((EObject)((View)hostEditPart.getModel())));
                double scale = layoutRequest.getScale();
                for (Pair<ElkGraphElement, IGraphicalEditPart> layoutPair : layoutRequest.getElements()) {
                    if (layoutPair.getFirst() instanceof ElkNode) {
                        this.addShapeLayout(command, (ElkShape)layoutPair.getFirst(), (IGraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof ElkPort) {
                        this.addShapeLayout(command, (ElkShape)((ElkPort)layoutPair.getFirst()), (IGraphicalEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (layoutPair.getFirst() instanceof ElkEdge) {
                        this.addEdgeLayout(command, (ElkEdge)layoutPair.getFirst(), (ConnectionEditPart)layoutPair.getSecond(), scale);
                        continue;
                    }
                    if (!(layoutPair.getFirst() instanceof ElkLabel)) continue;
                    this.addLabelLayout(command, (ElkLabel)layoutPair.getFirst(), (GraphicalEditPart)layoutPair.getSecond(), scale);
                }
                if (layoutRequest.getElements().size() > 0) {
                    ElkGraphElement graphElement = (ElkGraphElement)layoutRequest.getElements().get(0).getFirst();
                    ElkNode rootElement = ElkGraphUtil.containingGraph((ElkGraphElement)graphElement);
                    if (rootElement == null && graphElement instanceof ElkNode) {
                        rootElement = (ElkNode)graphElement;
                    }
                    if (rootElement != null) {
                        EdgeRouting edgeRouting = (EdgeRouting)rootElement.getProperty(CoreOptions.EDGE_ROUTING);
                        if (edgeRouting.equals((Object)EdgeRouting.ORTHOGONAL)) {
                            command.setRoutingToForce(Routing.RECTILINEAR_LITERAL);
                        } else {
                            command.setRoutingToForce(Routing.MANUAL_LITERAL);
                        }
                    }
                }
                this.pointListMap.clear();
                return new ICommandProxy((ICommand)command);
            }
            return null;
        }
        return super.getCommand(request);
    }

    private void addShapeLayout(GmfLayoutCommand command, ElkShape elkShape, IGraphicalEditPart editPart, double scale) {
        LabelAlignment labelAlignment;
        DDiagramElement dde;
        Style style;
        PrecisionDimension newSize;
        View view = (View)editPart.getModel();
        PrecisionPoint newLocation = new PrecisionPoint(elkShape.getX() * scale, elkShape.getY() * scale);
        if (view instanceof Node && !(elkShape instanceof ElkPort) && !this.isRegion(editPart)) {
            newLocation.translate(GMFHelper.getContainerTopLeftInsets((Node)((Node)view), (boolean)true).getNegated());
        }
        if (this.isRegionContainer(editPart)) {
            newSize = new PrecisionDimension(-1.0, -1.0);
        } else {
            double shadowBorderSize = ElkDiagramLayoutConnector.getShadowBorderSize((EditPart)editPart);
            newSize = new PrecisionDimension((elkShape.getWidth() + shadowBorderSize) * scale, (elkShape.getHeight() + shadowBorderSize) * scale);
        }
        EObject siriusObject = editPart.resolveSemanticElement();
        if (siriusObject instanceof DDiagramElement && siriusObject instanceof DNodeContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)((DNodeContainer)siriusObject)).isRegionInVerticalStack() && (style = (dde = (DDiagramElement)siriusObject).getStyle()) instanceof LabelStyle && ((labelAlignment = ((LabelStyle)style).getLabelAlignment()).equals((Object)LabelAlignment.LEFT) || labelAlignment.equals((Object)LabelAlignment.RIGHT))) {
            newSize.setPreciseWidth(newSize.preciseWidth() + newLocation.preciseX() * 2.0);
            newLocation.setX(0);
        }
        Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        if (oldx != null && oldy != null && newLocation.x == (Integer)oldx && newLocation.y == (Integer)oldy) {
            newLocation = null;
        }
        Object oldWidth = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Object oldHeight = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (oldWidth != null && oldHeight != null && newSize.width == (Integer)oldWidth && newSize.height == (Integer)oldHeight) {
            newSize = null;
        }
        if (newLocation != null || newSize != null) {
            command.addShapeLayout(view, (Point)newLocation, (Dimension)newSize);
        }
    }

    private boolean isRegion(IGraphicalEditPart editPart) {
        EObject siriusObject = editPart.resolveSemanticElement();
        if (siriusObject instanceof DDiagramElementContainer) {
            return new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)siriusObject).isRegion();
        }
        return false;
    }

    private boolean isRegionContainer(IGraphicalEditPart editPart) {
        EObject siriusObject = editPart.resolveSemanticElement();
        if (siriusObject instanceof DNodeContainer) {
            return new DNodeContainerExperimentalQuery((DNodeContainer)siriusObject).isRegionContainer();
        }
        return false;
    }

    private void addEdgeLayout(GmfLayoutCommand command, ElkEdge elkEdge, ConnectionEditPart connectionEditPart, double scale) {
        ElkEdge secondPartOfEdge = (ElkEdge)elkEdge.getProperty(ElkDiagramLayoutConnector.SECOND_PART_OF_SPLIT_EDGE);
        if (secondPartOfEdge != null) {
            ElkEdgeSection firstSection = (ElkEdgeSection)elkEdge.getSections().get(0);
            ElkEdgeSection secondSection = (ElkEdgeSection)secondPartOfEdge.getSections().get(0);
            boolean firstPointOfSecondPartAfterStartPoint = true;
            int firstSectionRoundEndY = (int)Math.round(firstSection.getEndY());
            int firstSectionRoundEndX = (int)Math.round(firstSection.getEndX());
            for (ElkBendPoint elkBendPoint : secondSection.getBendPoints()) {
                if (firstPointOfSecondPartAfterStartPoint) {
                    int secondSectionRoundFirstBendpointY = (int)Math.round(elkBendPoint.getY());
                    int secondSectionRoundFirstBendpointX = (int)Math.round(elkBendPoint.getX());
                    if (secondSectionRoundFirstBendpointY - 1 <= firstSectionRoundEndY && firstSectionRoundEndY <= secondSectionRoundFirstBendpointY + 1) {
                        if (firstSection.getBendPoints().isEmpty()) {
                            firstSection.setStartY((double)firstSectionRoundEndY);
                        } else {
                            ((ElkBendPoint)firstSection.getBendPoints().get(firstSection.getBendPoints().size() - 1)).setY((double)firstSectionRoundEndY);
                        }
                        ElkGraphUtil.createBendPoint((ElkEdgeSection)firstSection, (double)elkBendPoint.getX(), (double)firstSectionRoundEndY);
                    } else if (secondSectionRoundFirstBendpointX - 1 <= firstSectionRoundEndX && firstSectionRoundEndX <= secondSectionRoundFirstBendpointX + 1) {
                        if (firstSection.getBendPoints().isEmpty()) {
                            firstSection.setStartX((double)firstSectionRoundEndX);
                        } else {
                            ((ElkBendPoint)firstSection.getBendPoints().get(firstSection.getBendPoints().size() - 1)).setX((double)firstSectionRoundEndX);
                        }
                        ElkGraphUtil.createBendPoint((ElkEdgeSection)firstSection, (double)Math.round(firstSection.getEndX()), (double)elkBendPoint.getY());
                    }
                    firstPointOfSecondPartAfterStartPoint = false;
                    continue;
                }
                ElkGraphUtil.createBendPoint((ElkEdgeSection)firstSection, (double)elkBendPoint.getX(), (double)elkBendPoint.getY());
            }
            if (firstPointOfSecondPartAfterStartPoint) {
                int secondSectionRoundEndX = (int)Math.round(secondSection.getEndX());
                int secondSectionRoundEndY = (int)Math.round(secondSection.getEndY());
                if (secondSectionRoundEndY - 1 <= firstSectionRoundEndY && firstSectionRoundEndY <= secondSectionRoundEndY + 1) {
                    if (firstSection.getBendPoints().isEmpty()) {
                        firstSection.setStartY((double)firstSectionRoundEndY);
                    } else {
                        ((ElkBendPoint)firstSection.getBendPoints().get(firstSection.getBendPoints().size() - 1)).setY((double)firstSectionRoundEndY);
                    }
                    firstSection.setEndX(secondSection.getEndX());
                    firstSection.setEndY((double)firstSectionRoundEndY);
                } else if (secondSectionRoundEndX - 1 <= firstSectionRoundEndX && firstSectionRoundEndX <= secondSectionRoundEndX + 1) {
                    if (firstSection.getBendPoints().isEmpty()) {
                        firstSection.setStartX((double)firstSectionRoundEndX);
                    } else {
                        ((ElkBendPoint)firstSection.getBendPoints().get(firstSection.getBendPoints().size() - 1)).setX((double)firstSectionRoundEndX);
                    }
                    firstSection.setEndX((double)firstSectionRoundEndX);
                    firstSection.setEndY(secondSection.getEndY());
                }
            } else {
                firstSection.setEndX(secondSection.getEndX());
                firstSection.setEndY(secondSection.getEndY());
            }
            elkEdge.getTargets().add(0, (Object)((ElkConnectableShape)secondPartOfEdge.getTargets().get(0)));
        }
        if (connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null) {
            SlidableAnchor targetAnchor;
            SlidableAnchor sourceAnchor;
            PointList currentEdgeBendpoints = this.getBendPoints(elkEdge, connectionEditPart.getFigure(), scale);
            INodeEditPart sourceEditPart = (INodeEditPart)connectionEditPart.getSource();
            if (!"virtualNodeForEdgeToEdgeCase".equals(((ElkConnectableShape)elkEdge.getSources().get(0)).getIdentifier())) {
                KVector sourceRel = this.getRelativeSourcePoint(elkEdge);
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure(), new PrecisionPoint(sourceRel.x, sourceRel.y));
            } else {
                currentEdgeBendpoints = this.cutEdgeOnEdge(elkEdge, connectionEditPart, scale, true);
                PrecisionPointList sourceEdgePointsListInAsboluteCoordinates = this.getPointListInAbsoluteCoordinates(this.searchEdgeWithSecondPartProperty((EList<ElkEdge>)((ElkConnectableShape)elkEdge.getSources().get(0)).getIncomingEdges()));
                Rectangle absoluteBounds = sourceEdgePointsListInAsboluteCoordinates.getBounds();
                if (absoluteBounds.width() == 0) {
                    absoluteBounds.setWidth(1);
                } else if (absoluteBounds.height() == 0) {
                    absoluteBounds.setHeight(1);
                }
                Point absoluteOrigin = absoluteBounds.getTopLeft();
                KVector relativeOrigin = ElkUtil.toRelative((KVector)new KVector(absoluteOrigin.preciseX(), absoluteOrigin.preciseY()), (ElkNode)elkEdge.getContainingNode());
                PrecisionPoint sourceAnchorPoint = BaseSlidableAnchor.getAnchorRelativeLocation((Point)currentEdgeBendpoints.getFirstPoint(), (Rectangle)new PrecisionRectangle(relativeOrigin.x, relativeOrigin.y, (double)absoluteBounds.width(), (double)absoluteBounds.height()));
                sourceAnchor = new SlidableAnchor(sourceEditPart.getFigure(), sourceAnchorPoint);
            }
            String sourceTerminal = sourceEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)sourceAnchor);
            INodeEditPart targetEditPart = (INodeEditPart)connectionEditPart.getTarget();
            if (!"virtualNodeForEdgeToEdgeCase".equals(((ElkConnectableShape)elkEdge.getTargets().get(0)).getIdentifier())) {
                KVector targetRel = this.getRelativeTargetPoint(elkEdge);
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure(), new PrecisionPoint(targetRel.x, targetRel.y));
            } else {
                currentEdgeBendpoints = this.cutEdgeOnEdge(elkEdge, connectionEditPart, scale, false);
                PrecisionPointList targetEdgePointsListInAsboluteCoordinates = this.getPointListInAbsoluteCoordinates(this.searchEdgeWithSecondPartProperty((EList<ElkEdge>)((ElkConnectableShape)elkEdge.getTargets().get(0)).getIncomingEdges()));
                Rectangle absoluteBounds = targetEdgePointsListInAsboluteCoordinates.getBounds();
                if (absoluteBounds.width() == 0) {
                    absoluteBounds.setWidth(1);
                } else if (absoluteBounds.height() == 0) {
                    absoluteBounds.setHeight(1);
                }
                Point absoluteOrigin = absoluteBounds.getTopLeft();
                KVector relativeOrigin = ElkUtil.toRelative((KVector)new KVector(absoluteOrigin.preciseX(), absoluteOrigin.preciseY()), (ElkNode)elkEdge.getContainingNode());
                PrecisionPoint targetAnchorPoint = BaseSlidableAnchor.getAnchorRelativeLocation((Point)currentEdgeBendpoints.getLastPoint(), (Rectangle)new Rectangle((int)Math.round(relativeOrigin.x), (int)Math.round(relativeOrigin.y), absoluteBounds.width(), absoluteBounds.height()));
                targetAnchor = new SlidableAnchor(targetEditPart.getFigure(), targetAnchorPoint);
            }
            String targetTerminal = targetEditPart.mapConnectionAnchorToTerminal((ConnectionAnchor)targetAnchor);
            KVectorChain junctionPoints = (KVectorChain)elkEdge.getProperty(CoreOptions.JUNCTION_POINTS);
            String serializedJP = null;
            if (junctionPoints != null) {
                for (KVector point : junctionPoints) {
                    ElkUtil.toAbsolute((KVector)point, (ElkNode)elkEdge.getContainingNode());
                }
                serializedJP = junctionPoints.toString();
            }
            command.addEdgeLayout((Edge)connectionEditPart.getModel(), currentEdgeBendpoints, sourceTerminal, targetTerminal, serializedJP);
        }
    }

    private PrecisionPointList getPointListInAbsoluteCoordinates(ElkEdge edge) {
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        PrecisionPointList edgePointsListInAsboluteCoordinates = new PrecisionPointList();
        KVector absolutePoint = ElkUtil.toAbsolute((KVector)new KVector(edgeSection.getStartX(), edgeSection.getStartY()), (ElkNode)edge.getContainingNode());
        edgePointsListInAsboluteCoordinates.addPrecisionPoint(absolutePoint.x, absolutePoint.y);
        for (ElkBendPoint elkBendpoint : edgeSection.getBendPoints()) {
            absolutePoint = ElkUtil.toAbsolute((KVector)new KVector(elkBendpoint.getX(), elkBendpoint.getY()), (ElkNode)edge.getContainingNode());
            edgePointsListInAsboluteCoordinates.addPrecisionPoint(absolutePoint.x, absolutePoint.y);
        }
        absolutePoint = ElkUtil.toAbsolute((KVector)new KVector(edgeSection.getEndX(), edgeSection.getEndY()), (ElkNode)edge.getContainingNode());
        edgePointsListInAsboluteCoordinates.addPrecisionPoint(absolutePoint.x, absolutePoint.y);
        return edgePointsListInAsboluteCoordinates;
    }

    private PointList cutEdgeOnEdge(ElkEdge elkEdgeToCut, ConnectionEditPart connectionEditPart, double scale, boolean sourceIsAnotherEdge) {
        PrecisionPoint origin;
        LineSeg lineSegToCutInAbsolute;
        ElkBendPoint otherPoint;
        PrecisionPoint junctionPoint = new PrecisionPoint();
        ElkEdgeSection sectionToCut = (ElkEdgeSection)elkEdgeToCut.getSections().get(0);
        if (sourceIsAnotherEdge) {
            junctionPoint = new PrecisionPoint(sectionToCut.getStartX(), sectionToCut.getStartY());
            if (sectionToCut.getBendPoints().size() > 0) {
                otherPoint = (ElkBendPoint)sectionToCut.getBendPoints().get(0);
                lineSegToCutInAbsolute = new LineSeg((Point)junctionPoint, (Point)new PrecisionPoint(otherPoint.getX(), otherPoint.getY()));
            } else {
                lineSegToCutInAbsolute = new LineSeg((Point)junctionPoint, (Point)new PrecisionPoint(sectionToCut.getEndX(), sectionToCut.getEndY()));
            }
        } else {
            junctionPoint = new PrecisionPoint(((ElkEdgeSection)elkEdgeToCut.getSections().get(0)).getEndX(), ((ElkEdgeSection)elkEdgeToCut.getSections().get(0)).getEndY());
            if (sectionToCut.getBendPoints().size() > 0) {
                otherPoint = (ElkBendPoint)sectionToCut.getBendPoints().get(sectionToCut.getBendPoints().size() - 1);
                lineSegToCutInAbsolute = new LineSeg((Point)junctionPoint, (Point)new PrecisionPoint(otherPoint.getX(), otherPoint.getY()));
            } else {
                lineSegToCutInAbsolute = new LineSeg((Point)junctionPoint, (Point)new PrecisionPoint(sectionToCut.getStartX(), sectionToCut.getStartY()));
            }
        }
        KVector absolutePoint = ElkUtil.toAbsolute((KVector)new KVector(lineSegToCutInAbsolute.getOrigin().preciseX(), lineSegToCutInAbsolute.getOrigin().preciseY()), (ElkNode)elkEdgeToCut.getContainingNode());
        lineSegToCutInAbsolute.setOrigin((Point)new PrecisionPoint(absolutePoint.x, absolutePoint.y));
        absolutePoint = ElkUtil.toAbsolute((KVector)new KVector(lineSegToCutInAbsolute.getTerminus().preciseX(), lineSegToCutInAbsolute.getTerminus().preciseY()), (ElkNode)elkEdgeToCut.getContainingNode());
        lineSegToCutInAbsolute.setTerminus((Point)new PrecisionPoint(absolutePoint.x, absolutePoint.y));
        ElkEdge sourceOrTargetEdge = sourceIsAnotherEdge ? this.searchEdgeWithSecondPartProperty((EList<ElkEdge>)((ElkConnectableShape)elkEdgeToCut.getSources().get(0)).getIncomingEdges()) : this.searchEdgeWithSecondPartProperty((EList<ElkEdge>)((ElkConnectableShape)elkEdgeToCut.getTargets().get(0)).getIncomingEdges());
        PrecisionPointList sourceOrTargetEdgePointsListInAsboluteCoordinates = this.getPointListInAbsoluteCoordinates(sourceOrTargetEdge);
        LineSeg sourceOrTargetEdgeLineSegInAbsolute = GmfLayoutEditPolicy.findNearestLineSegOfPoint((PointList)sourceOrTargetEdgePointsListInAsboluteCoordinates, (Point)junctionPoint);
        if (sourceOrTargetEdgeLineSegInAbsolute.isHorizontal()) {
            PrecisionPoint terminus;
            double yToUse = ((PrecisionPoint)sourceOrTargetEdgeLineSegInAbsolute.getOrigin()).preciseY();
            if (yToUse - 1.0 <= (origin = (PrecisionPoint)lineSegToCutInAbsolute.getOrigin()).preciseY() && origin.preciseY() <= yToUse + 1.0) {
                lineSegToCutInAbsolute.setOrigin((Point)new PrecisionPoint(origin.preciseX(), yToUse));
            }
            if (yToUse - 1.0 <= (terminus = (PrecisionPoint)lineSegToCutInAbsolute.getTerminus()).preciseY() && terminus.preciseY() <= yToUse + 1.0) {
                lineSegToCutInAbsolute.setTerminus((Point)new PrecisionPoint(terminus.preciseX(), yToUse));
            }
        } else if (sourceOrTargetEdgeLineSegInAbsolute.isVertical()) {
            PrecisionPoint terminus;
            double xToUse = ((PrecisionPoint)sourceOrTargetEdgeLineSegInAbsolute.getOrigin()).preciseX();
            if (xToUse - 1.0 <= (origin = (PrecisionPoint)lineSegToCutInAbsolute.getOrigin()).preciseX() && origin.preciseX() <= xToUse + 1.0) {
                lineSegToCutInAbsolute.setOrigin((Point)new PrecisionPoint(xToUse, origin.preciseY()));
            }
            if (xToUse - 1.0 <= (terminus = (PrecisionPoint)lineSegToCutInAbsolute.getTerminus()).preciseX() && terminus.preciseX() <= xToUse + 1.0) {
                lineSegToCutInAbsolute.setTerminus((Point)new PrecisionPoint(xToUse, terminus.preciseY()));
            }
        }
        PointList elkEdgeToCutPointList = this.getBendPoints(elkEdgeToCut, connectionEditPart.getFigure(), scale);
        if (sourceOrTargetEdgeLineSegInAbsolute.containsPoint(lineSegToCutInAbsolute.getTerminus(), 1)) {
            Point point;
            KVector relativeOriginPoint = ElkUtil.toRelative((KVector)new KVector(lineSegToCutInAbsolute.getTerminus().preciseX(), lineSegToCutInAbsolute.getTerminus().preciseY()), (ElkNode)elkEdgeToCut.getContainingNode());
            if (sourceIsAnotherEdge) {
                elkEdgeToCutPointList.removePoint(0);
                point = elkEdgeToCutPointList.getFirstPoint();
                if (sourceOrTargetEdgeLineSegInAbsolute.isHorizontal()) {
                    point.setY((int)Math.round(relativeOriginPoint.y));
                } else if (sourceOrTargetEdgeLineSegInAbsolute.isVertical()) {
                    point.setX((int)Math.round(relativeOriginPoint.x));
                }
                elkEdgeToCutPointList.setPoint(point, 0);
            } else {
                elkEdgeToCutPointList.removePoint(elkEdgeToCutPointList.size() - 1);
                point = elkEdgeToCutPointList.getLastPoint();
                if (sourceOrTargetEdgeLineSegInAbsolute.isHorizontal()) {
                    point.setY((int)Math.round(relativeOriginPoint.y));
                } else if (sourceOrTargetEdgeLineSegInAbsolute.isVertical()) {
                    point.setX((int)Math.round(relativeOriginPoint.x));
                }
                elkEdgeToCutPointList.setPoint(point, elkEdgeToCutPointList.size() - 1);
            }
        } else if (lineSegToCutInAbsolute.containsPoint(sourceOrTargetEdgeLineSegInAbsolute.getOrigin(), 1)) {
            KVector relativeOriginPoint = ElkUtil.toRelative((KVector)new KVector(sourceOrTargetEdgeLineSegInAbsolute.getOrigin().preciseX(), sourceOrTargetEdgeLineSegInAbsolute.getOrigin().preciseY()), (ElkNode)elkEdgeToCut.getContainingNode());
            if (sourceIsAnotherEdge) {
                elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint(relativeOriginPoint.x, relativeOriginPoint.y), 0);
            } else {
                elkEdgeToCutPointList.setPoint(sourceOrTargetEdgeLineSegInAbsolute.getOrigin(), elkEdgeToCutPointList.size() - 1);
            }
        } else if (lineSegToCutInAbsolute.containsPoint(sourceOrTargetEdgeLineSegInAbsolute.getTerminus(), 1)) {
            KVector relativeTerminusPoint = ElkUtil.toRelative((KVector)new KVector(sourceOrTargetEdgeLineSegInAbsolute.getTerminus().preciseX(), sourceOrTargetEdgeLineSegInAbsolute.getTerminus().preciseY()), (ElkNode)elkEdgeToCut.getContainingNode());
            if (sourceIsAnotherEdge) {
                elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint(relativeTerminusPoint.x, relativeTerminusPoint.y), 0);
                if (sourceOrTargetEdgeLineSegInAbsolute.isHorizontal()) {
                    elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint((double)elkEdgeToCutPointList.getPoint((int)1).x, relativeTerminusPoint.y), 1);
                } else if (sourceOrTargetEdgeLineSegInAbsolute.isVertical()) {
                    elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint(relativeTerminusPoint.x, (double)elkEdgeToCutPointList.getPoint((int)1).y), 1);
                }
            } else {
                elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint(relativeTerminusPoint.x, relativeTerminusPoint.y), elkEdgeToCutPointList.size() - 1);
                if (sourceOrTargetEdgeLineSegInAbsolute.isHorizontal()) {
                    elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint((double)elkEdgeToCutPointList.getPoint((int)(elkEdgeToCutPointList.size() - 2)).x, relativeTerminusPoint.y), elkEdgeToCutPointList.size() - 2);
                } else if (sourceOrTargetEdgeLineSegInAbsolute.isVertical()) {
                    elkEdgeToCutPointList.setPoint((Point)new PrecisionPoint(relativeTerminusPoint.x, (double)elkEdgeToCutPointList.getPoint((int)(elkEdgeToCutPointList.size() - 2)).y), elkEdgeToCutPointList.size() - 2);
                }
            }
        }
        return elkEdgeToCutPointList;
    }

    private ElkEdge searchEdgeWithSecondPartProperty(EList<ElkEdge> edges) {
        for (ElkEdge elkEdge : edges) {
            if (elkEdge.getProperty(ElkDiagramLayoutConnector.SECOND_PART_OF_SPLIT_EDGE) == null) continue;
            return elkEdge;
        }
        return null;
    }

    private KVector getRelativeSourcePoint(ElkEdge edge) {
        ElkConnectableShape sourceShape = (ElkConnectableShape)edge.getSources().get(0);
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        KVector sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
        ElkUtil.toAbsolute((KVector)sourcePoint, (ElkNode)edge.getContainingNode());
        GmfLayoutEditPolicy.toRelativeRound(sourcePoint, ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)sourceShape));
        if (sourceShape instanceof ElkPort) {
            ElkPort sourcePort = (ElkPort)sourceShape;
            sourcePoint.x = sourcePort.getWidth() <= 0.0 ? 0.0 : (sourcePoint.x - sourcePort.getX()) / sourcePort.getWidth();
            sourcePoint.y = sourcePort.getHeight() <= 0.0 ? 0.0 : (sourcePoint.y - sourcePort.getY()) / sourcePort.getHeight();
        } else {
            sourcePoint.x = sourceShape.getWidth() <= 0.0 ? 0.0 : (sourcePoint.x /= sourceShape.getWidth());
            sourcePoint.y = sourceShape.getHeight() <= 0.0 ? 0.0 : (sourcePoint.y /= sourceShape.getHeight());
        }
        return sourcePoint.bound(0.0, 0.0, 1.0, 1.0);
    }

    private KVector getRelativeTargetPoint(ElkEdge edge) {
        ElkConnectableShape targetShape = (ElkConnectableShape)edge.getTargets().get(0);
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        KVector targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
        ElkUtil.toAbsolute((KVector)targetPoint, (ElkNode)edge.getContainingNode());
        GmfLayoutEditPolicy.toRelativeRound(targetPoint, ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)targetShape));
        if (targetShape instanceof ElkPort) {
            ElkPort targetPort = (ElkPort)targetShape;
            targetPoint.x = targetPort.getWidth() <= 0.0 ? 0.0 : (targetPoint.x - targetPort.getX()) / targetPort.getWidth();
            targetPoint.y = targetPort.getHeight() <= 0.0 ? 0.0 : (targetPoint.y - targetPort.getY()) / targetPort.getHeight();
        } else {
            targetPoint.x = targetShape.getWidth() <= 0.0 ? 0.0 : (targetPoint.x /= targetShape.getWidth());
            targetPoint.y = targetShape.getHeight() <= 0.0 ? 0.0 : (targetPoint.y /= targetShape.getHeight());
        }
        return targetPoint.bound(0.0, 0.0, 1.0, 1.0);
    }

    private void addLabelLayout(GmfLayoutCommand command, ElkLabel klabel, GraphicalEditPart labelEditPart, double scale) {
        ElkGraphElement parent = klabel.getParent();
        if (parent instanceof ElkNode || parent instanceof ElkPort) {
            View view = (View)labelEditPart.getModel();
            int xpos = (int)(klabel.getX() * scale);
            int ypos = (int)(klabel.getY() * scale);
            Object oldx = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Object oldy = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            if (oldx == null || oldy == null || xpos != (Integer)oldx || ypos != (Integer)oldy) {
                command.addShapeLayout(view, new Point(xpos, ypos), null);
            }
            return;
        }
        if (parent instanceof ElkEdge) {
            int fromEnd;
            Rectangle targetBounds = new Rectangle(labelEditPart.getFigure().getBounds());
            targetBounds.setX((int)(klabel.getX() * scale));
            targetBounds.setY((int)(klabel.getY() * scale));
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)labelEditPart.getParent();
            PointList bendPoints = this.getBendPoints((ElkEdge)parent, connectionEditPart.getFigure(), scale);
            EObject modelElement = connectionEditPart.getNotationView().getElement();
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)klabel.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT);
            if (modelElement instanceof EReference && labelPlacement == EdgeLabelPlacement.TAIL) {
                bendPoints = bendPoints.getCopy();
                bendPoints.reverse();
            }
            int keyPoint = 4;
            if (labelEditPart instanceof LabelEditPart) {
                keyPoint = ((LabelEditPart)labelEditPart).getKeyPoint();
            }
            switch (keyPoint) {
                case 2: {
                    fromEnd = 85;
                    break;
                }
                case 3: {
                    fromEnd = 15;
                    break;
                }
                default: {
                    fromEnd = 50;
                }
            }
            Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)bendPoints, (int)0, (int)fromEnd, (boolean)true);
            Point normalPoint = GmfLayoutEditPolicy.offsetFromRelativeCoordinate(targetBounds, bendPoints, refPoint);
            if (normalPoint != null) {
                command.addShapeLayout((View)labelEditPart.getModel(), normalPoint, null);
            }
        }
    }

    private PointList getBendPoints(ElkEdge edge, IFigure edgeFigure, double scale) {
        ElkEdgeSection edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        PrecisionPointList pointList = this.pointListMap.get(edgeSection);
        if (pointList == null) {
            KVectorChain bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            boolean approx = GmfLayoutEditPolicy.handleSplineConnection(edgeFigure, (EdgeRouting)edge.getProperty(CoreOptions.EDGE_ROUTING));
            if (approx && bendPoints.size() >= 1) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(scale);
            pointList = new PrecisionPointList(bendPoints.size() + 2);
            for (KVector bendPoint : bendPoints) {
                pointList.addPrecisionPoint(bendPoint.x, bendPoint.y);
            }
            this.pointListMap.put(edgeSection, pointList);
        }
        return pointList;
    }

    private static boolean handleSplineConnection(IFigure edgeFigure, EdgeRouting edgeRouting) {
        boolean isSC;
        Class<?> clazz = edgeFigure.getClass();
        do {
            String canonicalName;
            isSC = (canonicalName = clazz.getCanonicalName()) != null && canonicalName.equals(SPLINE_CONNECTION);
            clazz = clazz.getSuperclass();
        } while (!isSC && clazz != null);
        if (isSC) {
            clazz = edgeFigure.getClass();
            try {
                if (edgeRouting == EdgeRouting.SPLINES) {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 1);
                } else {
                    clazz.getMethod("setSplineMode", Integer.TYPE).invoke((Object)edgeFigure, 0);
                }
                return false;
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
        return edgeRouting == EdgeRouting.SPLINES;
    }

    public static Point offsetFromRelativeCoordinate(Rectangle bounds, PointList points, Point therefPoint) {
        Point refPoint = therefPoint;
        if (refPoint == null) {
            refPoint = points.getFirstPoint();
        }
        bounds.translate(bounds.width / 2, bounds.height / 2);
        Point offset = new Point(bounds.x - refPoint.x, bounds.y - refPoint.y);
        if (points.size() == 1) {
            return offset;
        }
        if (points.size() >= 2) {
            int segIndex = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)points, (Point)refPoint);
            List segmentsList = PointListUtilities.getLineSegments((PointList)points);
            segIndex = segIndex <= 0 ? 0 : (segIndex > segmentsList.size() ? segmentsList.size() - 1 : --segIndex);
            LineSeg segment = (LineSeg)segmentsList.get(segIndex);
            Point normalOffset = null;
            if (segment.isHorizontal()) {
                if (segment.getOrigin().x > segment.getTerminus().x) {
                    normalOffset = offset.getNegated();
                    return normalOffset;
                }
                normalOffset = offset;
                return normalOffset;
            }
            if (segment.isVertical()) {
                if (segment.getOrigin().y < segment.getTerminus().y) {
                    normalOffset = offset.scale(-1.0, 1.0).transpose();
                    return normalOffset;
                }
                normalOffset = offset.scale(1.0, -1.0).transpose();
                return normalOffset;
            }
            Point offsetRefPoint = refPoint.getTranslated(offset);
            LineSeg parallelSeg = segment.getParallelLineSegThroughPoint(offsetRefPoint);
            Point p1 = parallelSeg.perpIntersect(refPoint.x, refPoint.y);
            double dx = p1.getDistance(offsetRefPoint) * (double)(p1.x > offsetRefPoint.x ? -1 : 1);
            double dy = p1.getDistance(refPoint) * (double)(p1.y < refPoint.y ? -1 : 1);
            PrecisionPoint orth = new PrecisionPoint(dx, dy);
            if (segment.getOrigin().x > segment.getTerminus().x) {
                orth = orth.scale(-1.0, -1.0);
            }
            return orth;
        }
        return null;
    }

    public static LineSeg findNearestLineSegOfPoint(PointList points, Point ptCoord) {
        int BIGDISTANCE = 32766;
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        ListIterator lineIter = mySegments.listIterator();
        double minDistance = BIGDISTANCE;
        double nextDistance = 0.0;
        LineSeg result = null;
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            nextDistance = aSegment.preciseDistanceToPoint(ptCoord.x, ptCoord.y);
            if (!(nextDistance < minDistance)) continue;
            minDistance = nextDistance;
            result = aSegment;
        }
        return result;
    }

    protected static final int doubleToInteger(double doubleValue) {
        return (int)Math.floor(doubleValue + 1.0E-9);
    }

    public static KVector toRelativeRound(KVector point, ElkNode parent) {
        ElkNode node = parent;
        while (node != null) {
            point.add((double)(-GmfLayoutEditPolicy.doubleToInteger(node.getX())), (double)(-GmfLayoutEditPolicy.doubleToInteger(node.getY())));
            node = node.getParent();
        }
        return point;
    }
}

