/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.model.planpro.Balisentechnik_ETCS.ETCS_Kante;
import org.eclipse.set.model.planpro.Balisentechnik_ETCS.ETCS_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.ETCSKnotenExtensions;

public class ETCSKanteExtensions
extends BasisObjektExtensions {
    public static ETCS_Knoten getETCSKnotenA(ETCS_Kante etcsEdge) {
        return EObjectExtensions.getNullableObject(etcsEdge, edge -> edge.getIDETCSKnotenA().getValue()).orElse(null);
    }

    public static ETCS_Knoten getETCSKnotenB(ETCS_Kante etcsEdge) {
        return EObjectExtensions.getNullableObject(etcsEdge, edge -> edge.getIDETCSKnotenB().getValue()).orElse(null);
    }

    public static List<TOP_Kante> getTopKante(ETCS_Kante etcsEdge) {
        return etcsEdge.getIDTOPKante().stream().map(ref -> EObjectExtensions.getNullableObject(ref, e -> e.getValue()).orElse(null)).filter(Objects::nonNull).toList();
    }

    public static TopPath getETCSKantePath(ETCS_Kante etcsEdge) {
        ETCS_Knoten etcsKnotenA = ETCSKanteExtensions.getETCSKnotenA(etcsEdge);
        ETCS_Knoten etcsKnotenB = ETCSKanteExtensions.getETCSKnotenB(etcsEdge);
        if (etcsKnotenA == null || etcsKnotenB == null) {
            throw new IllegalArgumentException(String.format("ETCS_Kante %s is missing ETCS_Knoten", etcsEdge.getIdentitaet().getWert()));
        }
        Map<TOP_Kante, BigDecimal> posA = ETCSKnotenExtensions.getKnotenPosition(etcsKnotenA);
        Map<TOP_Kante, BigDecimal> posB = ETCSKnotenExtensions.getKnotenPosition(etcsKnotenB);
        return posA.entrySet().stream().map(a -> new TopPoint((TOP_Kante)a.getKey(), (BigDecimal)a.getValue())).flatMap(pointA -> posB.entrySet().stream().map(b -> new TopPoint((TOP_Kante)b.getKey(), (BigDecimal)b.getValue())).map(pointB -> Services.getTopGraphService().findShortestPath(pointA, pointB))).filter(Optional::isPresent).map(Optional::get).min((p1, p2) -> p1.length().compareTo(p2.length())).orElse(null);
    }
}

