/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.nio.file.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.core.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ReportSavedSessionDialog
extends MessageDialog {
    private final Messages messages;
    final int kind;
    final IModelSession session;

    private static int getKind(IModelSession session) {
        ValidationResult.Outcome outcome = session.getValidationsOutcome(ValidationResult::getOutcome);
        switch (outcome) {
            case NOT_SUPPORTED: 
            case VALID: {
                return 2;
            }
            case INVALID: {
                return 4;
            }
        }
        throw new IllegalArgumentException(outcome.toString());
    }

    public ReportSavedSessionDialog(Shell parent, IModelSession session, Messages messages) {
        super(parent, messages.DialogService_ReportSavedSessionTitle, null, ReportSavedSessionDialog.getMessage(session, messages) + ReportSavedSessionDialog.getSaveFixMessage(session, messages), ReportSavedSessionDialog.getKind(session), new String[]{JFaceResources.getString((String)"ok")}, 0);
        this.session = session;
        this.messages = messages;
        this.kind = ReportSavedSessionDialog.getKind(session);
    }

    private static String getMessage(IModelSession session, Messages messages) {
        ValidationResult.Outcome outcome = session.getValidationsOutcome(ValidationResult::getOutcome);
        Path location = session.getToolboxFile().getPath();
        switch (outcome) {
            case NOT_SUPPORTED: 
            case VALID: {
                return String.format(messages.DialogService_ReportSavedSessionValidPattern, location.toString());
            }
            case INVALID: {
                return String.format(messages.DialogService_ReportSavedSessionInvalidPattern, location.toString());
            }
        }
        throw new IllegalArgumentException(outcome.toString());
    }

    private static String getSaveFixMessage(IModelSession session, Messages messages) {
        switch (session.getSaveFixResult()) {
            case GLOBAL: {
                return "\n\n" + messages.DialogService_DefaultsFilledGlobal;
            }
            case OBJEKTMANAGEMENT: {
                return "\n\n" + messages.DialogService_DefaultsFilledObjektmanagement;
            }
        }
        return "";
    }

    public int open() {
        if (!this.isSuppressed()) {
            return super.open();
        }
        return 0;
    }

    private boolean isSuppressed() {
        return this.session.isReportSavedDialogSuppressed(this.kind);
    }

    protected Control createCustomArea(Composite parent) {
        Composite customArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(customArea);
        final Button checkbox = new Button(customArea, 32);
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportSavedSessionDialog.this.session.setReportSavedDialogSuppressed(ReportSavedSessionDialog.this.kind, checkbox.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                ReportSavedSessionDialog.this.session.setReportSavedDialogSuppressed(ReportSavedSessionDialog.this.kind, checkbox.getSelection());
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)checkbox);
        Label label = new Label(customArea, 0);
        label.setText(this.messages.DialogService_ReportSavedSession_SuppressDialog);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        return customArea;
    }
}

