/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

public class Pattern
extends Resource {
    Image image;
    float x1;
    float y1;
    float x2;
    float y2;
    int alpha1;
    int alpha2;
    Color color1;
    Color color2;

    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error((int)4);
        }
        if (image.isDisposed()) {
            SWT.error((int)5);
        }
        this.image = image;
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        super(device);
        if (color1 == null) {
            SWT.error((int)4);
        }
        if (color1.isDisposed()) {
            SWT.error((int)5);
        }
        if (color2 == null) {
            SWT.error((int)4);
        }
        if (color2.isDisposed()) {
            SWT.error((int)5);
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.alpha1 = alpha1;
        this.color1 = color1;
        this.alpha2 = alpha2;
        this.color2 = color2;
    }

    void destroy() {
        this.image = null;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {}";
    }
}

