/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IContextDisposalListener;
import org.eclipse.e4.core.internal.di.Requestor;

public abstract class RAPAbstractObjectSupplierDispatcher<S extends ExtendedObjectSupplier>
extends ExtendedObjectSupplier {
    private Map<IEclipseContext, ExtendedObjectSupplier> supplierCache = Collections.synchronizedMap(new HashMap());
    private Map<IEclipseContext, IEclipseContext> rootContextMap = Collections.synchronizedMap(new HashMap());
    private IContextDisposalListener disposeListener = new IContextDisposalListener(){

        public void disposed(IEclipseContext context) {
            RAPAbstractObjectSupplierDispatcher.this.rootContextMap.remove(context);
        }
    };
    private final Class<S> supplierType;

    public RAPAbstractObjectSupplierDispatcher(Class<S> supplierType) {
        this.supplierType = supplierType;
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        ExtendedObjectSupplier supplier;
        IEclipseContext c = RAPAbstractObjectSupplierDispatcher.getContext(requestor);
        IEclipseContext appContext = this.rootContextMap.get(c);
        if (appContext == null) {
            IEclipseContext tmp = c;
            while (tmp != null && tmp.getLocal("E4Application.instanceId") == null) {
                tmp = tmp.getParent();
            }
            if (tmp == null) {
                System.err.println("FATAL: The injection is requested on a context which has no workbench context");
                return IInjector.NOT_A_VALUE;
            }
            ((EclipseContext)c).notifyOnDisposal(this.disposeListener);
            appContext = tmp;
            this.rootContextMap.put(c, appContext);
        }
        if ((supplier = this.supplierCache.get(appContext)) == null) {
            supplier = (ExtendedObjectSupplier)ContextInjectionFactory.make(this.supplierType, (IEclipseContext)appContext);
            this.supplierCache.put(appContext, supplier);
        }
        return supplier.get(descriptor, requestor, track, group);
    }

    private static IEclipseContext getContext(IRequestor requestor) {
        Requestor requestorImpl = (Requestor)requestor;
        return ((ContextObjectSupplier)requestorImpl.getPrimarySupplier()).getContext();
    }
}

