/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.jetty;

import java.security.Permission;
import java.util.Dictionary;
import org.eclipse.rap.http.jetty.internal.Activator;
import org.osgi.service.cm.ConfigurationPermission;

public class JettyConfigurator {
    private static final String PID_PREFIX = "org.eclipse.rap.http.jetty.JettyConfigurator.";
    private static Permission configurationPermission = new ConfigurationPermission("*", "configure");

    public static void startServer(String id, Dictionary<String, ? extends Object> settings) throws Exception {
        JettyConfigurator.checkConfigurationPermission();
        String pid = PID_PREFIX + id;
        Dictionary<String, ? extends Object> raw = settings;
        raw.put("service.pid", pid);
        Activator.startServer(pid, raw);
    }

    public static void stopServer(String id) throws Exception {
        JettyConfigurator.checkConfigurationPermission();
        Activator.stopServer(PID_PREFIX + id);
    }

    private static void checkConfigurationPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(configurationPermission);
        }
    }
}

