/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.set;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.set.SimpleSetProperty;

public class SimplePropertyObservableSet<S, E>
extends AbstractObservableSet<E>
implements IPropertyObservable<SimpleSetProperty<S, E>> {
    private S source;
    private SimpleSetProperty<S, E> property;
    private volatile boolean updating = false;
    private volatile int modCount = 0;
    private INativePropertyListener<S> listener;
    private Set<E> cachedSet;
    private boolean stale;

    public SimplePropertyObservableSet(Realm realm, S source, SimpleSetProperty<S, E> property) {
        super(realm);
        this.source = source;
        this.property = property;
    }

    protected void firstListenerAdded() {
        if (!this.isDisposed() && this.listener == null) {
            this.listener = this.property.adaptListener(event -> {
                if (!this.isDisposed() && !this.updating) {
                    this.getRealm().exec(() -> {
                        if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                            ++this.modCount;
                            this.notifyIfChanged((SetDiff)simplePropertyEvent.diff);
                        } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE && !this.stale) {
                            this.stale = true;
                            this.fireStale();
                        }
                    });
                }
            });
        }
        this.getRealm().exec(() -> {
            this.cachedSet = new HashSet<E>(this.getSet());
            this.stale = false;
            if (this.listener != null) {
                this.listener.addTo(this.source);
            }
        });
    }

    protected void lastListenerRemoved() {
        if (this.listener != null) {
            this.listener.removeFrom(this.source);
        }
        this.cachedSet.clear();
        this.cachedSet = null;
        this.stale = false;
    }

    protected Set<E> getWrappedSet() {
        return this.getSet();
    }

    public Object getElementType() {
        return this.property.getElementType();
    }

    private Set<E> getSet() {
        return this.property.getSet(this.source);
    }

    public boolean contains(Object o) {
        this.getterCalled();
        return this.getSet().contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.getSet().containsAll(c);
    }

    public boolean isEmpty() {
        this.getterCalled();
        return this.getSet().isEmpty();
    }

    public Object[] toArray() {
        this.getterCalled();
        return this.getSet().toArray();
    }

    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.getSet().toArray(a);
    }

    private void updateSet(Set<E> set, SetDiff<E> diff) {
        if (!diff.isEmpty()) {
            boolean wasUpdating = this.updating;
            this.updating = true;
            try {
                this.property.updateSet(this.source, diff);
                ++this.modCount;
            }
            finally {
                this.updating = wasUpdating;
            }
            this.notifyIfChanged(null);
        }
    }

    public boolean add(E o) {
        this.checkRealm();
        Set<E> set = this.getSet();
        if (set.contains(o)) {
            return false;
        }
        SetDiff diff = Diffs.createSetDiff(Collections.singleton(o), Collections.emptySet());
        this.updateSet(set, diff);
        return true;
    }

    public Iterator<E> iterator() {
        this.getterCalled();
        return new Iterator<E>(){
            int expectedModCount;
            Set<E> set;
            Iterator<E> iterator;
            E last;
            {
                this.expectedModCount = SimplePropertyObservableSet.this.modCount;
                this.set = new HashSet(SimplePropertyObservableSet.this.getSet());
                this.iterator = this.set.iterator();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                SimplePropertyObservableSet.this.getterCalled();
                this.checkForComodification();
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                SimplePropertyObservableSet.this.getterCalled();
                this.checkForComodification();
                this.last = this.iterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                SimplePropertyObservableSet.this.checkRealm();
                this.checkForComodification();
                SetDiff diff = Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(this.last));
                SimplePropertyObservableSet.this.updateSet(this.set, diff);
                this.iterator.remove();
                this.last = null;
                this.expectedModCount = SimplePropertyObservableSet.this.modCount;
            }

            private void checkForComodification() {
                if (this.expectedModCount != SimplePropertyObservableSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public boolean remove(Object o) {
        this.getterCalled();
        Set<E> set = this.getSet();
        if (!set.contains(o)) {
            return false;
        }
        SetDiff diff = Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(o));
        this.updateSet(set, diff);
        return true;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.getterCalled();
        if (c.isEmpty()) {
            return false;
        }
        Set<E> set = this.getSet();
        if (set.containsAll(c)) {
            return false;
        }
        HashSet<E> additions = new HashSet<E>(c);
        additions.removeAll(set);
        if (additions.isEmpty()) {
            return false;
        }
        SetDiff diff = Diffs.createSetDiff(additions, Collections.emptySet());
        this.updateSet(set, diff);
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        this.getterCalled();
        if (c.isEmpty()) {
            return false;
        }
        Set<E> set = this.getSet();
        if (set.isEmpty()) {
            return false;
        }
        HashSet<E> removals = new HashSet<E>(c);
        removals.retainAll(set);
        HashSet<E> typedRemovals = removals;
        if (removals.isEmpty()) {
            return false;
        }
        SetDiff diff = Diffs.createSetDiff(Collections.emptySet(), typedRemovals);
        this.updateSet(set, diff);
        return true;
    }

    public boolean retainAll(Collection<?> c) {
        this.getterCalled();
        Set<E> set = this.getSet();
        if (set.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        HashSet<E> removals = new HashSet<E>(set);
        removals.removeAll(c);
        if (removals.isEmpty()) {
            return false;
        }
        SetDiff diff = Diffs.createSetDiff(Collections.emptySet(), removals);
        this.updateSet(set, diff);
        return true;
    }

    public void clear() {
        this.getterCalled();
        Set<E> set = this.getSet();
        if (set.isEmpty()) {
            return;
        }
        SetDiff diff = Diffs.createSetDiff(Collections.emptySet(), set);
        this.updateSet(set, diff);
    }

    private void notifyIfChanged(SetDiff<E> diff) {
        if (this.hasListeners()) {
            Set<E> oldSet = this.cachedSet;
            this.cachedSet = new HashSet<E>(this.getSet());
            HashSet<E> newSet = this.cachedSet;
            if (diff == null) {
                diff = Diffs.computeSetDiff(oldSet, newSet);
            }
            if (!diff.isEmpty() || this.stale) {
                this.stale = false;
                this.fireSetChange(diff);
            }
        }
    }

    public boolean isStale() {
        this.getterCalled();
        return this.stale;
    }

    public boolean equals(Object o) {
        this.getterCalled();
        return this.getSet().equals(o);
    }

    public int hashCode() {
        this.getterCalled();
        return this.getSet().hashCode();
    }

    public Object getObserved() {
        return this.source;
    }

    @Override
    public SimpleSetProperty<S, E> getProperty() {
        return this.property;
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            if (this.listener != null) {
                this.listener.removeFrom(this.source);
            }
            this.property = null;
            this.source = null;
            this.listener = null;
            this.stale = false;
        }
        super.dispose();
    }
}

