/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

class ExpandBarTab
extends ExampleTab {
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String PROP_EXPAND_LISTENER = "expandListener";
    private ExpandBar expandBar;
    private Spinner spinner;
    private boolean markupEnabled;

    ExpandBarTab() {
        super("ExpandBar");
        this.setDefaultStyle(2560);
        this.markupEnabled = true;
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("V_SCROLL", 512, true);
        this.createStyleButton("BORDER", 2048, true);
        this.createOrientationButton();
        this.createMarkupButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.spinner = this.createSpacingControl(parent);
        this.createFontChooser();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createInsertItemButton(parent);
        this.createRemoveItemButton(parent);
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        this.createPropertyCheckbox("Add Expand Listener", PROP_EXPAND_LISTENER);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        this.expandBar = new ExpandBar(parent, this.getStyle());
        this.expandBar.setData("org.eclipse.rap.rwt.markupEnabled", (Object)(this.markupEnabled ? Boolean.TRUE : null));
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu expandBarMenu = new Menu((Control)this.expandBar);
            MenuItem expandBarMenuItem = new MenuItem(expandBarMenu, 8);
            expandBarMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the expand bar";
                    MessageDialog.openInformation((Shell)ExpandBarTab.this.expandBar.getShell(), (String)"Information", (String)message);
                }
            });
            expandBarMenuItem.setText("Expand Bar context menu item");
            this.expandBar.setMenu(expandBarMenu);
        }
        if (this.hasCreateProperty(PROP_EXPAND_LISTENER)) {
            this.expandBar.addExpandListener(new ExpandListener(){

                public void itemCollapsed(ExpandEvent event) {
                    int index = 0;
                    int itemCount = ExpandBarTab.this.expandBar.getItemCount();
                    int i = 0;
                    while (i < itemCount) {
                        if (ExpandBarTab.this.expandBar.getItem(i) == event.item) {
                            index = i;
                        }
                        ++i;
                    }
                    String message = "Expand item " + index + " collapsed!";
                    MessageDialog.openInformation((Shell)ExpandBarTab.this.expandBar.getShell(), (String)"Information", (String)message);
                }

                public void itemExpanded(ExpandEvent event) {
                    int index = 0;
                    int itemCount = ExpandBarTab.this.expandBar.getItemCount();
                    int i = 0;
                    while (i < itemCount) {
                        if (ExpandBarTab.this.expandBar.getItem(i) == event.item) {
                            index = i;
                        }
                        ++i;
                    }
                    String message = "Expand item " + index + " expanded!";
                    MessageDialog.openInformation((Shell)ExpandBarTab.this.expandBar.getShell(), (String)"Information", (String)message);
                }
            });
        }
        Display display = this.expandBar.getDisplay();
        Composite composite = new Composite((Composite)this.expandBar, 0);
        composite.setLayout((Layout)new GridLayout());
        new Button(composite, 8).setText("SWT.PUSH");
        new Button(composite, 16).setText("SWT.RADIO");
        new Button(composite, 32).setText("SWT.CHECK");
        new Button(composite, 2).setText("SWT.TOGGLE");
        ExpandItem item = new ExpandItem(this.expandBar, 0, 0);
        item.setText("What is your <br/><b>favorite</b> button?");
        item.setHeight(composite.computeSize((int)-1, (int)-1).y);
        item.setControl((Control)composite);
        item.setImage(Util.loadImage(display, "resources/newfolder_wiz.gif"));
        composite = new Composite((Composite)this.expandBar, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Image image = display.getSystemImage(1);
        new Label(composite, 0).setImage(image);
        new Label(composite, 0).setText("SWT.ICON_ERROR");
        image = display.getSystemImage(2);
        new Label(composite, 0).setImage(image);
        new Label(composite, 0).setText("SWT.ICON_INFORMATION");
        image = display.getSystemImage(8);
        new Label(composite, 0).setImage(image);
        new Label(composite, 0).setText("SWT.ICON_WARNING");
        image = display.getSystemImage(4);
        new Label(composite, 0).setImage(image);
        new Label(composite, 0).setText("SWT.ICON_QUESTION");
        item = new ExpandItem(this.expandBar, 0, 1);
        item.setText("What is your favorite icon?");
        item.setHeight(composite.computeSize((int)-1, (int)-1).y);
        item.setControl((Control)composite);
        item.setImage(Util.loadImage(display, "resources/newprj_wiz.gif"));
        item.setExpanded(true);
        this.expandBar.computeSize(-1, -1);
        this.registerControl((Control)this.expandBar);
        if (this.checkControl((Control)this.spinner)) {
            this.expandBar.setSpacing(this.spinner.getSelection());
        }
    }

    private Spinner createSpacingControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Spacing");
        final Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(4);
        spinner.setMinimum(0);
        spinner.setMaximum(20);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int spacing = spinner.getSelection();
                ExpandBarTab.this.expandBar.setSpacing(spacing);
            }
        });
        return spinner;
    }

    private void createInsertItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Insert ExpandItem before first item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpandItem item = new ExpandItem(ExpandBarTab.this.expandBar, 0, 0);
                item.setText("ExpandItem text");
                item.setImage(Util.loadImage(item.getDisplay(), "resources/newfile_wiz.gif"));
                item.setExpanded(false);
                ExpandBarTab.this.createItemContent(item);
            }
        });
    }

    private void createRemoveItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove first ExpandItem");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpandItem item = ExpandBarTab.this.expandBar.getItem(0);
                item.dispose();
            }
        });
    }

    private void createItemContent(ExpandItem item) {
        if (item.getControl() == null) {
            ExpandBar bar = item.getParent();
            Text content = new Text((Composite)bar, 74);
            String text = "This is the item's content";
            content.setText(text);
            item.setHeight(content.computeSize((int)-1, (int)-1).y);
            item.setControl((Control)content);
        }
    }

    private Button createMarkupButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Enable Markup");
        button.setSelection(this.markupEnabled);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpandBarTab.this.markupEnabled = button.getSelection();
                ExpandBarTab.this.createNew();
            }
        });
        return button;
    }
}

