/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rap.e4.apache.jxpath.NodeSet;
import org.eclipse.rap.e4.apache.jxpath.Pointer;

public class BasicNodeSet
implements NodeSet {
    private List pointers = new ArrayList();
    private List readOnlyPointers;
    private List nodes;
    private List values;

    public void add(Pointer pointer) {
        if (this.pointers.add(pointer)) {
            this.clearCacheLists();
        }
    }

    public void add(NodeSet nodeSet) {
        if (this.pointers.addAll(nodeSet.getPointers())) {
            this.clearCacheLists();
        }
    }

    public void remove(Pointer pointer) {
        if (this.pointers.remove(pointer)) {
            this.clearCacheLists();
        }
    }

    @Override
    public synchronized List getPointers() {
        if (this.readOnlyPointers == null) {
            this.readOnlyPointers = Collections.unmodifiableList(this.pointers);
        }
        return this.readOnlyPointers;
    }

    @Override
    public synchronized List getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
            int i = 0;
            while (i < this.pointers.size()) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.nodes.add(pointer.getNode());
                ++i;
            }
            this.nodes = Collections.unmodifiableList(this.nodes);
        }
        return this.nodes;
    }

    @Override
    public synchronized List getValues() {
        if (this.values == null) {
            this.values = new ArrayList();
            int i = 0;
            while (i < this.pointers.size()) {
                Pointer pointer = (Pointer)this.pointers.get(i);
                this.values.add(pointer.getValue());
                ++i;
            }
            this.values = Collections.unmodifiableList(this.values);
        }
        return this.values;
    }

    public String toString() {
        return this.pointers.toString();
    }

    private synchronized void clearCacheLists() {
        this.readOnlyPointers = null;
        this.nodes = null;
        this.values = null;
    }
}

