/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.InternalImage;

public class InternalImageFactory {
    private final SharedInstanceBuffer<String, InternalImage> cache = new SharedInstanceBuffer();

    public InternalImage findInternalImage(String fileName) {
        return this.cache.get(fileName, new SharedInstanceBuffer.InstanceCreator<String, InternalImage>(){

            @Override
            public InternalImage createInstance(String fileName) {
                return InternalImageFactory.createInternalImage(fileName);
            }
        });
    }

    public InternalImage findInternalImage(InputStream stream) {
        final BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        final ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        return this.cache.get(path, new SharedInstanceBuffer.InstanceCreator<String, InternalImage>(){

            @Override
            public InternalImage createInstance(String path) {
                return InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
            }
        });
    }

    public InternalImage findInternalImage(final ImageData imageData) {
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        return this.cache.get(path, new SharedInstanceBuffer.InstanceCreator<String, InternalImage>(){

            @Override
            public InternalImage createInstance(String path) {
                InputStream stream = InternalImageFactory.createInputStream(imageData);
                return InternalImageFactory.createInternalImage(path, stream, imageData);
            }
        });
    }

    InternalImage findInternalImage(String key, final InputStream inputStream) {
        return this.cache.get(key, new SharedInstanceBuffer.InstanceCreator<String, InternalImage>(){

            @Override
            public InternalImage createInstance(String key) {
                BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
                ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
                String path = InternalImageFactory.createGeneratedImagePath(imageData);
                return InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
            }
        });
    }

    public void destroyInternalImage(String key) {
        InternalImage internalImage = this.cache.remove(key);
        RWT.getResourceManager().unregister(internalImage.getResourceName());
    }

    static ImageData readImageData(InputStream stream) throws SWTException {
        stream.mark(Integer.MAX_VALUE);
        ImageData result = new ImageData(stream);
        try {
            stream.reset();
        }
        catch (IOException shouldNotHappen) {
            String msg = "Could not reset input stream after reading image";
            throw new RuntimeException(msg, shouldNotHappen);
        }
        return result;
    }

    static InputStream createInputStream(ImageData imageData) {
        ImageLoader imageLoader = new ImageLoader();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(outputStream, InternalImageFactory.getOutputFormat(imageData));
        byte[] bytes = outputStream.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private static InternalImage createInternalImage(String fileName) {
        InternalImage result;
        try (FileInputStream stream = new FileInputStream(fileName);){
            result = InternalImageFactory.createInternalImage(stream);
        }
        catch (IOException ioe) {
            throw new SWTException(39, ioe.getMessage());
        }
        return result;
    }

    private static InternalImage createInternalImage(InputStream stream) {
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        ImageData imageData = InternalImageFactory.readImageData(bufferedStream);
        String path = InternalImageFactory.createGeneratedImagePath(imageData);
        return InternalImageFactory.createInternalImage(path, bufferedStream, imageData);
    }

    private static InternalImage createInternalImage(String path, InputStream stream, ImageData imageData) {
        RWT.getResourceManager().register(path, stream);
        return new InternalImage(path, imageData.width, imageData.height, false);
    }

    private static int getOutputFormat(ImageData imageData) {
        int result = imageData.type;
        if (imageData.type == -1) {
            result = 5;
        }
        return result;
    }

    private static String createGeneratedImagePath(ImageData data) {
        String extension;
        int outputFormat = InternalImageFactory.getOutputFormat(data);
        switch (outputFormat) {
            case 0: 
            case 1: {
                extension = ".bmp";
                break;
            }
            case 2: {
                extension = ".gif";
                break;
            }
            case 4: {
                extension = ".jpg";
                break;
            }
            case 6: {
                extension = ".tif";
                break;
            }
            case 3: {
                extension = ".ico";
                break;
            }
            default: {
                extension = ".png";
            }
        }
        String hash = String.valueOf(InternalImageFactory.getHash(data)) + extension;
        return "generated/" + hash;
    }

    private static String getHash(ImageData imageData) {
        CRC32 crc32 = new CRC32();
        if (imageData.data != null) {
            crc32.update(1);
            crc32.update(imageData.data);
        }
        if (imageData.alphaData != null) {
            crc32.update(2);
            crc32.update(imageData.alphaData);
        }
        if (imageData.maskData != null) {
            crc32.update(3);
            crc32.update(imageData.maskData);
        }
        if (imageData.palette != null) {
            crc32.update(4);
            if (imageData.palette.isDirect) {
                crc32.update(5);
                crc32.update(imageData.palette.redMask);
                crc32.update(imageData.palette.greenMask);
                crc32.update(imageData.palette.blueMask);
            } else {
                crc32.update(6);
                RGB[] rgb = imageData.palette.getRGBs();
                int i = 0;
                while (i < rgb.length) {
                    crc32.update(rgb[i].red);
                    crc32.update(rgb[i].green);
                    crc32.update(rgb[i].blue);
                    ++i;
                }
            }
        }
        crc32.update(imageData.alpha);
        crc32.update(imageData.transparentPixel);
        crc32.update(imageData.type);
        crc32.update(imageData.bytesPerLine);
        crc32.update(imageData.scanlinePad);
        crc32.update(imageData.maskPad);
        crc32.update(imageData.x);
        crc32.update(imageData.y);
        crc32.update(imageData.width);
        crc32.update(imageData.height);
        crc32.update(imageData.depth);
        crc32.update(imageData.delayTime);
        crc32.update(imageData.disposalMethod);
        return Long.toHexString(crc32.getValue());
    }
}

