/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.coolitemkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ICoolBarAdapter;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;

public class CoolItemOperationHandler
extends WidgetOperationHandler<CoolItem> {
    private static final String METHOD_MOVE = "move";
    private static final String PROP_LEFT = "left";

    public CoolItemOperationHandler(CoolItem item) {
        super(item);
    }

    @Override
    public void handleCall(CoolItem item, String method, JsonObject properties) {
        if (METHOD_MOVE.equals(method)) {
            this.handleCallMove(item, properties);
        }
    }

    public void handleCallMove(final CoolItem item, JsonObject properties) {
        final int newLeft = properties.get(PROP_LEFT).asInt();
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                CoolItemOperationHandler.moveItem(item, newLeft);
            }
        });
    }

    static void moveItem(CoolItem coolItem, int newX) {
        CoolItem[] items = coolItem.getParent().getItems();
        boolean changed = false;
        int newOrder = -1;
        int maxX = 0;
        int minX = 0;
        int i = 0;
        while (newOrder == -1 && i < items.length) {
            CoolItem item = items[i];
            Rectangle itemBounds = item.getBounds();
            if (item != coolItem && itemBounds.contains(newX, itemBounds.y)) {
                newOrder = coolItem.getBounds().x > newX ? i + 1 : i;
                changed = CoolItemOperationHandler.changeOrder(coolItem, newOrder);
            }
            maxX = Math.max(maxX, itemBounds.x + itemBounds.width);
            minX = Math.min(minX, itemBounds.x);
            ++i;
        }
        if (newOrder == -1 && newX > maxX) {
            int last = coolItem.getParent().getItemCount() - 1;
            changed = CoolItemOperationHandler.changeOrder(coolItem, last);
        } else if (newOrder == -1 && newX < minX) {
            changed = CoolItemOperationHandler.changeOrder(coolItem, 0);
        }
        if (!changed) {
            WidgetUtil.getAdapter(coolItem).preserve("bounds", null);
        }
    }

    private static boolean changeOrder(CoolItem coolItem, int newOrder) {
        boolean result;
        CoolBar coolBar = coolItem.getParent();
        int itemIndex = coolBar.indexOf(coolItem);
        int[] itemOrder = coolBar.getItemOrder();
        int length = itemOrder.length;
        int[] targetOrder = new int[length];
        int index = 0;
        if (itemIndex != newOrder) {
            int i = 0;
            while (i < length) {
                if (i == newOrder) {
                    targetOrder[i] = itemOrder[itemIndex];
                } else {
                    if (index == itemIndex) {
                        ++index;
                    }
                    targetOrder[i] = itemOrder[index];
                    ++index;
                }
                ++i;
            }
            coolBar.getAdapter(ICoolBarAdapter.class).setItemOrder(targetOrder);
            result = true;
        } else {
            result = false;
        }
        return result;
    }
}

