/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeBase;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class TableType
extends CompositeDatabaseTypeBase
implements CompositeDatabaseType,
DatabaseTypeVisitable {
    public static final String TYPENAME = "TABLE";
    protected String tableName;
    protected String schema;
    protected List<FieldType> columns = new ArrayList<FieldType>();
    protected boolean iot = false;

    public TableType() {
        super(null);
    }

    public TableType(String tableName) {
        super(null);
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.typeName = "TABLE " + tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public DatabaseType getEnclosedType() {
        return null;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
    }

    public List<FieldType> getColumns() {
        return this.columns;
    }

    public void addColumn(DatabaseType databaseType) {
        if (databaseType.isFieldType()) {
            this.columns.add((FieldType)databaseType);
        } else {
            for (FieldType col : this.columns) {
                if (!col.getEnclosedType().getTypeName().equals(databaseType.getTypeName())) continue;
                col.setEnclosedType(databaseType);
            }
        }
    }

    public void setIOT(boolean iot) {
        this.iot = iot;
    }

    public boolean iot() {
        return this.iot;
    }

    public int numberOfPKColumns() {
        int pkColumns = 0;
        for (FieldType col : this.columns) {
            if (!col.pk()) continue;
            ++pkColumns;
        }
        return pkColumns;
    }

    @Override
    public boolean isResolved() {
        for (FieldType fType : this.columns) {
            if (fType.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTableType() {
        return true;
    }

    @Override
    public String shortName() {
        return this.typeName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(TYPENAME);
        sb.append(" ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.tableName);
        sb.append(" (\n");
        for (FieldType col : this.columns) {
            sb.append("\t");
            sb.append(col.toString());
            sb.append("\n");
        }
        int numPkCols = this.numberOfPKColumns();
        if (numPkCols > 0) {
            sb.append("\t");
            sb.append("PRIMARY KEY (");
            int pkColCount = 0;
            int len = this.columns.size();
            for (int i = 0; i < len; ++i) {
                FieldType col = this.columns.get(i);
                if (!col.pk) continue;
                sb.append(col.fieldName);
                if (++pkColCount >= numPkCols) continue;
                sb.append(',');
            }
            sb.append(")\n");
        }
        sb.append(")");
        if (this.iot) {
            sb.append(" ORGANIZATION INDEX");
        }
        return sb.toString();
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }
}

