/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.MaxDBPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.platform.database.SQLAnywherePlatform;
import org.eclipse.persistence.platform.database.SQLServerPlatform;
import org.eclipse.persistence.platform.database.SybasePlatform;
import org.eclipse.persistence.platform.database.SymfowarePlatform;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.collections.Restaurant;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.inheritance.Engineer;
import org.eclipse.persistence.testing.models.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.inheritance.SalesRep;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;
import org.eclipse.persistence.testing.models.legacy.Computer;
import org.eclipse.persistence.testing.models.mapping.Shipment;
import org.eclipse.persistence.testing.models.multipletable.LargeBusinessProject;
import org.eclipse.persistence.testing.models.ownership.ObjectB;
import org.eclipse.persistence.testing.models.ownership.ObjectC;
import org.eclipse.persistence.testing.tests.expressions.BadExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.DefaultingFunctionsExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.GetFunctionWithTwoArgumentsTest;
import org.eclipse.persistence.testing.tests.expressions.InvalidQueryKeyFunctionExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.LiteralExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.LiteralSQLExpressionWithQuestionMarkTest;
import org.eclipse.persistence.testing.tests.expressions.LowerCaseForCaseInsensitiveTest;
import org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.ReadObjectExpressionTest;
import org.eclipse.persistence.testing.tests.expressions.SearchTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ExpressionTestSuite
extends TestSuite {
    protected PopulationManager manager;

    public ExpressionTestSuite() {
        this.setDescription("This suite tests expressions.");
    }

    public ExpressionTestSuite(boolean isSRG) {
        super(isSRG);
        this.setDescription("This suite tests expressions.");
    }

    private void addAdvancedExpressionFunctionTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("salary").lessThan(100000);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(1993, 5, 1, 0, 0, 0);
        exp = exp.and(builder.get("period").get("startDate").dateName("year").equal((Object)"1993"));
        exp = exp.and(builder.get("period").get("startDate").addMonths(1).equal((Object)new Date(calendar.getTime().getTime())));
        exp = exp.and(builder.get("lastName").asciiValue().equal((Object)"84"));
        exp = exp.and(builder.get("period").get("endDate").dateToString().equal((Object)"1999-6-12 10:10:10.0"));
        exp = exp.and(builder.get("period").get("endDate").toChar().equal((Object)"1999-6-12 10:10:10.0"));
        exp = exp.and(builder.get("period").get("endDate").toChar("day").equal((Object)"monday"));
        calendar.set(1999, 1, 1, 0, 0, 0);
        exp = exp.and(builder.get("period").get("startDate").toDate().equal((Object)new Date(calendar.getTime().getTime())));
        exp = exp.and(builder.get("period").get("startDate").lastDay().equal((Object)new Date(calendar.getTime().getTime())));
        calendar.set(1993, 1, 1, 0, 0, 0);
        exp = exp.and(builder.get("period").get("startDate").truncateDate("year").equal((Object)new Date(calendar.getTime().getTime())));
        exp = exp.and(builder.get("period").get("endDate").newTime("EST", "CST").dateToString().equal((Object)"1999-6-12 9:10:10.0"));
        exp = exp.and(builder.get("firstName").leftPad(1, (Object)" ").equal((Object)" Bob"));
        exp = exp.and(builder.get("firstName").replace((Object)"B", (Object)"C").equal((Object)"Cob"));
        exp = exp.and(builder.get("firstName").rightPad(1, (Object)" ").equal((Object)"Bob "));
        exp = exp.and(builder.get("salary").toNumber().lessThan(100000));
        exp = exp.and(builder.get("firstName").substring(1, 1).equal((Object)"B"));
        exp = exp.and(builder.get("firstName").translate((Object)"Bo", (Object)"bo").equal((Object)"bob"));
        exp = exp.and(builder.get("firstName").trim().equal((Object)"b"));
        Hashtable<String, String> decodeTable = new Hashtable<String, String>(3);
        decodeTable.put("Bob", "Bobby");
        decodeTable.put("Susan", "Susie");
        decodeTable.put("Eldrick", "Tiger");
        exp = exp.and(builder.get("firstName").ifNull((Object)"Bob").decode(decodeTable, "No-Nickname").equal((Object)"Bobby"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(exp);
        test.setName("AdvancedExpressionFunctionTest");
        test.setDescription("advanced expression function test");
        test.addSupportedPlatform(OraclePlatform.class);
        this.addTest((Test)test);
    }

    private void addRegexpTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").regexp("^B.*");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(exp);
        test.setName("RegexpTest");
        test.setDescription("Regexp test");
        test.addSupportedPlatform(OraclePlatform.class);
        test.addSupportedPlatform(MySQLPlatform.class);
        test.addSupportedPlatform(PostgreSQLPlatform.class);
        this.addTest((Test)test);
    }

    private void addAdvancedDB2ExpressionFunctionTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("salary").lessThan(100000);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(1993, 5, 1, 0, 0, 0);
        exp = exp.and(builder.get("lastName").asciiValue().equal(84));
        exp = exp.and(builder.get("period").get("endDate").dateToString().equal((Object)"1999-6-12 10:10:10.0"));
        calendar.set(1999, 1, 1, 0, 0, 0);
        exp = exp.and(builder.get("period").get("startDate").toDate().equal((Object)new Date(calendar.getTime().getTime())));
        calendar.set(1993, 1, 1, 0, 0, 0);
        exp = exp.and(builder.get("firstName").replace((Object)"B", (Object)"C").equal((Object)"Cob"));
        exp = exp.and(builder.get("salary").toNumber().lessThan(100000));
        exp = exp.and(builder.get("firstName").substring(1, 1).equal((Object)"B"));
        exp = exp.and(builder.get("firstName").translate((Object)new String("Bo"), (Object)new String("bo")).equal((Object)"bob"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(exp);
        test.setName("AdvancedDB2ExpressionFunctionTest");
        test.setDescription("advanced expression function test");
        test.addSupportedPlatform(DB2Platform.class);
        test.addUnsupportedPlatform(DerbyPlatform.class);
        this.addTest((Test)test);
    }

    private void addAdvancedExpressionMathTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(1000);
        expression = expression.and(ExpressionMath.ln((Expression)builder.get("salary")).lessThan(10));
        expression = expression.and(ExpressionMath.mod((Expression)builder.get("salary"), (Object)new Integer(107)).lessThan(10));
        expression = expression.and(ExpressionMath.floor((Expression)builder.get("salary")).lessThan(45000));
        expression = expression.and(ExpressionMath.ceil((Expression)builder.get("salary")).lessThan(10000));
        expression = expression.and(ExpressionMath.round((Expression)builder.get("salary"), (int)2).equal(40000));
        expression = expression.and(ExpressionMath.min((Expression)builder.get("salary"), (Object)new Integer(30000)).greaterThan(30000));
        expression = expression.and(ExpressionMath.max((Expression)builder.get("salary"), (Object)new Integer(30000)).lessThan(50000));
        expression = expression.and(ExpressionMath.sinh((Expression)ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(10000000))).lessThanEqual(100));
        expression = expression.and(ExpressionMath.cosh((Expression)ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(10000000))).lessThanEqual(100));
        expression = expression.and(ExpressionMath.tanh((Expression)ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(10000000))).lessThanEqual(1));
        expression = expression.and(ExpressionMath.acos((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.asin((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.atan((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.atan2((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0), (int)2).lessThanEqual(100));
        expression = expression.and(ExpressionMath.power((Expression)builder.get("salary"), (int)1).equal(40000));
        expression = expression.and(ExpressionMath.trunc((Expression)builder.get("salary"), (int)2).equal(50000));
        expression = expression.and(ExpressionMath.chr((Expression)builder.get("salary")).equal('b'));
        expression = expression.and(ExpressionMath.round((Expression)builder.get("salary"), (int)2).equal(40000));
        expression = expression.and(ExpressionMath.sign((Expression)builder.get("salary")).greaterThan(0));
        expression = expression.and(ExpressionMath.exp((Expression)ExpressionMath.min((Expression)builder.get("salary"), (int)5)).lessThan(1000000));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("AdvancedExpressionMathTest");
        test.setDescription("Test advanced expression math package");
        test.addSupportedPlatform(OraclePlatform.class);
        this.addTest((Test)test);
    }

    private void addAdvancedSybaseExpressionFunctionTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("period").get("startDate").datePart("year").equal(1993);
        exp = exp.and(builder.get("period").get("startDate").dateName("year").equal((Object)"1993"));
        exp = exp.and(builder.get("period").get("startDate").equal(builder.currentDate()));
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(1994, 1, 1, 0, 0, 0);
        exp = exp.and(builder.get("period").get("startDate").dateDifference("year", (java.util.Date)new Date(calendar.getTime().getTime())).equal(1));
        exp = exp.and(builder.get("period").get("startDate").addDate("year", 1).dateDifference("year", builder.value((Object)new Date(calendar.getTime().getTime()))).equal(2));
        exp = exp.and(builder.get("firstName").difference("Bob").greaterThan(1));
        exp = exp.and(builder.get("firstName").indexOf((Object)"o").greaterThan(0));
        exp = exp.and(builder.get("firstName").length().lessThan(6));
        exp = exp.and(builder.get("firstName").reverse().equal((Object)"boB"));
        exp = exp.and(builder.get("firstName").replicate(2).equal((Object)"BobBob"));
        exp = exp.and(builder.get("firstName").right(2).equal((Object)"ob"));
        exp = exp.and(builder.get("salary").toNumber().lessThan(100000));
        exp = exp.and(builder.get("firstName").ifNull((Object)"Frank").equal((Object)"Bob"));
        exp = exp.and(builder.get("period").get("endDate").dateToString().equal((Object)"1999-6-12 10:10:10.0"));
        exp = exp.and(builder.get("period").get("startDate").toDate().equal((Object)new Date(calendar.getTime().getTime())));
        exp = exp.and(builder.get("period").get("endDate").toChar().equal((Object)"1999-6-12 10:10:10.0"));
        exp = exp.and(ExpressionMath.cot((Expression)builder.get("salary")).greaterThan(0));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(exp);
        test.setName("AdvancedSybaseExpressionFunctionTest");
        test.setDescription("advanced sybase expression function test");
        test.addSupportedPlatform(SybasePlatform.class);
        test.addSupportedPlatform(SQLAnywherePlatform.class);
        test.addSupportedPlatform(SQLServerPlatform.class);
        this.addTest((Test)test);
    }

    private void addAggregateQueryTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").equal((Object)employee.getPeriod().getStartDate());
        SearchTest test = new SearchTest();
        test.setExpression(expression);
        test.setErrorMessage("Failed to match an aggregate attribute (get('period').get('startDate').equals(dateObject)");
        test.setName("AggregateQueryTest");
        test.setDescription("Test for mateching of aggregate properties");
        this.addTest((Test)test);
    }

    private void addAggregeateCollectionJoinTest(Class cls) {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("customers").anyOf("dependants").get("firstName").equal((Object)"Kyle");
        ReadAllExpressionTest test = new ReadAllExpressionTest(cls, 1);
        test.setExpression(expression);
        test.setName("Aggregate Colection Join Test " + Helper.getShortClassName((Class)cls));
        test.setDescription("Test aggregate collection join with 2 anyOf clauses");
        this.addTest((Test)test);
    }

    private void addAndNullTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").equal((Object)"Chanley");
        Expression exp2 = builder.get("firstName").equal((Object)"Charles");
        Expression expression = exp1.and(exp2).and(null);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("AndNullExpressionTest");
        test.setDescription("Test AND expression with NULL");
        this.addTest((Test)test);
    }

    private void addAndTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").equal((Object)"Chanley");
        Expression exp2 = builder.get("firstName").equal((Object)"Charles");
        Expression expression = exp1.and(exp2);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("AndExpressionTest");
        test.setDescription("Test AND expression");
        this.addTest((Test)test);
    }

    private void addBadFieldWithTableTest() {
        Expression expression = new ExpressionBuilder().getField("ADDRESS.STREET").equal((Object)"blee");
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test that fields with an invalid table are error handled correctly");
        test.setExceptionCode(6069);
        test.setExpression(expression);
        test.setName("BadFieldTableTest");
        this.addTest((Test)test);
    }

    private void addBadQueryKeyTest() {
        Expression expression = new ExpressionBuilder().get("foofoo").equal((Object)"blee");
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test that wrong query keys are error handled correctly");
        test.setExceptionCode(6015);
        test.setExpression(expression);
        test.setName("BadQueryKeyTest");
        this.addTest((Test)test);
    }

    private void addBadQueryTableTest() {
        Expression expression = new ExpressionBuilder().getTable("foofoo").equal((Object)"blee");
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test that the comparison of tables is error handled correctly");
        test.setExceptionCode(6068);
        test.setExpression(expression);
        test.setName("BadQueryTableTest");
        this.addTest((Test)test);
    }

    private void addBadToManyQueryKeyTest() {
        Expression expression = new ExpressionBuilder().get("managedEmployees").get("firstName").equal((Object)"blee");
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test that to-many query keys cannot be gotten with 'get', must use 'anyOf'");
        test.setExceptionCode(6070);
        test.setExpression(expression);
        test.setName("BadToManyQueryKeyTest");
        this.addTest((Test)test);
    }

    private void addBadAnyOfTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal((Object)"blee").and(builder.anyOf("managedEmployees"));
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test and with an anyof.");
        test.setExceptionCode(6122);
        test.setExpression(expression);
        test.setName("BadAnyOfTest");
        this.addTest((Test)test);
    }

    private void addBetweenTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").between(33000, 36000);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("BetweenExpressionTest");
        test.setDescription("Test BETWEEN expression");
        this.addTest((Test)test);
    }

    private void addBetweenTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").between((Object)builder.get("manager").get("salary"), (Object)new Integer(500000));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 5);
        test.setExpression(expression);
        test.setName("BetweenExpressionTest 2");
        test.setDescription("Test BETWEEN expression 2");
        this.addTest((Test)test);
    }

    protected void addBuilderEqualParameterTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.equal(emp.getParameter("employee"));
        ReadAllQuery query = new ReadAllQuery(Employee.class, expression);
        query.addArgument("employee");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setQuery(query);
        test.getArguments().add(employee);
        test.setName("BuilderEqualParameter");
        test.setDescription("For bug 3003399 tests ExpressionBuilder.equal(ParameterExpression).");
        this.addTest((Test)test);
    }

    private void addComplexBooleanTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Calendar c = Calendar.getInstance();
        c.set(1992, 0, 1);
        Date lowDate = new Date(c.getTime().getTime());
        c.set(1994, 0, 1);
        Date highDate = new Date(c.getTime().getTime());
        Expression exp = emp.get("firstName").equal((Object)"Fred").and(emp.get("lastName").like("Jo%"));
        Expression subExp1 = emp.get("gender").equal((Object)"Female").and(emp.get("period").get("startDate").greaterThan((Object)lowDate).and(emp.get("period").get("startDate").lessThan((Object)highDate)));
        Expression subExp2 = emp.get("salary").greaterThan(400000).and(emp.get("firstName").notEqual((Object)"Fred"));
        exp = exp.or(subExp1.or(subExp2));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(exp);
        test.setName("Complex Boolean Test");
        test.setDescription("Test expression with complicated ands/ors");
        this.addTest((Test)test);
    }

    private void addComputerViewCursoredStreamTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("memory").greaterThan(100);
        ReadAllExpressionTest test = new ReadAllExpressionTest(org.eclipse.persistence.testing.models.inheritance.Computer.class, 2);
        ReadAllQuery query = new ReadAllQuery(org.eclipse.persistence.testing.models.inheritance.Computer.class, expression);
        query.useCursoredStream(1, 1);
        test.setExpression(expression);
        test.setQuery(query);
        test.setName("ComputerViewCursoredStreamTest");
        test.setDescription("Test query using cursors with inheritance, supported if using views.  For bug 2718118.");
        test.addSupportedPlatform(OraclePlatform.class);
        test.addSupportedPlatform(SybasePlatform.class);
        test.addSupportedPlatform(SQLAnywherePlatform.class);
        this.addTest((Test)test);
    }

    private void addComputerViewTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("memory").greaterThan(100);
        ReadAllExpressionTest test = new ReadAllExpressionTest(org.eclipse.persistence.testing.models.inheritance.Computer.class, 2);
        test.setExpression(expression);
        test.setName("ComputerViewTest1");
        test.setDescription("Test expression against view, or multiple table subclass read.");
        this.addTest((Test)test);
    }

    private void addConstantEqualConstantTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.value(1).equal(1);
        expression = expression.and(builder.value(1).equal(builder.value(1)));
        expression = expression.and(builder.value(1).equal(builder.getParameter("1")));
        ReadAllQuery query = new ReadAllQuery(Employee.class, expression);
        query.addArgument("1", Integer.class);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setQuery(query);
        test.getArguments().add(new Integer(1));
        test.setName("ConstantEqualConstantTest");
        test.setDescription("Test meaningless selection criteria like 1 == 1.");
        this.addTest((Test)test);
    }

    private void addCustomDefaultExpressionTest() {
        DefaultingFunctionsExpressionTest test = new DefaultingFunctionsExpressionTest(Employee.class, 1);
        test.setDescription("Test a database function we don't know about that is generated dynamically from the user expression");
        test.setName("Custom Default Expression Test");
        test.setSupportedInMemory(false);
        this.addTest((Test)test);
    }

    private void addCustomQKJoinTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"A1");
        ReadAllExpressionTest test = new ReadAllExpressionTest(ObjectB.class, 1);
        test.setExpression(expression);
        test.setSupportedInMemory(false);
        test.setName("CustomQKJoinExpressionTest1");
        test.setDescription("Test expression with user define query key joins.");
        this.addTest((Test)test);
    }

    private void addCustomQKJoinTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("root").get("name").equal((Object)"A1");
        ReadAllExpressionTest test = new ReadAllExpressionTest(ObjectC.class, 2);
        test.setExpression(expression);
        test.setSupportedInMemory(false);
        test.setName("CustomQKJoinExpressionTest2");
        test.setDescription("Test expression with user define query key joins.");
        this.addTest((Test)test);
    }

    private void addCustomQKTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("id").greaterThan(0);
        ReadAllExpressionTest test = new ReadAllExpressionTest(PhoneNumber.class, 26);
        test.setExpression(expression);
        test.setSupportedInMemory(false);
        test.setName("CustomQKExpressionTest1");
        test.setDescription("Test expression with user defined direct query key.");
        this.addTest((Test)test);
    }

    private void addDirectCollectionJoinTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("responsibilitiesList").like("%coffe%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("DirectCollectionJoinTest1");
        test.setDescription("Test a join across a direct collection relation");
        this.addTest((Test)test);
    }

    private void addEqualDoubleTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").equal(35000.0);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("EqualDoubleExpressionTest");
        test.setDescription("Test = expression");
        this.addTest((Test)test);
    }

    private void addEqualTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").equal((Object)"Chanley");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("EqualExpressionTest");
        test.setDescription("Test = expression");
        this.addTest((Test)test);
    }

    private void addEqualUnneccessaryJoinTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0008");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal((Object)"Fred").or(builder.get("manager").notEqual(builder.get("manager")));
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("EqualUnneccessaryJoinTest");
        test.setDescription("Test = expression does not create an extra unneccessary join");
        this.addTest((Test)test);
    }

    private void addExpressionFunctionTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("salary").lessThan(100000);
        exp = exp.and(builder.get("firstName").toUpperCase().equal((Object)"BOB"));
        exp = exp.and(builder.get("firstName").toLowerCase().equal((Object)"bob"));
        exp = exp.and(builder.get("firstName").leftTrim().equal((Object)"Bob"));
        exp = exp.and(builder.get("firstName").rightTrim().equal((Object)"Bob"));
        exp = exp.and(builder.get("firstName").cast("CHAR(3)").equal((Object)"Bob"));
        exp = exp.and(builder.get("period").get("startDate").extract("YEAR").equal(1996));
        exp = exp.and(builder.get("firstName").concat((Object)builder.get("lastName")).equal((Object)"BobSmith"));
        exp = exp.and(builder.get("firstName").substring(2).equal((Object)"ob"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(exp);
        test.setName("ExpressionFunctionTest");
        test.setSupportedInMemory(false);
        test.setDescription("expression function test");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        test.addUnsupportedPlatform(MaxDBPlatform.class);
        this.addTest((Test)test);
    }

    private void addExpressionMathTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(1000);
        expression = expression.and(ExpressionMath.add((Expression)builder.get("salary"), (Object)new Integer(3000)).lessThan(90000));
        expression = expression.and(ExpressionMath.subtract((Expression)builder.get("salary"), (Object)new Integer(1000)).greaterThan(1000));
        expression = expression.and(ExpressionMath.multiply((Expression)builder.get("salary"), (Object)new Integer(3)).greaterThan(50000));
        expression = expression.and(ExpressionMath.divide((Expression)builder.get("salary"), (Object)new Integer(3)).lessThan(100000));
        expression = expression.and(ExpressionMath.abs((Expression)builder.get("salary")).lessThan(100000));
        expression = expression.and(ExpressionMath.cos((Expression)builder.get("salary")).lessThanEqual(1));
        expression = expression.and(ExpressionMath.sin((Expression)builder.get("salary")).lessThanEqual(1));
        expression = expression.and(ExpressionMath.tan((Expression)builder.get("salary")).lessThanEqual(1));
        expression = expression.and(ExpressionMath.log((Expression)builder.get("salary")).greaterThan(4));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("ExpressionMathTest");
        test.setDescription("Test expression math package");
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        test.addUnsupportedPlatform(SymfowarePlatform.class);
        test.addUnsupportedPlatform(MaxDBPlatform.class);
        this.addTest((Test)test);
    }

    private void addExpressionsDefaultingFieldTest() {
        Expression expression = new ExpressionBuilder().getField("L_NAME").equal((Object)"Way");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setDescription("Test that field references without a table default correctly");
        test.setName("FieldDefaultingTest");
        this.addTest((Test)test);
    }

    private void addGetFunctionWithTwoArgumentsTest() {
        GetFunctionWithTwoArgumentsTest test = new GetFunctionWithTwoArgumentsTest(Employee.class, 1);
        test.setDescription("Tests a database function with two arguments");
        test.setName("GetFunction() With Two Arguments Test");
        test.setSupportedInMemory(false);
        this.addTest((Test)test);
    }

    private void addGreaterThanEqualTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(99999.99);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("GreaterThanEqualExpressionTest");
        test.setDescription("Test >= expression");
        this.addTest((Test)test);
    }

    private void addGreaterThanTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").greaterThan((Object)"N");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 7);
        test.setExpression(expression);
        test.setName("GreaterThanExpressionTest");
        test.setDescription("Test > expression");
        this.addTest((Test)test);
    }

    private void addInConversionTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("gender").in((Object[])new String[]{"Male", "Female"});
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setName("InConversionTest");
        test.setDescription("Test that in converts correctly");
        this.addTest((Test)test);
    }

    private void addInMultipleExpressionParameterTest() {
        ExpressionBuilder ex = new ExpressionBuilder();
        Vector<Expression> vec = new Vector<Expression>();
        vec.add(ex.getParameter("salary1"));
        vec.add(ex.getParameter("salary2"));
        vec.add(ex.getParameter("salary3"));
        Expression exp = ex.get("salary").in(vec);
        ReadAllQuery rq = new ReadAllQuery(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.addArgument("salary1");
        rq.addArgument("salary2");
        rq.addArgument("salary3");
        Vector<Integer> vect = new Vector<Integer>();
        vect.add(87000);
        vect.add(31000);
        vect.add(500001);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setQuery(rq);
        test.setArguments(vect);
        test.setName("InMultipleExpressionParameterTest");
        test.setDescription("Test Expression IN with multiple parameters");
        this.addTest((Test)test);
    }

    private void addInMultipleExpressionWithConvertionParameterTest() {
        ExpressionBuilder ex = new ExpressionBuilder();
        Vector<Expression> vec = new Vector<Expression>();
        vec.add(ex.getParameter("gender1"));
        vec.add(ex.getParameter("gender2"));
        Expression exp = ex.get("gender").in(vec);
        ReadAllQuery rq = new ReadAllQuery(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.addArgument("gender1");
        rq.addArgument("gender2");
        Vector<String> vect = new Vector<String>();
        vect.add("Male");
        vect.add("Female");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setQuery(rq);
        test.setArguments(vect);
        test.setName("InMultipleExpressionWithConversionParameterTest");
        test.setDescription("Test Expression IN with multiple parameters that require convertion");
        this.addTest((Test)test);
    }

    private void addInSingleVectorParameterTest() {
        ExpressionBuilder ex = new ExpressionBuilder();
        Vector<Expression> vec = new Vector<Expression>();
        vec.add(ex.getParameter("salary1"));
        Expression exp = ex.get("salary").in(ex.getParameter("list"));
        ReadAllQuery rq = new ReadAllQuery(Employee.class);
        rq.setSelectionCriteria(exp);
        rq.addArgument("list");
        Vector<Integer> vect1 = new Vector<Integer>();
        vect1.add(87000);
        vect1.add(31000);
        vect1.add(500001);
        Vector<Vector<Integer>> vect = new Vector<Vector<Integer>>();
        vect.add(vect1);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setQuery(rq);
        test.setArguments(vect);
        test.setName("InSingleVectorParameterTest");
        test.setDescription("Test Expression IN with one list parameter");
        this.addTest((Test)test);
    }

    private void addInTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        Vector<String> names = new Vector<String>();
        names.addElement("Jennifer");
        names.addElement("Chanley");
        names.addElement("Beavis");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").in(names);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("InExpressionTest");
        test.setDescription("Test IN expression");
        this.addTest((Test)test);
    }

    private void addInCollectionTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        HashSet<String> names = new HashSet<String>();
        names.add("Jennifer");
        names.add("Chanley");
        names.add("Beavis");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").in(names);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("InCollectionExpressionTest");
        test.setDescription("Test IN expression");
        this.addTest((Test)test);
    }

    private void addIsNotNullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").notEqual(null);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setName("IsNotNullExpressionTest");
        test.setDescription("Test IS NOT NULL expression");
        this.addTest((Test)test);
    }

    private void addIsNotNullWithJoinTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("projects").get("teamLeader").notEqual(null);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setExpression(expression);
        test.setName("IsNotNullWithJoinExpressionTest");
        test.setDescription("Test IS NOT NULL expression with an additional join (for cr2334).");
        this.addTest((Test)test);
    }

    private void addIsNullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal(null);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("IsNullExpressionTest");
        test.setDescription("Test IS NULL expression");
        this.addTest((Test)test);
    }

    private void addIsNullWithJoinTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("projects").get("teamLeader").equal(null);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("IsNullWithJoinExpressionTest");
        test.setDescription("Test IS NULL expression with an additional join (for cr2334).");
        this.addTest((Test)test);
    }

    private void addJoinsShrinkResultSetSizeTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("firstName").notEqual((Object)"Zanthara").not();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("JoinsShrinkResultSetSizeTest");
        test.setDescription("Tests that joins shrink the size of a result set.  Exclusively added to break in memory querying.");
        this.addTest((Test)test);
    }

    private void addJoinsShrinkResultSetSizeTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("manager").get("firstName").notEqual((Object)"Zanthara").not();
        this.addTruncCurrentDateTest();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("JoinsShrinkResultSetSizeTest2");
        test.setDescription("Tests that joins shrink the size of a result set.  Exclusively added to break in memory querying.");
        this.addTest((Test)test);
    }

    private void addLessThanEqualTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").lessThanEqual(99999.99);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 10);
        test.setExpression(expression);
        test.setName("LessThanEqualExpressionTest");
        test.setDescription("Test <= expression");
        this.addTest((Test)test);
    }

    private void addLessThanTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").lessThan((Object)"B");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("LessThanExpressionTest");
        test.setDescription("Test < expression");
        this.addTest((Test)test);
    }

    private void addLikeEscapeTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").like("/%han", "/");
        ReadAllExpressionTest test = new ReadAllExpressionTest(employee.getClass(), 0);
        test.setExpression(expression);
        test.setName("LikeEscapeExpressionTest");
        test.setDescription("Test LIKE ESCAPE expression");
        test.addSupportedPlatform(OraclePlatform.class);
        test.addSupportedPlatform(SybasePlatform.class);
        test.addSupportedPlatform(SQLAnywherePlatform.class);
        test.addSupportedPlatform(SQLServerPlatform.class);
        test.addSupportedPlatform(DB2Platform.class);
        test.addSupportedPlatform(MySQLPlatform.class);
        this.addTest((Test)test);
    }

    public void addLikeIgnoreCaseTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").likeIgnoreCase("%haNLey");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("LikeIgnoreCaseExpressionTest");
        test.setDescription("Test LIKEIGNORECASE expression");
        this.addTest((Test)test);
    }

    private void addLikeIgnoringCaseTest1() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").likeIgnoreCase("cHANley");
        Expression exp2 = builder.get("firstName").likeIgnoreCase("%arles");
        Expression expression = exp1.and(exp2);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("LikeIgnoreCaseTest");
        test.setDescription("Test likeIgnoreCase expression");
        this.addTest((Test)test);
    }

    private void addLikeIgnoringCaseTest2() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").likeIgnoreCase("cHANlEy");
        Expression exp2 = builder.get("firstName").likeIgnoreCase("%harles");
        Expression exp3 = builder.get("gender").likeIgnoreCase("m");
        Expression expression = exp1.and(exp2).and(exp3);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("LikeIgnoreCaseTest2");
        test.setDescription("Test likeIgnoreCase expression");
        this.addTest((Test)test);
    }

    private void addLikeTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").like("%hanley");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("LikeExpressionTest");
        test.setDescription("Test LIKE expression");
        this.addTest((Test)test);
    }

    private void addLowerCaseTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").get("city").toLowerCase().equal((Object)"ottawa");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("LowerCaseExpressionTest");
        test.setDescription("Test LOWER expression");
        this.addTest((Test)test);
    }

    private void addManyToManyJoinTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Object[] array = new Object[]{"Sales Reporter", "Sales Reporting"};
        Expression expression = builder.anyOf("projects").get("name").in(array);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 3);
        test.setExpression(expression);
        test.setName("ManyToManyJoinTest1");
        test.setDescription("Test a join across a many:many relation");
        this.addTest((Test)test);
    }

    private void addManyToManyJoinTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Object[] array = new Object[]{"Ottawa"};
        Expression expression = builder.anyOf("locations").get("city").in(array);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Restaurant.class, 2);
        test.setExpression(expression);
        test.setName("ManyToManyJoinTest2");
        test.setDescription("Test a join across a many:many relation");
        this.addTest((Test)test);
    }

    private void addManyToManyJoinTest3() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Object[] array = new Object[]{"Ottawa", "Toronto"};
        Expression expression = builder.anyOf("locations").get("city").in(array);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Restaurant.class, 2);
        test.setExpression(expression);
        test.setName("ManyToManyJoinTest3");
        test.setDescription("Test a join across a many:many relation");
        this.addTest((Test)test);
    }

    private void addManyToManyJoinTest4() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("employees").get("sex").equal((Object)"female");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Shipment.class, 4);
        test.setExpression(expression);
        test.setName("ManyToManyJoinTest4");
        test.setDescription("Test a join across a many:many relation");
        this.addTest((Test)test);
    }

    private void addManyToManyJoinTest5() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("teamLeader").anyOf("projects").get("name").like("S%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 2);
        test.setExpression(expression);
        test.setName("ManyToManyJoinTest5");
        test.setDescription("Test a join across a many:many relation againts an abstarct multiple table class");
        this.addTest((Test)test);
    }

    private void addMismatchedQueryKeyTest() {
        Expression expression = new ExpressionBuilder().get("address").equal(2);
        BadExpressionTest test = new BadExpressionTest();
        test.setDescription("Test that mismatched expressions (e.g. address == 2) are error handled correctly");
        test.setExceptionCode(6078);
        test.setExpression(expression);
        test.setName("MismatchedQueryKeyTest");
        this.addTest((Test)test);
    }

    private void addMultiPlatformTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Hashtable<String, String> caseTable = new Hashtable<String, String>(3);
        caseTable.put("Bob", "Bobby");
        caseTable.put("Susan", "Susie");
        caseTable.put("Eldrick", "Tiger");
        Expression expression = builder.get("firstName").ifNull((Object)"Bob").caseStatement(caseTable, (Object)"No-Nickname").equal((Object)"Bobby");
        expression = expression.and(ExpressionMath.mod((Expression)builder.get("salary"), (Object)new Integer(10)).equal(0));
        expression = expression.and(ExpressionMath.ceil((Expression)builder.get("salary")).equal(35000));
        expression = expression.and(builder.get("firstName").length().equal(3));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("MultiPlatformTest");
        test.setDescription("test functions on multiple platforms");
        test.addUnsupportedPlatform(DB2Platform.class);
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        test.addUnsupportedPlatform(SybasePlatform.class);
        this.addTest((Test)test);
    }

    private void addMultiPlatformTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Hashtable<String, String> caseTable = new Hashtable<String, String>(3);
        caseTable.put("Bob", "Bobby");
        caseTable.put("Susan", "Susie");
        caseTable.put("Eldrick", "Tiger");
        Expression expression = builder.get("firstName").caseStatement(caseTable, (Object)"NoNickname").equal((Object)"Bobby");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("MultiPlatformTest2");
        test.setDescription("test simple Case function on multiple platforms");
        test.addUnsupportedPlatform(DerbyPlatform.class);
        test.addUnsupportedPlatform(SybasePlatform.class);
        this.addTest((Test)test);
    }

    private void addMultiPlatformTest3() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Hashtable<Expression, String> caseTable = new Hashtable<Expression, String>(3);
        caseTable.put(builder.get("firstName").equal((Object)"Bob"), "Bobby");
        caseTable.put(builder.get("firstName").equal((Object)"Susan"), "Susie");
        caseTable.put(builder.get("firstName").equal((Object)"Eldrick"), "Tiger");
        Expression expression = builder.caseConditionStatement(caseTable, (Object)"No-Nickname").equal((Object)"Bobby");
        expression = expression.and(ExpressionMath.mod((Expression)builder.get("salary"), (Object)new Integer(10)).equal(0));
        expression = expression.and(ExpressionMath.ceil((Expression)builder.get("salary")).equal(35000));
        expression = expression.and(builder.get("firstName").length().equal(3));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("MultiPlatformTest3");
        test.setDescription("test Case function with more complex expressions on multiple platforms");
        test.addUnsupportedPlatform(SybasePlatform.class);
        this.addTest((Test)test);
    }

    private void addMultiPlatformTest4() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").nullIf((Object)"Bobby").equal((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("MultiPlatformTest4");
        test.setDescription("test Case and NullIf function on multiple platforms");
        this.addTest((Test)test);
    }

    private void addMultiPlatformTest5() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Vector<Object> caseTable = new Vector<Object>(3);
        caseTable.add(builder.get("firstName"));
        caseTable.add(builder.get("lastName"));
        caseTable.add("NoName");
        Expression expression = builder.coalesce(caseTable).equal((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("MultiPlatformTest5");
        test.setDescription("test Coalesce function on multiple platforms");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").equal((Object)new Address()).and(builder.get("lastName").notEqual((Object)"foopoyp"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("MultipleAndsExpressionTest");
        test.setDescription("Test object equality with object will null primary key");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Address a = new Address();
        a.setId(new BigDecimal(123456));
        Expression expression = builder.get("address").equal((Object)a).and(builder.get("id").greaterThan(800));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setQuery(new ReadAllQuery(Employee.class, expression));
        test.getQuery().addAscendingOrdering("id");
        test.setExpression(expression);
        test.setName("MultipleAndsExpressionTest2");
        test.setDescription("Test multiple ands with object equality");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest3() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Address a = new Address();
        a.setId(new BigDecimal(123456));
        Expression expression = builder.get("id").greaterThan(800).and(builder.get("address").equal((Object)a));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setQuery(new ReadAllQuery(Employee.class, expression));
        test.getQuery().addAscendingOrdering("id");
        test.setExpression(expression);
        test.setName("MultipleAndsExpressionTest3");
        test.setDescription("Test multiple ands with object equality");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest4() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Address address1 = new Address();
        address1.setId(new BigDecimal(999999876));
        Address address2 = new Address();
        address2.setId(new BigDecimal(999999877));
        Expression expression1 = builder.get("address").equal((Object)address1).or(builder.get("lastName").equal((Object)"Smith"));
        Expression expression2 = builder.get("address").equal((Object)address2).or(builder.get("firstName").equal((Object)"Bob"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression1.and(expression2));
        test.setName("MultipleAndsExpressionTest4");
        test.setDescription("Test multiple booleans with supression in each branch");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest5() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").equal(null).and(builder.get("lastName").notEqual((Object)"foopoyp"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("MultipleAndsExpressionTest5");
        test.setDescription("Test multiple ands expression");
        this.addTest((Test)test);
    }

    private void addMultipleAndsTest6() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").isNull().and(builder.get("lastName").notEqual((Object)"foopoyp"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("MultipleAndsExpressionTest6");
        test.setDescription("Test multiple ands expression");
        this.addTest((Test)test);
    }

    private void addMultiplePrimaryKeyTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("employee").get("lastName").equal((Object)"Vadis");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Computer.class, 1);
        test.setExpression(expression);
        test.setName("MultiplePrimaryKeyTest");
        test.setDescription("Test expression with multiple primary key");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("car").get("fuelCapacity").equal(50);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Engineer.class, 1);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest1");
        test.setDescription("Test expression with joins");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("car").get("description").equal((Object)"BMW");
        ReadAllExpressionTest test = new ReadAllExpressionTest(SalesRep.class, 1);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest2");
        test.setDescription("Test expression with joins");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest3() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("car").get("passengerCapacity").equal(5);
        ReadAllExpressionTest test = new ReadAllExpressionTest(SalesRep.class, 1);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest3");
        test.setDescription("Test expression with joins");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest4() {
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression expression = employee.get("manager").get("address").get("street").toLowerCase().like("%mer%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression.and(employee.get("firstName").notLike("NOTHING ON EARTH")));
        test.setName("MultipleTableJoinExpressionTest4");
        test.setDescription("Test expression with self-joins");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest5() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("manager").get("lastName").like("Sm%");
        expression = expression.and(emp.get("lastName").like("%a%"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest5");
        test.setDescription("Test expression with self joins, criteria on both tables and no other tables");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest6() {
        ExpressionBuilder project = new ExpressionBuilder();
        Expression expression = project.get("teamLeader").get("address").get("street").like("12 Mer%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 1);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest6");
        test.setDescription("Test expression with joins and inheritance on queried class");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest7() {
        ExpressionBuilder project = new ExpressionBuilder();
        Expression expression = project.get("teamLeader").get("address").get("street").like("12 Mer%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 1);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest7");
        test.setDescription("Test expression with joins and inheritance on intermediate class");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest8() {
        ExpressionBuilder project = new ExpressionBuilder();
        Expression expression = project.get("budget").get("currency").like("C%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(LargeBusinessProject.class, 2);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest8");
        test.setDescription("Test expression with joins and inheritance on intermediate class");
        this.addTest((Test)test);
    }

    private void addMultipleTableJoinTest9() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("bestFriend").get("representitive").get("car").get("fuelCapacity").equal(50);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Engineer.class, 0);
        test.setExpression(expression);
        test.setName("MultipleTableJoinExpressionTest9");
        test.setDescription("Test expression with joins");
        this.addTest((Test)test);
    }

    private void addNonFueledVehicleViewTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(NonFueledVehicle.class, 3);
        test.setExpression(expression);
        test.setName("NonFueledVehicleViewTest1");
        test.setDescription("Test expression against view, or multiple table subclass read.");
        this.addTest((Test)test);
    }

    private void addNotInTest() {
        int[] salaries = new int[]{35000, 6000, 50000};
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").notIn(salaries);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 10);
        test.setExpression(expression);
        test.setName("NotInExpressionTest");
        test.setDescription("Test NOT IN expression");
        this.addTest((Test)test);
    }

    private void addNotLikeTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("lastName").notLike("W%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 9);
        test.setExpression(expression);
        test.setName("NotLikeExpressionTest");
        test.setDescription("Test NOT LIKE expression");
        this.addTest((Test)test);
    }

    private void addNotTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(99999.99).not().and(builder.get("firstName").equal((Object)"Bob")).not();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 11);
        test.setExpression(expression);
        test.setName("NotExpressionTest");
        test.setDescription("Test NOT expression");
        this.addTest((Test)test);
    }

    private void addObjectComparisonAcrossJoin() {
        Address address = ((Employee)this.getManager().getObject(Employee.class, "0002")).getAddress();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("manager").get("address").equal((Object)address);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("ObjectComparisonAcrossJoin");
        test.setDescription("Test .manager.address.equal(address)");
        this.addTest((Test)test);
    }

    private void addAggregateObjectObjectComparisonTest() {
        EmploymentPeriod period = ((Employee)this.getManager().getObject(Employee.class, "0002")).getPeriod();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").equal((Object)period);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setSupportedInMemory(false);
        test.setName("AggregateObjectObjectComparisonTest");
        test.setDescription("Test .period.equal(period)");
        this.addTest((Test)test);
    }

    private void addAggregateObjectIsNullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").isNull();
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("AggregateObjectIsNullTest");
        test.setDescription("Test .period.isNull()");
        this.addTest((Test)test);
    }

    private void addAggregateObjectNullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").notEqual(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setName("AggregateObjectNullTest");
        test.setDescription("Test .period.notEqual(null)");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinObjectCompareTest() {
        Employee managed = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0001");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").equal((Object)managed);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("OneToManyJoinObjectCompareTest");
        test.setDescription("Test a join across a 1:many relation using object comparison");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinObjectCompareTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").equal((Expression)builder);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("OneToManyJoinObjectCompareTest2");
        test.setDescription("Test a join across a 1:many relation using object comparison to itself");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").like("S%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("OneToManyJoinTest1");
        test.setDescription("Test a join across a 1:many relation");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinTest2() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").like("Sa%");
        Expression exp2 = builder.anyOf("managedEmployees").get("firstName").like("B%");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression.and(exp2));
        test.setName("OneToManyJoinTest2");
        test.setDescription("Test a join across a 1:many relation with 2 anyOf clauses");
        this.addTest((Test)test);
    }

    private void addOneToManyJoin2WithBatchReadTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").like("Sa%");
        Expression exp2 = builder.anyOf("managedEmployees").get("firstName").like("B%");
        expression = expression.and(exp2);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.testBatchAttributesOnEmployee();
        test.setName("OneToManyJoin2WithBatchReadTest");
        test.setDescription("Test a join across a 1:many relation with 2 anyOf clauses, and test again as part of a batch read.");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinTest3() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").equal((Object)"Smith");
        Expression exp2 = builder.anyOf("managedEmployees").get("lastName").notEqual((Object)"Smith");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression.and(exp2));
        test.setName("OneToManyJoinTest3");
        test.setDescription("Test a join across a 1:many relation with 2 anyOf clauses");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinTest4() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("managedEmployees").get("lastName").like("S%");
        Expression exp2 = builder.anyOf("managedEmployees").get("lastName").equal((Object)"Smith");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression.and(exp2));
        test.setName("OneToManyJoinTest4");
        test.setDescription("Test a join across a 1:many relation with 2 anyOf clauses");
        this.addTest((Test)test);
    }

    private void addOneToManyJoinTest5() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("teamLeader").anyOf("phoneNumbers").get("areaCode").equal((Object)"905");
        Expression exp2 = builder.get("teamLeader").anyOf("phoneNumbers").get("areaCode").equal((Object)"613");
        ReadAllExpressionTest test = new ReadAllExpressionTest(LargeProject.class, 2);
        test.setExpression(expression.and(exp2));
        test.setName("OneToManyJoinTest5");
        test.setDescription("Test a join from 1;1 Mapping to 1:m relation (twice) with 2 anyOf clauses");
        this.addTest((Test)test);
    }

    private void addOneToOneEqualTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        Expression expression = new ExpressionBuilder().get("address").equal((Object)employee.getAddress());
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setDescription("Test equal for 1-1 mappings (e.g. get('address').equal(myAddress)");
        test.setExpression(expression);
        test.setName("OneToOneEqualTest");
        this.addTest((Test)test);
    }

    private void addOneToOneObjectTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").equal(this.getManager().getObject(Employee.class, "0001"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(PhoneNumber.class, 1);
        test.setExpression(expression);
        test.setName("OneToOneExpressionUsingObjectAsValue1");
        test.setDescription("Test querying across a 1:1 mapping using an object as the value.");
        this.addTest((Test)test);
        builder = new ExpressionBuilder();
        expression = builder.get("manager").equal(this.getManager().getObject(Employee.class, "0001"));
        test = new ReadAllExpressionTest(Employee.class, 3);
        test.setExpression(expression);
        test.setName("OneToOneExpressionUsingObjectAsValue2");
        test.setDescription("Test querying across a 1:1 mapping using an object as the value.");
        this.addTest((Test)test);
    }

    private void addOrNullTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").equal((Object)"Chanley");
        Expression exp2 = builder.get("firstName").equal((Object)"Charles");
        Expression expression = exp1.or(exp2).or(null);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("OrNullExpressionTest");
        test.setDescription("Test OR expression with NULL");
        this.addTest((Test)test);
    }

    private void addOrTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp1 = builder.get("lastName").equal((Object)"Chanley");
        Expression exp2 = builder.get("firstName").equal((Object)"Charles");
        Expression expression = exp1.or(exp2);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("OrExpressionTest");
        test.setDescription("Test OR expression");
        this.addTest((Test)test);
    }

    private void addParameterIsNullTest() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression expression = emp.get("address").notNull().and(emp.getParameter("null").isNull());
        expression = expression.and(emp.getParameter("int").notNull());
        expression = expression.and(emp.getParameter("String").notNull());
        ReadAllQuery query = new ReadAllQuery(Employee.class, expression);
        query.addArgument("null");
        query.addArgument("int");
        query.addArgument("String");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setExpression(expression);
        test.setQuery(query);
        test.getArguments().add(null);
        test.getArguments().add(new Integer(1));
        test.getArguments().add(new String("String"));
        test.setName("ParameterIsNullTest");
        test.setDescription("For bug 3107049 tests parameterExp.isNull.");
        test.addUnsupportedPlatform(SybasePlatform.class);
        test.addSupportedPlatform(SQLAnywherePlatform.class);
        test.addUnsupportedPlatform(DB2Platform.class);
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        this.addTest((Test)test);
    }

    private void addValueEqualValueTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.value(123).equal(456);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Address.class, 0);
        test.setExpression(expression);
        test.setName("ValueEqualValueTest");
        test.setDescription("Test query with no fields in where clause works.");
        this.addTest((Test)test);
    }

    private void addSelectionObjectWithoutPrepareTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ReadObjectQuery query = new ReadObjectQuery((Object)employee);
        query.setShouldPrepare(false);
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, null);
        test.setQuery(query);
        test.setName("SelectionObjectWithoutPrepareTest");
        test.setDescription("Test expression with selection object and shouldPrepare(false).");
        this.addTest((Test)test);
    }

    private void addSelfManagedEmployeeTests() {
        ExpressionBuilder builder = new ExpressionBuilder(Employee.class);
        Expression expression = builder.equal(builder.get("manager"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("SelfManagedEmployeeTest");
        test.setDescription("Tests equal between two object expressions.  An optimization could mean this expression using a single table.");
        this.addTest((Test)test);
        Expression notExpression = ((Expression)expression.clone()).not();
        test = new ReadAllExpressionTest(Employee.class, 8);
        test.setExpression(notExpression);
        test.setName("NotSelfManagedEmployeeTest");
        test.setDescription("Test NOT of equal between two object expressions.  An optimization could mean this expression using a single table.");
        this.addTest((Test)test);
        builder = new ExpressionBuilder(Employee.class);
        Expression notEqualExpression = builder.notEqual(builder.get("manager"));
        test = new ReadAllExpressionTest(Employee.class, 8);
        test.setExpression(notEqualExpression);
        test.setName("NotEqualSelfManagedEmployeeTest");
        test.setDescription("Test notEqual between two object expressions.  An optimization could mean this expression using a single table.");
        this.addTest((Test)test);
    }

    private void addSingleTableJoinTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").get("city").equal((Object)"Ottawa");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("SingleTableJoinExpressionTest");
        test.setDescription("Test expression with joins");
        this.addTest((Test)test);
    }

    public void addTests() {
        this.addSRGTests();
        this.addAdvancedSybaseExpressionFunctionTest();
        this.addAdvancedDB2ExpressionFunctionTest();
        this.addInCollectionTest();
        this.addTest((Test)new LiteralExpressionTest());
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'?'", true));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'?'", false));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'???'", true));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'???'", false));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'? ? ?'", true));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("'? ? ?'", false));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("' 123?123 '", true));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("' 123?123 '", false));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("' 123 ? 123 '", true));
        this.addTest((Test)new LiteralSQLExpressionWithQuestionMarkTest("' 123 ? 123 '", false));
        this.addRegexpTest();
        this.addTest((Test)new LowerCaseForCaseInsensitiveTest("EqualsIgnoreCase"));
        this.addTest((Test)new LowerCaseForCaseInsensitiveTest("LikeIgnoreCase"));
        this.addTest((Test)new LowerCaseForCaseInsensitiveTest("ContainsSubstringIgnoringCase"));
    }

    public void addSRGTests() {
        this.setManager(PopulationManager.getDefaultManager());
        this.addAggregateObjectObjectComparisonTest();
        this.addAggregateObjectIsNullTest();
        this.addAggregateObjectNullTest();
        this.addMultipleAndsTest();
        this.addMultipleAndsTest2();
        this.addMultipleAndsTest3();
        this.addMultipleAndsTest4();
        this.addMultipleAndsTest5();
        this.addMultipleAndsTest6();
        this.addObjectComparisonAcrossJoin();
        this.addExpressionFunctionTest();
        this.addExpressionMathTest();
        this.addAdvancedExpressionFunctionTest();
        this.addAdvancedExpressionMathTest();
        this.addBuilderEqualParameterTest();
        this.addAndTest();
        this.addNotTest();
        this.addAndNullTest();
        this.addOrTest();
        this.addOrNullTest();
        this.addEqualTest();
        this.addEqualUnneccessaryJoinTest();
        this.addEqualDoubleTest();
        this.addGreaterThanEqualTest();
        this.addGreaterThanTest();
        this.addJoinsShrinkResultSetSizeTest();
        this.addJoinsShrinkResultSetSizeTest2();
        this.addLessThanEqualTest();
        this.addLessThanTest();
        this.addIsNullTest();
        this.addIsNullWithJoinTest();
        this.addIsNotNullTest();
        this.addIsNotNullWithJoinTest();
        this.addInTest();
        this.addInMultipleExpressionWithConvertionParameterTest();
        this.addInSingleVectorParameterTest();
        this.addInMultipleExpressionParameterTest();
        this.addNotInTest();
        this.addInConversionTest();
        this.addLikeTest();
        this.addLikeIgnoreCaseTest();
        this.addLikeIgnoringCaseTest1();
        this.addLikeIgnoringCaseTest2();
        this.addLikeEscapeTest();
        this.addNotLikeTest();
        this.addBetweenTest();
        this.addBetweenTest2();
        this.addSelectionObjectWithoutPrepareTest();
        this.addSelfManagedEmployeeTests();
        this.addSingleTableJoinTest();
        this.addMultiplePrimaryKeyTest();
        this.addMultipleTableJoinTest1();
        this.addMultipleTableJoinTest2();
        this.addMultipleTableJoinTest3();
        this.addMultipleTableJoinTest4();
        this.addMultipleTableJoinTest5();
        this.addMultipleTableJoinTest6();
        this.addMultipleTableJoinTest7();
        this.addMultipleTableJoinTest8();
        this.addMultipleTableJoinTest9();
        this.addCustomQKJoinTest1();
        this.addCustomQKJoinTest2();
        this.addCustomQKTest1();
        this.addComputerViewCursoredStreamTest();
        this.addComputerViewTest1();
        this.addVehicleViewCursoredStreamTest();
        this.addVehicleViewTest1();
        this.addVehicleViewOrderByJoinTest();
        this.addVehicleViewOrderByOnlyTest();
        this.addNonFueledVehicleViewTest1();
        this.addVehicleViewJoinOnlyTest();
        this.addBadQueryKeyTest();
        this.addMismatchedQueryKeyTest();
        this.addBadQueryTableTest();
        this.addBadFieldWithTableTest();
        this.addBadToManyQueryKeyTest();
        this.addBadFieldWithTableTest();
        this.addBadAnyOfTest();
        this.addExpressionsDefaultingFieldTest();
        this.addOneToOneEqualTest();
        this.addTransformationTest();
        this.addAggregateQueryTest();
        this.addLowerCaseTest();
        this.addUpperCaseTest();
        this.addCustomDefaultExpressionTest();
        this.addOneToManyJoinTest1();
        this.addOneToManyJoinTest2();
        this.addOneToManyJoin2WithBatchReadTest();
        this.addOneToManyJoinTest3();
        this.addOneToManyJoinTest4();
        this.addOneToManyJoinTest5();
        this.addManyToManyJoinTest1();
        this.addManyToManyJoinTest2();
        this.addManyToManyJoinTest3();
        this.addManyToManyJoinTest4();
        this.addManyToManyJoinTest5();
        this.addOneToManyJoinObjectCompareTest();
        this.addOneToManyJoinObjectCompareTest2();
        this.addDirectCollectionJoinTest1();
        this.addComplexBooleanTest();
        this.addOneToOneObjectTest();
        this.addGetFunctionWithTwoArgumentsTest();
        this.addAggregeateCollectionJoinTest(Agent.class);
        this.addAggregeateCollectionJoinTest(Builder.class);
        this.addTest((Test)new InvalidQueryKeyFunctionExpressionTest(new ExpressionBuilder().get("appartments").isNull()));
        this.addConstantEqualConstantTest();
        this.addParameterIsNullTest();
        this.addValueEqualValueTest();
        this.addMultiPlatformTest();
        this.addMultiPlatformTest2();
        this.addMultiPlatformTest3();
        this.addMultiPlatformTest4();
        this.addMultiPlatformTest5();
        this.addInheritanceTypeTest1();
        this.addInheritanceTypeTest2();
        this.addInheritanceTypeTest3();
    }

    private void addInheritanceTypeTest1() {
        ExpressionBuilder builder = new ExpressionBuilder(Project.class);
        Expression expression = builder.type().equal(SmallProject.class);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 10);
        test.setExpression(expression);
        test.setName("InheritanceTypeTest1");
        test.setDescription("Test ClassForInheritance expression using an equals comparison.");
        this.addTest((Test)test);
    }

    private void addInheritanceTypeTest2() {
        ExpressionBuilder builder = new ExpressionBuilder(Project.class);
        Expression expression = builder.type().equal(LargeProject.class);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 5);
        test.setExpression(expression);
        test.setName("InheritanceTypeTest2");
        test.setDescription("Test ClassForInheritance expression using an equals comparison.");
        this.addTest((Test)test);
    }

    private void addInheritanceTypeTest3() {
        ExpressionBuilder builder = new ExpressionBuilder(Project.class);
        Vector<Class> classes = new Vector<Class>();
        classes.add(LargeProject.class);
        classes.add(SmallProject.class);
        Expression expression = builder.type().in(classes);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Project.class, 15);
        test.setExpression(expression);
        test.setName("InheritanceTypeTest3");
        test.setDescription("Test ClassForInheritance expression using an In comparison.");
        this.addTest((Test)test);
    }

    private void addTransformationTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("gender").equal((Object)"Male");
        SearchTest test = new SearchTest();
        test.setExpression(expression);
        test.setErrorMessage("Failed to read objects from database (due to transformation failure)");
        test.setName("TransformationTest");
        test.setDescription("Test for correct transformation within a query (e.g. 'M' => 'Male')");
        this.addTest((Test)test);
    }

    private void addTruncCurrentDateTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").lessThanEqual(builder.currentDate().truncateDate("dd"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 12);
        test.setSupportedInMemory(false);
        test.setExpression(expression);
        test.setName("TruncCurrentDateTest");
        test.setDescription("Test if trunc on current date (SYSDATE) works.");
        test.addSupportedPlatform(OraclePlatform.class);
        this.addTest((Test)test);
    }

    private void addUpperCaseTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0002");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("address").get("city").toUpperCase().equal((Object)"OTTAWA");
        ReadObjectExpressionTest test = new ReadObjectExpressionTest(employee, expression);
        test.setName("UpperCaseExpressionTest");
        test.setDescription("Test UPPER expression");
        this.addTest((Test)test);
    }

    private void addVehicleViewCursoredStreamTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 5);
        ReadAllQuery query = new ReadAllQuery(Vehicle.class, expression);
        query.useCursoredStream(1, 1);
        test.setQuery(query);
        test.setName("VehicleViewCursoredStreamTest");
        test.setDescription("Test cursors with inheritance, supported if using views.  For bug 2718118.");
        test.addSupportedPlatform(OraclePlatform.class);
        test.addSupportedPlatform(SybasePlatform.class);
        test.addSupportedPlatform(SQLAnywherePlatform.class);
        this.addTest((Test)test);
    }

    private void addVehicleViewJoinOnlyTest() {
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 15);
        test.getQuery(true).addJoinedAttribute("owner");
        test.setName("VehicleViewJoinOnlyTest");
        test.setDescription("Test inheritance view with joining only.");
        test.addUnsupportedPlatform(MySQLPlatform.class);
        test.addUnsupportedPlatform(TimesTenPlatform.class);
        test.addUnsupportedPlatform(SQLServerPlatform.class);
        test.addUnsupportedPlatform(DB2Platform.class);
        this.addTest((Test)test);
    }

    private void addVehicleViewOrderByJoinTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 5);
        ReadAllQuery query = new ReadAllQuery(Vehicle.class, expression);
        query.addOrdering(builder.get("owner").get("name"));
        query.addJoinedAttribute("owner");
        query.useDistinct();
        test.setQuery(query);
        test.setName("VehicleViewOrderByJoinTest");
        test.setDescription("Test inheritance view with ordering and joining.");
        test.addSupportedPlatform(OraclePlatform.class);
        this.addTest((Test)test);
    }

    private void addVehicleViewOrderByOnlyTest() {
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 19);
        test.getQuery(true).addDescendingOrdering("id");
        test.setName("VehicleViewOrderByOnlyTest");
        test.setDescription("Test inheritance view with ordering only.");
        this.addTest((Test)test);
    }

    private void addVehicleViewTest1() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("owner").get("name").equal((Object)"ABC").and(builder.get("owner").get("name").equal((Object)"ABC")).and(builder.get("passengerCapacity").equal(-1).not());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Vehicle.class, 5);
        test.setExpression(expression);
        test.setName("VehicleViewTest1");
        test.setDescription("Test expression against view, or multiple table subclass read.");
        this.addTest((Test)test);
    }

    protected PopulationManager getManager() {
        return this.manager;
    }

    protected void setManager(PopulationManager theManager) {
        this.manager = theManager;
    }
}

