/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.inheritance;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.inheritance.STI_Employee;
import org.eclipse.persistence.testing.models.inheritance.STI_LargeProject;
import org.eclipse.persistence.testing.models.inheritance.STI_Project;
import org.eclipse.persistence.testing.models.inheritance.STI_SmallProject;

public class STI_EmployeeProject
extends Project {
    public STI_EmployeeProject() {
        this.setName("STI_Employee");
        this.applyLogin();
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildProjectDescriptor());
        this.addDescriptor(this.buildSmallProjectDescriptor());
        this.addDescriptor(this.buildLargeProjectDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.usePlatform((DatabasePlatform)new OraclePlatform());
        login.setDriverClassName("oracle.jdbc.OracleDriver");
        login.setConnectionString("jdbc:oracle:thin:@localhost:1521:orcl");
        login.setUserName("scott");
        login.setEncryptedPassword("3E20F8982C53F4ABA825E30206EC8ADE");
        login.setShouldBindAllParameters(false);
        login.setShouldCacheAllStatements(false);
        login.setUsesByteArrayBinding(true);
        login.setUsesStringBinding(false);
        if (login.shouldUseByteArrayBinding()) {
            login.setUsesStreamsForBinding(false);
        }
        login.setShouldForceFieldNamesToUpperCase(false);
        login.setShouldOptimizeDataConversion(true);
        login.setShouldTrimStrings(true);
        login.setUsesExternalConnectionPooling(false);
        login.setUsesExternalTransactionController(false);
        this.setDatasourceLogin((Login)login);
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(STI_Employee.class);
        descriptor.addTableName("STI_EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("STI_EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("STI_EMPLOYEE.EMP_ID");
        descriptor.setSequenceNumberName("STI_EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("STI_EMPLOYEE.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("STI_Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("STI_EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("STI_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("STI_EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(STI_Employee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("STI_EMPLOYEE.MANAGER_ID", "STI_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(STI_Employee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("STI_EMPLOYEE.MANAGER_ID", "STI_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        ManyToManyMapping projectsMapping = new ManyToManyMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setReferenceClass(STI_Project.class);
        projectsMapping.useBasicIndirection();
        projectsMapping.setRelationTableName("STI_PROJ_EMP");
        projectsMapping.addSourceRelationKeyFieldName("STI_PROJ_EMP.EMP_ID", "STI_EMPLOYEE.EMP_ID");
        projectsMapping.addTargetRelationKeyFieldName("STI_PROJ_EMP.PROJ_ID", "STI_PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        return descriptor;
    }

    public ClassDescriptor buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(STI_Project.class);
        descriptor.addTableName("STI_PROJECT");
        descriptor.addPrimaryKeyFieldName("STI_PROJECT.PROJ_ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("STI_PROJECT.PROJ_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(STI_SmallProject.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(STI_LargeProject.class, (Object)"L");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("STI_PROJECT.PROJ_ID");
        descriptor.setSequenceNumberName("STI_PROJ_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("STI_PROJECT.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("STI_Project");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("STI_PROJECT.DESCRIP");
        descriptionMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("STI_PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("STI_PROJECT.PROJ_NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping teamLeaderMapping = new OneToOneMapping();
        teamLeaderMapping.setAttributeName("teamLeader");
        teamLeaderMapping.setReferenceClass(STI_Employee.class);
        teamLeaderMapping.useBasicIndirection();
        teamLeaderMapping.addForeignKeyFieldName("STI_PROJECT.LEADER_ID", "STI_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)teamLeaderMapping);
        ManyToManyMapping teamMembersMapping = new ManyToManyMapping();
        teamMembersMapping.setAttributeName("teamMembers");
        teamMembersMapping.setReferenceClass(STI_Employee.class);
        teamMembersMapping.useBasicIndirection();
        teamMembersMapping.setRelationTableName("STI_PROJ_EMP");
        teamMembersMapping.addSourceRelationKeyFieldName("STI_PROJ_EMP.PROJ_ID", "STI_PROJECT.PROJ_ID");
        teamMembersMapping.addTargetRelationKeyFieldName("STI_PROJ_EMP.EMP_ID", "STI_EMPLOYEE.EMP_ID");
        teamMembersMapping.readOnly();
        descriptor.addMapping((DatabaseMapping)teamMembersMapping);
        return descriptor;
    }

    public ClassDescriptor buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(STI_SmallProject.class);
        descriptor.getInheritancePolicy().setParentClass(STI_Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("STI_SmallProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        return descriptor;
    }

    public ClassDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(STI_LargeProject.class);
        descriptor.getInheritancePolicy().setParentClass(STI_Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("STI_LargeProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("STI_PROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        return descriptor;
    }
}

