/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.tcp.Client;
import org.eclipse.ecf.provider.comm.tcp.ConnectRequestMessage;
import org.eclipse.ecf.provider.comm.tcp.ConnectResultMessage;
import org.eclipse.ecf.provider.comm.tcp.ISocketAcceptHandler;
import org.eclipse.ecf.provider.generic.SOContainerGroup;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;

public class SSLServerSOContainerGroup
extends SOContainerGroup
implements ISocketAcceptHandler {
    public static final int DEFAULT_BACKLOG = 50;
    public static final String INVALID_CONNECT = "Invalid connect request.";
    public static final String DEFAULT_GROUP_NAME;
    private int port = 0;
    private int backlog = 50;
    ServerSocket serverSocket;
    private boolean isOnTheAir = false;
    private ThreadGroup threadGroup;
    private InetAddress inetAddress;
    private Thread listenerThread;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_GROUP_NAME = clazz.getName();
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, int backlog, InetAddress inetAddress) {
        super(name);
        this.threadGroup = group;
        this.port = port;
        this.backlog = backlog;
        this.inetAddress = inetAddress;
        this.listenerThread = this.setupListener();
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, int backlog) {
        this(name, group, port, backlog, null);
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port, InetAddress bindAddress) {
        this(name, group, port, 50, bindAddress);
    }

    public SSLServerSOContainerGroup(String name, ThreadGroup group, int port) {
        this(name, group, port, 50);
    }

    public SSLServerSOContainerGroup(String name, int port) {
        this(name, null, port);
    }

    public SSLServerSOContainerGroup(int port) {
        this(DEFAULT_GROUP_NAME, null, port);
    }

    private SSLServerSocketFactory getSSLServerSocketFactory() {
        return ProviderPlugin.getDefault().getSSLServerSocketFactory();
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug", (String)msg);
    }

    protected void traceStack(String msg, Throwable e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", (Class)clazz, (String)msg, (Throwable)e);
    }

    private ServerSocket createServerSocket() throws IOException {
        SSLServerSocketFactory socketFactory = this.getSSLServerSocketFactory();
        if (socketFactory == null) {
            throw new IOException("Cannot get SSLServerSocketFactory to create SSLServerSocket");
        }
        return socketFactory.createServerSocket(this.port, this.backlog, this.inetAddress);
    }

    public synchronized void putOnTheAir() throws IOException {
        this.trace("SSLServerSOContainerGroup at port " + this.port + " on the air");
        this.serverSocket = this.createServerSocket();
        this.port = this.serverSocket.getLocalPort();
        this.isOnTheAir = true;
        this.listenerThread.start();
    }

    public synchronized boolean isOnTheAir() {
        return this.isOnTheAir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSyncAccept(Socket aSocket) throws Exception {
        Client newClient;
        aSocket.setTcpNoDelay(true);
        ObjectOutputStream oStream = new ObjectOutputStream(aSocket.getOutputStream());
        oStream.flush();
        ObjectInputStream iStream = new ObjectInputStream(aSocket.getInputStream());
        ConnectRequestMessage req = (ConnectRequestMessage)iStream.readObject();
        if (req == null) {
            throw new InvalidObjectException("Invalid connect request. Connect request message cannot be null");
        }
        URI uri = req.getTarget();
        if (uri == null) {
            throw new InvalidObjectException("Invalid connect request. URI connect target cannot be null");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new InvalidObjectException("Invalid connect request. Path cannot be null");
        }
        SSLServerSOContainer srs = (SSLServerSOContainer)this.get(path);
        if (srs == null) {
            throw new InvalidObjectException("Container not found for path=" + path);
        }
        Client client = newClient = new Client(aSocket, iStream, oStream, srs.getReceiver());
        synchronized (client) {
            Serializable resp = srs.handleConnectRequest(aSocket, path, req.getData(), newClient);
            oStream.writeObject(new ConnectResultMessage(resp));
            oStream.flush();
        }
    }

    public synchronized void takeOffTheAir() {
        this.trace("Taking " + this.getName() + " off the air.");
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
            this.listenerThread = null;
        }
        if (this.threadGroup != null) {
            this.threadGroup.interrupt();
            this.threadGroup = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", (Class)clazz, (String)"takeOffTheAir", (Throwable)e);
            }
            this.serverSocket = null;
        }
        this.isOnTheAir = false;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + ";port:" + this.port;
    }

    protected Thread setupListener() {
        return new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    while (true) {
                        SSLServerSOContainerGroup.this.handleAccept(SSLServerSOContainerGroup.this.serverSocket.accept());
                    }
                }
                catch (Exception e) {
                    SSLServerSOContainerGroup.this.traceStack("Exception in accept", e);
                    SSLServerSOContainerGroup.this.debug("SSLServerSOContaienrGroup closing listener normally.");
                    return;
                }
            }
        }, "SSLServerSOContainerGroup(" + this.port + ")");
    }

    public void handleAccept(final Socket aSocket) {
        new Thread(this.threadGroup, new Runnable(){

            public void run() {
                try {
                    SSLServerSOContainerGroup.this.debug("accept:" + aSocket.getInetAddress());
                    SSLServerSOContainerGroup.this.handleSyncAccept(aSocket);
                }
                catch (Exception e) {
                    SSLServerSOContainerGroup.this.traceStack("Unexpected exception in handleAccept...closing", e);
                    try {
                        aSocket.close();
                    }
                    catch (IOException e1) {
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4, "accept.close", (Throwable)e1));
                    }
                }
            }
        }).start();
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", (String)msg);
    }
}

