/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractMetadataFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DiscoveredEndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IDiscoveredEndpointDescriptionFactory;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

public class DiscoveredEndpointDescriptionFactory
extends AbstractMetadataFactory
implements IDiscoveredEndpointDescriptionFactory {
    protected List<DiscoveredEndpointDescription> discoveredEndpointDescriptions = new ArrayList<DiscoveredEndpointDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredEndpointDescription findDiscoveredEndpointDescription(EndpointDescription endpointDescription) {
        List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
        synchronized (list) {
            for (DiscoveredEndpointDescription d : this.discoveredEndpointDescriptions) {
                EndpointDescription ed = d.getEndpointDescription();
                if (!ed.equals((Object)endpointDescription)) continue;
                return d;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredEndpointDescription findUniscoveredEndpointDescription(IDiscoveryLocator locator, IServiceID serviceID) {
        List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
        synchronized (list) {
            for (DiscoveredEndpointDescription d : this.discoveredEndpointDescriptions) {
                Namespace dln = d.getDiscoveryLocatorNamespace();
                IServiceID svcId = d.getServiceID();
                if (!dln.getName().equals(locator.getServicesNamespace().getName()) || !svcId.equals((Object)serviceID)) continue;
                return d;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveredEndpointDescription createDiscoveredEndpointDescription(IDiscoveryLocator locator, IServiceInfo discoveredServiceInfo) {
        try {
            EndpointDescription endpointDescription = this.createEndpointDescription(locator, discoveredServiceInfo);
            List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
            synchronized (list) {
                DiscoveredEndpointDescription ded = this.findDiscoveredEndpointDescription(endpointDescription);
                if (ded != null) {
                    return ded;
                }
                ded = this.createDiscoveredEndpointDescription(locator, discoveredServiceInfo, endpointDescription);
                this.discoveredEndpointDescriptions.add(ded);
                return ded;
            }
        }
        catch (Exception e) {
            this.logError("createDiscoveredEndpointDescription", "Exception creating discovered endpoint description", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveredEndpointDescription removeDiscoveredEndpointDescription(IDiscoveryLocator locator, IServiceID serviceID) {
        List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
        synchronized (list) {
            DiscoveredEndpointDescription ded = this.findUniscoveredEndpointDescription(locator, serviceID);
            if (ded != null) {
                this.discoveredEndpointDescriptions.remove(ded);
                return ded;
            }
        }
        return null;
    }

    protected EndpointDescription createEndpointDescription(IDiscoveryLocator locator, IServiceInfo discoveredServiceInfo) {
        IServiceProperties discoveredServiceProperties = discoveredServiceInfo.getServiceProperties();
        return this.decodeEndpointDescription(discoveredServiceProperties);
    }

    protected DiscoveredEndpointDescription createDiscoveredEndpointDescription(IDiscoveryLocator locator, IServiceInfo discoveredServiceInfo, EndpointDescription endpointDescription) {
        return new DiscoveredEndpointDescription(locator.getServicesNamespace(), discoveredServiceInfo.getServiceID(), endpointDescription);
    }

    public void close() {
        this.removeAllDiscoveredEndpointDescriptions();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDiscoveredEndpointDescription(EndpointDescription endpointDescription) {
        List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
        synchronized (list) {
            block4: {
                DiscoveredEndpointDescription d = this.findDiscoveredEndpointDescription(endpointDescription);
                if (d == null) break block4;
                this.discoveredEndpointDescriptions.remove(d);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDiscoveredEndpointDescriptions() {
        List<DiscoveredEndpointDescription> list = this.discoveredEndpointDescriptions;
        synchronized (list) {
            this.discoveredEndpointDescriptions.clear();
        }
    }
}

