/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.identity;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceIDFactory;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;

public class ServiceIDFactory
implements IServiceIDFactory {
    private static final IServiceIDFactory instance = new ServiceIDFactory();

    public static IServiceIDFactory getDefault() {
        return instance;
    }

    public IServiceTypeID createServiceTypeID(Namespace namespace, String serviceType) {
        return this.createServiceTypeID(namespace, new String[]{serviceType});
    }

    public IServiceTypeID createServiceTypeID(Namespace namespace, String[] serviceType) {
        return this.createServiceTypeID(namespace, serviceType, IServiceTypeID.DEFAULT_SCOPE, IServiceTypeID.DEFAULT_PROTO, "iana");
    }

    public IServiceTypeID createServiceTypeID(Namespace namespace, String[] serviceType, String[] scopes, String[] protocols, String namingAuthority) {
        try {
            ServiceTypeID aServiceType = new ServiceTypeID(namespace, serviceType, scopes, protocols, namingAuthority);
            return (IServiceTypeID)IDFactory.getDefault().createID(namespace, new Object[]{aServiceType});
        }
        catch (AssertionFailedException e) {
            throw new IDCreateException("service type id creation failed", (Throwable)e);
        }
    }

    public IServiceTypeID createServiceTypeID(Namespace namespace, String[] serviceType, String[] protocols) {
        return this.createServiceTypeID(namespace, serviceType, IServiceTypeID.DEFAULT_SCOPE, protocols, "iana");
    }

    public IServiceTypeID createServiceTypeID(Namespace namespace, IServiceTypeID aServiceTypeId) {
        return (IServiceTypeID)IDFactory.getDefault().createID(namespace, new Object[]{aServiceTypeId});
    }
}

