/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRSAConsumerContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteServiceID;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteCallableFactory;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.util.EndpointDescriptionPropertiesUtil;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRSAClientContainer
extends AbstractClientContainer
implements IRSAConsumerContainerAdapter {
    public AbstractRSAClientContainer(ID containerID) {
        super(containerID);
    }

    @Override
    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return false;
    }

    public Namespace getConnectNamespace() {
        return this.getID().getNamespace();
    }

    private Long getServiceId(Map<String, Object> endpointDescriptionProperties) {
        return EndpointDescriptionPropertiesUtil.verifyLongProperty(endpointDescriptionProperties, "endpoint.service.id");
    }

    private String getRemoteServiceFilter(Map<String, Object> endpointDescriptionProperties, Long rsId) {
        String edRsFilter = EndpointDescriptionPropertiesUtil.verifyStringProperty(endpointDescriptionProperties, "ecf.endpoint.rsfilter");
        if (rsId == 0L) {
            return edRsFilter;
        }
        StringBuffer result = new StringBuffer("(&(").append("ecf.rsvc.id").append("=").append(rsId).append(")");
        if (edRsFilter != null) {
            result.append(edRsFilter);
        }
        result.append(")");
        return result.toString();
    }

    protected void connectToEndpoint(ID connectTargetID) throws ContainerConnectException {
        this.connect(connectTargetID, this.connectContext);
    }

    protected IRemoteCallable[][] createRegistrationCallables(ID targetID, String[] interfaces, Dictionary endpointDescriptionProperties) {
        return new IRemoteCallable[][]{{RemoteCallableFactory.createCallable(this.getID().getName())}};
    }

    protected Dictionary createRegistrationProperties(Map<String, Object> endpointDescriptionProperties) {
        return EndpointDescriptionPropertiesUtil.createDictionaryFromMap(endpointDescriptionProperties);
    }

    protected RemoteServiceClientRegistration createRSAClientRegistration(ID targetID, String[] interfaces, Map<String, Object> endpointDescriptionProperties) {
        Dictionary d = this.createRegistrationProperties(endpointDescriptionProperties);
        return new RSAClientRegistration(targetID, interfaces, this.createRegistrationCallables(targetID, interfaces, d), d);
    }

    public RemoteServiceClientRegistration registerEndpoint(ID targetID, String[] interfaces, Map<String, Object> endpointDescriptionProperties) {
        final RemoteServiceClientRegistration registration = this.createRSAClientRegistration(targetID, interfaces, endpointDescriptionProperties);
        this.registry.registerRegistration(registration);
        this.fireRemoteServiceEvent(new IRemoteServiceRegisteredEvent(){

            public IRemoteServiceReference getReference() {
                return registration.getReference();
            }

            public ID getLocalContainerID() {
                return registration.getContainerID();
            }

            public ID getContainerID() {
                return AbstractRSAClientContainer.this.getID();
            }

            public String[] getClazzes() {
                return registration.getClazzes();
            }
        });
        return registration;
    }

    @Override
    public IRemoteServiceReference[] importEndpoint(Map<String, Object> endpointDescriptionProperties) throws ContainerConnectException, InvalidSyntaxException {
        ID[] iDArray;
        ID[] idFilter;
        ID connectTargetID;
        Long timestamp;
        String ecfid = EndpointDescriptionPropertiesUtil.verifyStringProperty(endpointDescriptionProperties, "ecf.endpoint.id");
        if (ecfid == null) {
            ecfid = EndpointDescriptionPropertiesUtil.verifyStringProperty(endpointDescriptionProperties, "endpoint.id");
        }
        if ((timestamp = EndpointDescriptionPropertiesUtil.verifyLongProperty(endpointDescriptionProperties, "ecf.endpoint.ts")) == null) {
            timestamp = this.getServiceId(endpointDescriptionProperties);
        }
        String idNamespace = EndpointDescriptionPropertiesUtil.verifyStringProperty(endpointDescriptionProperties, "ecf.endpoint.id.ns");
        ID endpointContainerID = EndpointDescriptionPropertiesUtil.verifyIDProperty(idNamespace, ecfid);
        Long rsId = EndpointDescriptionPropertiesUtil.verifyLongProperty(endpointDescriptionProperties, "ecf.rsvc.id");
        if (rsId == null) {
            rsId = EndpointDescriptionPropertiesUtil.verifyLongProperty(endpointDescriptionProperties, "endpoint.service.id");
        }
        if ((connectTargetID = EndpointDescriptionPropertiesUtil.verifyIDProperty(idNamespace, EndpointDescriptionPropertiesUtil.verifyStringProperty(endpointDescriptionProperties, "ecf.endpoint.connecttarget.id"))) == null) {
            connectTargetID = endpointContainerID;
        }
        if ((idFilter = EndpointDescriptionPropertiesUtil.verifyIDArray(endpointDescriptionProperties, "ecf.endpoint.idfilter.ids", idNamespace)) == null) {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = endpointContainerID;
        } else {
            iDArray = idFilter;
        }
        idFilter = iDArray;
        String rsFilter = this.getRemoteServiceFilter(endpointDescriptionProperties, rsId);
        List<String> interfaces = EndpointDescriptionPropertiesUtil.verifyObjectClassProperty(endpointDescriptionProperties);
        this.registerEndpoint(connectTargetID, interfaces.toArray(new String[interfaces.size()]), endpointDescriptionProperties);
        if (connectTargetID != null) {
            this.connectToEndpoint(connectTargetID);
        }
        return this.getRemoteServiceReferences(idFilter, interfaces.iterator().next(), rsFilter);
    }

    @Override
    protected String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        return null;
    }

    public class RSAClientRegistration
    extends RemoteServiceClientRegistration {
        public RSAClientRegistration(ID targetID, String[] classNames, IRemoteCallable[][] restCalls, Dictionary properties) {
            super(AbstractRSAClientContainer.this.getConnectNamespace(), classNames, restCalls, properties, AbstractRSAClientContainer.this.registry);
            this.containerId = targetID;
            this.serviceID = new RemoteServiceID(AbstractRSAClientContainer.this.getConnectNamespace(), this.containerId, (Long)properties.get("ecf.rsvc.id"));
        }
    }
}

