/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackError;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Packet;

public final class SyncPacketSend {
    private SyncPacketSend() {
    }

    public static Packet getReply(Connection connection, Packet packet, long timeout) throws XMPPException {
        PacketIDFilter responseFilter = new PacketIDFilter(packet.getPacketID());
        PacketCollector response = connection.createPacketCollector(responseFilter);
        connection.sendPacket(packet);
        Packet result = response.nextResult(timeout);
        response.cancel();
        if (result == null) {
            throw new XMPPException(SmackError.NO_RESPONSE_FROM_SERVER);
        }
        if (result.getError() != null) {
            throw new XMPPException(result.getError());
        }
        return result;
    }

    public static Packet getReply(Connection connection, Packet packet) throws XMPPException {
        return SyncPacketSend.getReply(connection, packet, SmackConfiguration.getPacketReplyTimeout());
    }
}

