/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoResponse;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoSocketConnection;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketConnection;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketTransportService;

public class RhinoTransportService
extends SocketTransportService {
    public SocketConnection getConnection(Socket socket) throws IOException {
        return new RhinoSocketConnection(socket);
    }

    public void handleAccept(Connection connection) throws IOException {
        Packet packet = connection.readPacket();
        if (packet instanceof RhinoRequest) {
            RhinoRequest request = (RhinoRequest)packet;
            if (!request.getCommand().equals("connect")) {
                throw new IOException("failure establishing connection");
            }
            RhinoResponse response = new RhinoResponse(request.getSequence(), request.getCommand());
            connection.writePacket((Packet)response);
            return;
        }
        throw new IOException("failure establishing connection");
    }

    public void handleAttach(Connection connection) throws IOException {
        RhinoRequest request = new RhinoRequest("connect");
        connection.writePacket((Packet)request);
        Packet packet = connection.readPacket();
        if (packet instanceof RhinoResponse) {
            RhinoResponse response = (RhinoResponse)packet;
            if (!(response.getCommand().equals("connect") && response.getRequestSequence() == request.getSequence() && response.isSuccess() && response.isRunning())) {
                throw new IOException("failure establishing connection");
            }
            return;
        }
        throw new IOException("failure establishing connection");
    }
}

