/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.draw2d.CustomTooltipManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;

public class EventManager
extends EventDispatcher {
    private final FigureCanvas m_canvas;
    private final IFigure m_root;
    private MouseEvent m_currentEvent;
    private IFigure m_cursorFigure;
    private IFigure m_captureFigure;
    private IFigure m_targetFigure;
    private Cursor m_cursor;
    private static String FLAG_DELAY_EVENTS = "Flag that events to this Control should be delayed";
    private static String KEY_DELAYED_EVENTS = "List of delayed events";

    public EventManager(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_root = this.m_canvas.getLightweightSystem().getRootFigure();
        new CustomTooltipManager(canvas, this);
    }

    protected EventDispatcher.AccessibilityDispatcher getAccessibilityDispatcher() {
        return null;
    }

    public void setControl(Control control) {
    }

    public void setRoot(IFigure root) {
    }

    public void updateCursor() {
        if (this.m_cursorFigure == null) {
            this.setCursor(null);
        } else {
            this.setCursor(this.m_cursorFigure.getCursor());
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor == null ? cursor == null : this.m_cursor == cursor || this.m_cursor.equals((Object)cursor)) {
            return;
        }
        this.m_cursor = cursor;
        this.m_canvas.setCursor(this.m_cursor);
    }

    protected void updateFigureToolTipText() {
        IFigure iFigure;
        if (this.m_cursorFigure != null && (iFigure = this.m_cursorFigure.getToolTip()) instanceof Label) {
            Label label = (Label)iFigure;
            this.m_canvas.setToolTipText(label.getText());
        } else {
            this.m_canvas.setToolTipText(null);
        }
    }

    private void setFigureUnderCursor(IFigure figure, org.eclipse.swt.events.MouseEvent event) {
        if (this.m_cursorFigure != figure) {
            this.sendEvent(() -> this.m_targetFigure.handleMouseExited(this.m_currentEvent), event);
            this.m_cursorFigure = figure;
            this.sendEvent(() -> this.m_targetFigure.handleMouseEntered(this.m_currentEvent), event);
            this.updateCursor();
            this.updateFigureToolTipText();
        }
    }

    public final IFigure getCursorFigure() {
        return this.m_cursorFigure;
    }

    protected final void updateFigureUnderCursor(org.eclipse.swt.events.MouseEvent event) {
        this.setFigureUnderCursor(this.m_root.findFigureAt(event.x, event.y), event);
    }

    public void setCapture(IFigure captureFigure) {
        this.m_captureFigure = captureFigure;
    }

    public boolean isCaptured() {
        return this.m_captureFigure != null;
    }

    protected void releaseCapture() {
        this.m_captureFigure = null;
    }

    protected boolean isEventConsumed() {
        return this.m_currentEvent != null && this.m_currentEvent.isConsumed();
    }

    public void dispatchMouseDoubleClicked(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseDoubleClicked(this.m_currentEvent), event);
        }, event);
    }

    public void dispatchMousePressed(org.eclipse.swt.events.MouseEvent event) {
        if (this.m_canvas.getToolTipText() != null) {
            this.m_canvas.setToolTipText(null);
        }
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMousePressed(this.m_currentEvent), event);
        }, event);
    }

    public void dispatchMouseReleased(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseReleased(this.m_currentEvent), event);
        }, event);
    }

    public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseMoved(this.m_currentEvent), event);
        }, event);
    }

    private <T> void sendEvent(Runnable event, org.eclipse.swt.events.MouseEvent e) {
        this.m_currentEvent = null;
        IFigure iFigure = this.m_targetFigure = this.m_captureFigure == null ? this.m_cursorFigure : this.m_captureFigure;
        if (this.m_targetFigure != null) {
            this.m_currentEvent = new MouseEvent((EventDispatcher)this, this.m_targetFigure, e);
            event.run();
        }
    }

    public void dispatchFocusGained(FocusEvent e) {
    }

    public void dispatchFocusLost(FocusEvent e) {
    }

    public void dispatchKeyPressed(KeyEvent e) {
    }

    public void dispatchKeyReleased(KeyEvent e) {
    }

    public void dispatchKeyTraversed(TraverseEvent e) {
    }

    public void dispatchMouseEntered(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseEntered(this.m_currentEvent), event);
        }, event);
    }

    public void dispatchMouseExited(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseExited(this.m_currentEvent), event);
        }, event);
    }

    public void dispatchMouseHover(org.eclipse.swt.events.MouseEvent event) {
        this.delayEvent(() -> {
            this.updateFigureUnderCursor(event);
            this.sendEvent(() -> this.m_targetFigure.handleMouseHover(this.m_currentEvent), event);
        }, event);
    }

    public IFigure getFocusOwner() {
        return null;
    }

    public void requestFocus(IFigure fig) {
    }

    public void requestRemoveFocus(IFigure fig) {
    }

    public static void delayEvents(Control control, boolean delay) {
        if (delay) {
            control.setData(FLAG_DELAY_EVENTS, (Object)Boolean.TRUE);
        } else {
            control.setData(FLAG_DELAY_EVENTS, null);
        }
    }

    protected void delayEvent(Runnable event, org.eclipse.swt.events.MouseEvent e) {
        Widget widget = e.widget;
        if (widget.isDisposed() || widget.getData(FLAG_DELAY_EVENTS) == null) {
            event.run();
        } else {
            ArrayList<Runnable> eventQueue = (ArrayList<Runnable>)widget.getData(KEY_DELAYED_EVENTS);
            if (eventQueue == null) {
                eventQueue = new ArrayList<Runnable>();
                widget.setData(KEY_DELAYED_EVENTS, eventQueue);
            }
            eventQueue.add(event);
        }
    }

    public static void runDelayedEvents(Control control) {
        List eventQueue = (List)control.getData(KEY_DELAYED_EVENTS);
        control.setData(KEY_DELAYED_EVENTS, null);
        if (eventQueue != null) {
            for (Runnable event : eventQueue) {
                event.run();
            }
        }
    }
}

