/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterDirectionKind implements Enumerator
{
    IN_LITERAL(0, "in", "in"),
    INOUT_LITERAL(1, "inout", "inout"),
    OUT_LITERAL(2, "out", "out"),
    RETURN_LITERAL(3, "return", "return");

    public static final int IN = 0;
    public static final int INOUT = 1;
    public static final int OUT = 2;
    public static final int RETURN = 3;
    private static final ParameterDirectionKind[] VALUES_ARRAY;
    public static final List<ParameterDirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterDirectionKind[]{IN_LITERAL, INOUT_LITERAL, OUT_LITERAL, RETURN_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterDirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterDirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterDirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterDirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterDirectionKind get(int value) {
        switch (value) {
            case 0: {
                return IN_LITERAL;
            }
            case 1: {
                return INOUT_LITERAL;
            }
            case 2: {
                return OUT_LITERAL;
            }
            case 3: {
                return RETURN_LITERAL;
            }
        }
        return null;
    }

    private ParameterDirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

