/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.commands;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.commands.CloseUISessionCommand;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.PlatformUI;

public class CloseSessionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof IFile) {
            IFile selectedFile = (IFile)((StructuredSelection)selection).getFirstElement();
            URI fileURI = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
            ArrayList<Session> sessionToClose = new ArrayList<Session>();
            for (final Session session : SessionManager.INSTANCE.getSessions()) {
                if (!session.isOpen()) continue;
                sessionToClose.add(session);
            }
            for (final Session session : sessionToClose) {
                for (Resource res : session.getAllSessionResources()) {
                    if (!fileURI.equals(res.getURI())) continue;
                    CloseUISessionCommand operation = new CloseUISessionCommand(session);
                    try {
                        new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)operation);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.CloseSessionsAction_error, e), (Throwable)e));
                    }
                    if (!session.isOpen()) continue;
                    try {
                        new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                session.close((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", MessageFormat.format(Messages.CloseSessionsAction_error, e), (Throwable)e));
                    }
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        StructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            List<Session> relatedSessions = FileSessionFinder.getRelatedSessions(Lists.newArrayList((Object[])new IFile[]{(IFile)firstElement}), false, false);
            for (Session session : relatedSessions) {
                if (!session.isOpen()) continue;
                return true;
            }
        }
        return false;
    }
}

