/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.internal.ui.dialogs.Messages;
import org.eclipse.php.internal.ui.util.PatternMatcher;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextEditor;

public class PHPSourceActionDialog
extends CheckedTreeSelectionDialog {
    private static final String SETTINGS_SECTION_METHODS = "PHPSourceActionDialog.methods";
    private static final String SETTINGS_VISIBILITY_MODIFIER = "PHPSourceActionDialog.VisibilityModifier";
    private static final String SETTINGS_FINAL_MODIFIER = "PHPSourceActionDialog.FinalModifier";
    private static final String SETTINGS_COMMENTS = "PHPSourceActionDialog.Comments";
    private static final String SETTINGS_INSERT_POSITION = "PHPSourceActionDialog.InsertPosition";
    private static final String SETTINGS_USE_TYPE = "PHPSourceActionDialog.UseType";
    private static final String SETTINGS_SET_RETURN_SELF = "PHPSourceActionDialog.SetReturnSelf";
    private static final int INSERT_FIRST_INDEX = 0;
    private static final int INSERT_LAST_INDEX = 1;
    private static final int INSERT_POSITION_FROM_EDITOR = 2;
    private final List<IMethod> fInsertPositions;
    private final List<String> fLabels;
    private int fCurrentPositionIndex;
    ITreeContentProvider fContentProvider;
    private int fVisibilityModifier;
    private boolean fFinal;
    private IProject fProject;
    private boolean fGenerateComment;
    private boolean fUseType;
    private boolean fSetSelfType;
    private final int fWidth;
    private final int fHeight;
    private final String fCommentString;
    private boolean fEnableInsertPosition = true;
    protected IDialogSettings fSettings;
    protected boolean fHasUserChangedPositionIndex;
    private TextEditor fEditor;
    private CodeGenerationSettings fGenerationSettings;

    public PHPSourceActionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, IType type, TextEditor editor, CodeGenerationSettings settings) {
        super(parent, labelProvider, contentProvider);
        this.fEditor = editor;
        this.fContentProvider = contentProvider;
        this.fCommentString = Messages.GettersSettersAction_27;
        this.fGenerationSettings = settings;
        this.setEmptyListMessage(Messages.GettersSettersAction_28);
        this.fWidth = 60;
        this.fHeight = 18;
        IDialogSettings dialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        String sectionId = SETTINGS_SECTION_METHODS;
        this.fSettings = dialogSettings.getSection(sectionId);
        if (this.fSettings == null) {
            this.fSettings = dialogSettings.addNewSection(sectionId);
        }
        this.fInsertPositions = new ArrayList<IMethod>();
        this.fLabels = new ArrayList<String>();
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        if (methods == null) {
            return;
        }
        this.fInsertPositions.add(methods.length > 0 ? methods[0] : null);
        this.fInsertPositions.add(null);
        this.fLabels.add(Messages.GettersSettersAction_29);
        this.fLabels.add(Messages.GettersSettersAction_30);
        int i = 0;
        while (i < methods.length) {
            IMethod curr = methods[i];
            StringBuilder methodLabel = new StringBuilder();
            methodLabel.append(curr.getElementName());
            methodLabel.append("(");
            String[] param = null;
            try {
                param = curr.getParameterNames();
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            if (param != null) {
                int j = 0;
                while (j < param.length) {
                    methodLabel.append("$");
                    methodLabel.append(param[j]);
                    if (j < param.length - 1) {
                        methodLabel.append(", ");
                    }
                    ++j;
                }
            }
            methodLabel.append(')');
            this.fLabels.add(Messages.GettersSettersAction_31 + "'" + methodLabel.toString() + "'");
            if (i < methods.length - 1) {
                this.fInsertPositions.add(methods[i + 1]);
            }
            ++i;
        }
        this.fInsertPositions.add(null);
        try {
            this.restoreWidgetsValue(methods);
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected void restoreWidgetsValue(IMethod[] methods) throws ModelException {
        this.fVisibilityModifier = this.asInt(this.fSettings.get(SETTINGS_VISIBILITY_MODIFIER), 64);
        this.fFinal = this.asBoolean(this.fSettings.get(SETTINGS_FINAL_MODIFIER), false);
        this.fGenerationSettings.createComments = this.fGenerateComment = this.asBoolean(this.fSettings.get(SETTINGS_COMMENTS), true);
        this.fGenerationSettings.setSelfType = this.fSetSelfType = this.asBoolean(this.fSettings.get(SETTINGS_SET_RETURN_SELF), true);
        this.fGenerationSettings.useType = this.fUseType = this.asBoolean(this.fSettings.get(SETTINGS_USE_TYPE), true);
        int storedPositionIndex = this.asInt(this.fSettings.get(SETTINGS_INSERT_POSITION), 2);
        if (storedPositionIndex == 2) {
            int indexAfterCursor = this.getElementAfterCursorPosition(this.fEditor, (IModelElement[])methods);
            if (indexAfterCursor == -1 || indexAfterCursor == 0) {
                this.fCurrentPositionIndex = 0;
            } else if (indexAfterCursor > 0) {
                this.fCurrentPositionIndex = indexAfterCursor + 1;
            }
        } else {
            this.fCurrentPositionIndex = storedPositionIndex <= 0 ? 0 : 1;
        }
    }

    private int getElementAfterCursorPosition(TextEditor editor, IModelElement[] members) throws ModelException {
        Object firstElement;
        if (editor == null) {
            return -1;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        int offset = -1;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof ISourceReference) {
            offset = ((ISourceReference)firstElement).getSourceRange().getOffset() + 1;
        }
        if (offset == -1 && selection instanceof ITextSelection) {
            offset = ((ITextSelection)selection).getOffset();
        }
        int i = 0;
        while (i < members.length) {
            IMember curr = (IMember)members[i];
            ISourceRange range = curr.getSourceRange();
            if (offset < range.getOffset()) {
                return i;
            }
            ++i;
        }
        return members.length;
    }

    protected Composite addVisibilityAndModifiersChoices(Composite buttonComposite) {
        IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

            @Override
            public void visibilityChanged(int newVisibility) {
                PHPSourceActionDialog.this.setVisibility(newVisibility);
            }

            @Override
            public void modifierChanged(int modifier, boolean isChecked) {
                switch (modifier) {
                    case 4: {
                        PHPSourceActionDialog.this.setFinal(isChecked);
                        return;
                    }
                }
            }
        };
        int initialVisibility = this.getVisibilityModifier();
        int[] availableVisibilities = new int[]{64, 32, 16};
        return this.createVisibilityControlAndModifiers(buttonComposite, visibilityChangeListener, availableVisibilities, initialVisibility);
    }

    protected Composite createVisibilityControlAndModifiers(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
        Button finalCheckboxButton = new Button(visibilityComposite, 32);
        finalCheckboxButton.setText(Messages.GettersSettersAction_37);
        GridData gd = new GridData(256);
        finalCheckboxButton.setLayoutData((Object)gd);
        finalCheckboxButton.setData((Object)4);
        finalCheckboxButton.setEnabled(true);
        finalCheckboxButton.setSelection(this.isFinal());
        finalCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                visibilityChangeListener.modifierChanged((Integer)event.widget.getData(), ((Button)event.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        return visibilityComposite;
    }

    protected Composite createVisibilityControl(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        List<Integer> allowedVisibilities = this.convertToIntegerList(availableVisibilities);
        if (allowedVisibilities.size() == 1) {
            return null;
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.GettersSettersAction_33);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{Messages.GettersSettersAction_34, Messages.GettersSettersAction_35, Messages.GettersSettersAction_36};
        Integer[] data = new Integer[]{64, 32, 16};
        Integer initialVisibility = correctVisibility;
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)group, 16);
            Integer visibilityCode = data[i];
            radio.setLayoutData((Object)new GridData(256));
            radio.setText(labels[i]);
            radio.setData((Object)visibilityCode);
            radio.setSelection(visibilityCode.equals(initialVisibility));
            radio.setEnabled(allowedVisibilities.contains(visibilityCode));
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    visibilityChangeListener.visibilityChanged((Integer)event.widget.getData());
                }
            });
            ++i;
        }
        return group;
    }

    private List<Integer> convertToIntegerList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result.add(element);
            ++n2;
        }
        return result;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public int getVisibilityModifier() {
        return this.fVisibilityModifier;
    }

    protected void setVisibility(int visibility) {
        this.fVisibilityModifier = visibility;
    }

    private void setFinal(boolean value) {
        this.fFinal = value;
    }

    protected boolean asBoolean(String string, boolean defaultValue) {
        if (string != null) {
            return StringConverter.asBoolean((String)string, (boolean)defaultValue);
        }
        return defaultValue;
    }

    protected int asInt(String string, int defaultValue) {
        if (string != null) {
            return StringConverter.asInt((String)string, (int)defaultValue);
        }
        return defaultValue;
    }

    public void create() {
        super.create();
        CheckboxTreeViewer treeViewer = this.getTreeViewer();
        TreeItem[] items = treeViewer.getTree().getItems();
        if (items.length > 0) {
            Object revealedElement = items[0];
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getChecked()) {
                    revealedElement = item.getData();
                    break;
                }
                ++n2;
            }
            treeViewer.setSelection((ISelection)new StructuredSelection(revealedElement));
            treeViewer.reveal(revealedElement);
        }
    }

    public void setGenerateComment(boolean comment) {
        this.fGenerateComment = comment;
        this.fGenerationSettings.createComments = comment;
        this.getTreeViewer().refresh();
    }

    public boolean isGenerateComment() {
        return this.fGenerateComment;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    protected Control createLinkControl(Composite composite) {
        return null;
    }

    protected Label createMessageArea(Composite composite) {
        if (this.getMessage() != null) {
            Label label = new Label(composite, 0);
            label.setText(this.getMessage());
            label.setFont(composite.getFont());
            return label;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label messageLabel = this.createMessageArea(composite);
        if (messageLabel != null) {
            gd = new GridData(256);
            gd.horizontalSpan = 2;
            messageLabel.setLayoutData((Object)gd);
        }
        Composite inner = new Composite(composite, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        inner.setLayout((Layout)innerLayout);
        inner.setFont(parent.getFont());
        Text filterText = this.createFilterComposite(inner);
        if (filterText != null) {
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.horizontalSpan = 2;
            filterText.setLayoutData((Object)gd);
        }
        CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        treeViewer.getControl().setLayoutData((Object)gd);
        Composite buttonComposite = this.createSelectionButtons(inner);
        gd = new GridData(272);
        buttonComposite.setLayoutData((Object)gd);
        gd = new GridData(1808);
        inner.setLayoutData((Object)gd);
        Composite insertPositionComposite = this.createInsertPositionCombo(composite);
        insertPositionComposite.setLayoutData((Object)new GridData(768));
        Composite commentComposite = this.createCommentSelection(composite);
        commentComposite.setLayoutData((Object)new GridData(768));
        Control linkControl = this.createLinkControl(composite);
        if (linkControl != null) {
            linkControl.setLayoutData((Object)new GridData(768));
        }
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        if (filterText != null) {
            this.addSearchFilter(filterText, treeViewer);
            filterText.forceFocus();
        }
        PHPSourceActionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void addSearchFilter(final Text filterText, final CheckboxTreeViewer treeViewer) {
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String searchText = filterText.getText();
                final PatternMatcher matcher = new PatternMatcher(searchText);
                ViewerFilter vf = null;
                if (!searchText.trim().isEmpty()) {
                    vf = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            IBaseLabelProvider lblProvider = PHPSourceActionDialog.this.getTreeViewer().getLabelProvider();
                            if (element instanceof ITypeBinding) {
                                return true;
                            }
                            String filterableName = null;
                            if (lblProvider instanceof LabelProvider) {
                                filterableName = ((LabelProvider)lblProvider).getText(element);
                                if (matcher.matches(filterableName)) {
                                    return true;
                                }
                                return this.hasUnfilteredChild((TreeViewer)treeViewer, element);
                            }
                            return false;
                        }

                        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
                            Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                            int i = 0;
                            while (i < children.length) {
                                if (this.select((Viewer)viewer, element, children[i])) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }
                    };
                    treeViewer.setFilters(new ViewerFilter[]{vf});
                    treeViewer.expandAll();
                } else {
                    treeViewer.resetFilters();
                }
            }
        });
    }

    protected Text createFilterComposite(Composite inner) {
        Label filterTextLabel = new Label(inner, 0);
        filterTextLabel.setText(Messages.OverrideMethodDialog_filter_description);
        Text filterText = new Text(inner, 2176);
        filterText.setMessage(Messages.OverrideMethodDialog_searchtext_message);
        return filterText;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        return buttonComposite;
    }

    protected Composite createInsertPositionCombo(Composite composite) {
        Composite selectionComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectionComposite.setLayout((Layout)layout);
        this.addOrderEntryChoices(selectionComposite);
        return selectionComposite;
    }

    private Composite addOrderEntryChoices(Composite buttonComposite) {
        Label enterLabel = new Label(buttonComposite, 0);
        enterLabel.setText(Messages.GettersSettersAction_32);
        if (!this.fEnableInsertPosition) {
            enterLabel.setEnabled(false);
        }
        GridData gd = new GridData(256);
        enterLabel.setLayoutData((Object)gd);
        final Combo enterCombo = new Combo(buttonComposite, 8);
        if (!this.fEnableInsertPosition) {
            enterCombo.setEnabled(false);
        }
        this.fillWithPossibleInsertPositions(enterCombo);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        enterCombo.setLayoutData((Object)gd);
        enterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = enterCombo.getSelectionIndex();
                PHPSourceActionDialog.this.setInsertPosition(index);
                PHPSourceActionDialog.this.fHasUserChangedPositionIndex = true;
            }
        });
        return buttonComposite;
    }

    private void fillWithPossibleInsertPositions(Combo combo) {
        combo.setItems(this.fLabels.toArray(new String[this.fLabels.size()]));
        combo.select(this.fCurrentPositionIndex);
    }

    protected void openCodeTempatePage(String id) {
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("CodeTemplatePreferencePage.select_template", id);
        PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.getProject(), (String)"org.eclipse.php.ui.propertyPages.PHPCodeTemplatePreferencePage", null, arg).open();
    }

    private void setInsertPosition(int insert) {
        this.fCurrentPositionIndex = insert;
    }

    public IMethod getElementPosition() {
        return this.fInsertPositions.get(this.fCurrentPositionIndex);
    }

    public int getInsertOffset() throws ModelException {
        IMethod elementPosition = this.getElementPosition();
        if (elementPosition instanceof ISourceReference) {
            return ((ISourceReference)elementPosition).getSourceRange().getOffset();
        }
        return -1;
    }

    protected Composite createCommentSelection(Composite composite) {
        Composite commentComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        commentComposite.setLayout((Layout)layout);
        commentComposite.setFont(composite.getFont());
        Button commentButton = new Button(commentComposite, 32);
        commentButton.setText(this.fCommentString);
        commentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                PHPSourceActionDialog.this.setGenerateComment(isSelected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        commentButton.setSelection(this.isGenerateComment());
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        commentButton.setLayoutData((Object)gd);
        return commentComposite;
    }

    public boolean close() {
        this.fSettings.put(SETTINGS_VISIBILITY_MODIFIER, StringConverter.asString((int)this.fVisibilityModifier));
        this.fSettings.put(SETTINGS_FINAL_MODIFIER, StringConverter.asString((boolean)this.fFinal));
        this.fSettings.put(SETTINGS_COMMENTS, this.fGenerateComment);
        this.fSettings.put(SETTINGS_USE_TYPE, this.fUseType);
        this.fSettings.put(SETTINGS_SET_RETURN_SELF, this.fSetSelfType);
        if (this.fHasUserChangedPositionIndex) {
            if (this.fCurrentPositionIndex == 0 || this.fCurrentPositionIndex == 1) {
                this.fSettings.put(SETTINGS_INSERT_POSITION, StringConverter.asString((int)this.fCurrentPositionIndex));
            } else if (this.fEditor != null) {
                this.fSettings.put(SETTINGS_INSERT_POSITION, StringConverter.asString((int)2));
            }
        }
        return super.close();
    }

    public boolean isUseType() {
        return this.fUseType;
    }

    public void setUseType(boolean fUseType) {
        this.fUseType = fUseType;
        this.fGenerationSettings.useType = fUseType;
        this.getTreeViewer().refresh();
    }

    public boolean isSetSelfType() {
        return this.fSetSelfType;
    }

    public void setSetSelfType(boolean fSetSelfType) {
        this.fSetSelfType = fSetSelfType;
        this.fGenerationSettings.setSelfType = fSetSelfType;
        this.getTreeViewer().refresh();
    }

    public CodeGenerationSettings getGenerationSettings() {
        return this.fGenerationSettings;
    }

    public static interface IVisibilityChangeListener {
        public void visibilityChanged(int var1);

        public void modifierChanged(int var1, boolean var2);
    }
}

