/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.version;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.version.SemanticVersion;
import org.eclipse.passage.lic.base.version.BaseSemanticVersion;
import org.eclipse.passage.lic.base.version.BaseVersion;

public final class SafeVersion
extends BaseVersion {
    private final Object source;
    private static String seprators = "\\.";

    public SafeVersion(Object source) {
        Objects.requireNonNull(source, "SafeVersion::source");
        this.source = source;
    }

    public String value() {
        return this.semantic().toString();
    }

    public SemanticVersion semantic() {
        String version = this.source.toString().trim();
        List<String> segments = Arrays.stream(version.split(seprators)).map(String::trim).collect(Collectors.toList());
        Optional<String> qualifier = segments.size() > 3 ? Optional.of((String)segments.get(3)) : Optional.empty();
        return this.build(this.extractSegment(segments, 0), this.extractSegment(segments, 1), this.extractSegment(segments, 2), qualifier);
    }

    private int extractSegment(List<String> split, int index) {
        if (split.size() > index) {
            try {
                return Integer.parseInt(split.get(index));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private SemanticVersion build(int major, int minor, int service, Optional<String> qualifier) {
        return new BaseSemanticVersion(major, minor, service, qualifier.isPresent() && major + minor + service > 0 ? qualifier : Optional.empty());
    }
}

