/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.util.Objects;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImageButton
extends Label
implements MouseTrackListener,
MouseMoveListener,
MouseListener {
    private static final SelectionMode DEFAULT_SELECTION_MODE = SelectionMode.MouseUp;
    private DisposeListener disposeListener;
    private Image hoverImage;
    private Image grayImage;
    private SelectionMode selectionMode = DEFAULT_SELECTION_MODE;
    private Runnable selectionRunnable;
    private boolean inImage;

    public ImageButton(Composite parent, Image hoverImage) {
        this(parent, hoverImage, null);
    }

    public ImageButton(Composite parent, Image hoverImage, Image grayImage) {
        super(parent, 0);
        if (grayImage == null) {
            grayImage = this.generateGrayImage(hoverImage);
            this.disposeListener = e -> this.grayImage.dispose();
            this.addDisposeListener(this.disposeListener);
        }
        this.hoverImage = Objects.requireNonNull(hoverImage);
        this.grayImage = grayImage;
        this.setImage(grayImage);
        this.addMouseTrackListener(this);
        this.addMouseMoveListener(this);
        this.addMouseListener(this);
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.hoverImage = Objects.requireNonNull(hoverImage);
        if (this.disposeListener != null) {
            this.grayImage.dispose();
            this.grayImage = this.generateGrayImage(hoverImage);
        }
        this.setImage(this.inImage ? hoverImage : this.grayImage);
    }

    public Image getGrayImage() {
        return this.grayImage;
    }

    public void setGrayImage(Image grayImage) {
        if (this.disposeListener != null) {
            grayImage.dispose();
            this.disposeListener = null;
        }
        this.grayImage = Objects.requireNonNull(grayImage);
        this.setImage(this.inImage ? this.hoverImage : grayImage);
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = Objects.requireNonNullElse(selectionMode, DEFAULT_SELECTION_MODE);
    }

    public Runnable getSelectionRunnable() {
        return this.selectionRunnable;
    }

    public void setSelectionRunnable(Runnable selectionRunnable) {
        this.selectionRunnable = selectionRunnable;
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseMove(e);
    }

    public void mouseExit(MouseEvent e) {
        this.mouseMove(e);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        Rectangle bounds = this.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        this.inImage = bounds.contains(e.x, e.y);
        if (this.inImage) {
            this.setImage(this.hoverImage);
        } else {
            this.setImage(this.grayImage);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.inImage && this.selectionMode == SelectionMode.MouseUp) {
            this.widgetSelected();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.inImage && this.selectionMode == SelectionMode.MouseDown) {
            this.widgetSelected();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.inImage && this.selectionMode == SelectionMode.DoubleClick) {
            this.widgetSelected();
        }
    }

    protected void checkSubclass() {
    }

    protected void widgetSelected() {
        if (this.selectionRunnable != null) {
            this.selectionRunnable.run();
        }
    }

    private Image generateGrayImage(Image hoverImage) {
        return new Image((Device)this.getDisplay(), hoverImage, 2);
    }

    public static enum SelectionMode {
        MouseUp,
        MouseDown,
        DoubleClick;

    }
}

