/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.effects.AbstractEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class CrossFadeEffect
extends AbstractEffect {
    Image buffer = null;
    double easingValue;
    GC gc = null;
    Image image1 = null;
    Image image2 = null;
    IImageObject obj = null;

    public CrossFadeEffect(IImageObject obj, Image image1, Image image2, long lengthMilli, IMovement movement) {
        this(obj, image1, image2, lengthMilli, movement, null, null);
    }

    public CrossFadeEffect(IImageObject obj, Image image1, Image image2, long lengthMilli, IMovement movement, Runnable onStop) {
        this(obj, image1, image2, lengthMilli, movement, onStop, null);
    }

    public CrossFadeEffect(IImageObject obj, Image image1, Image image2, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.obj = obj;
        this.image1 = image1;
        this.image2 = image2;
        if (!image1.getBounds().equals((Object)image2.getBounds())) {
            throw new IllegalArgumentException("Both image must have the same dimensions");
        }
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
        this.buffer = new Image(image1.getDevice(), image1.getBounds().width, image1.getBounds().height);
        this.gc = new GC((Drawable)this.buffer);
    }

    @Override
    public void applyEffect(long currentTime) {
        this.easingValue = this.easingFunction.getValue(currentTime);
        if (this.easingValue == 0.0) {
            this.obj.setImage(this.image1);
        } else if (this.easingValue == 1.0) {
            this.obj.setImage(this.image2);
        } else {
            this.gc.setAlpha(255);
            this.gc.drawImage(this.image1, 0, 0);
            this.gc.setAlpha((int)(255.0 * this.easingValue));
            this.gc.drawImage(this.image2, 0, 0);
            this.obj.setImage(this.buffer);
        }
    }

    protected void cleanup() {
        this.gc.dispose();
        this.buffer.dispose();
    }

    @Override
    protected void doCancel() {
        this.obj.setImage(this.image2);
        super.doCancel();
        this.cleanup();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.cleanup();
    }

    public static interface IImageObject {
        public Image getImage();

        public void setImage(Image var1);
    }
}

