/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.webapp.discoverer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.actions.AbstractDeploymentDescriptorDiscoverer;
import org.eclipse.modisco.jee.webapp.discoverer.WebXmlActivator;
import org.eclipse.modisco.jee.webapp.webapp22.util.Webapp22ResourceFactoryImpl;
import org.eclipse.modisco.jee.webapp.webapp23.util.Webapp23ResourceFactoryImpl;
import org.eclipse.modisco.jee.webapp.webapp24.util.Webapp24ResourceFactoryImpl;
import org.eclipse.modisco.jee.webapp.webapp25.util.Webapp25ResourceFactoryImpl;
import org.eclipse.modisco.jee.webapp.webapp30.util.Webapp30ResourceFactoryImpl;

public class WebXmlDiscoverer2
extends AbstractDeploymentDescriptorDiscoverer<IFile> {
    private static Resource.Factory modiscoResourceFactory;
    public static final String ID = "org.eclipse.modisco.jee.webapp.discoverer";
    public static final String ROOT_NAME = "web-app";
    public static final String DTD_URL = "http://java.sun.com/";

    public boolean isApplicableTo(IFile source) {
        return WebXmlDiscoverer2.isAnIFileWithExtension((Object)source, (String)"xml");
    }

    public void discoverElement(File file, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createFileURI((String)file.getPath().concat("_webapp.xmi")));
        URI sourceURI = URI.createFileURI((String)file.getPath().toString());
        WebXmlDiscoverer2.initializeResourceFactory(sourceURI);
        this.discoverResourceInternal(sourceURI);
        monitor.setTaskName(Messages.AbstractModelDiscoverer_savingModel);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                throw new DiscoveryException("Error saving discovery result model", (Throwable)e);
            }
        }
    }

    public void discoverResource(URI sourceURI) throws DiscoveryException {
        WebXmlDiscoverer2.initializeResourceFactory(sourceURI);
        this.discoverResourceInternal(sourceURI);
    }

    protected void basicDiscoverElement(IFile source, IProgressMonitor monitor) throws DiscoveryException {
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)source.getFullPath().toString().concat("_webapp.xmi"), (boolean)true));
        URI sourceURI = URI.createPlatformResourceURI((String)source.getFullPath().toString(), (boolean)true);
        WebXmlDiscoverer2.initializeResourceFactory(sourceURI);
        this.discoverResourceInternal(sourceURI);
    }

    private static void initializeResourceFactory(URI sourceURI) throws DiscoveryException {
        String version = WebXmlDiscoverer2.getDescXmlVersion((Plugin)WebXmlActivator.getDefault(), (Object)sourceURI, (String)ROOT_NAME, (String)DTD_URL);
        if (version.equalsIgnoreCase("2.2")) {
            modiscoResourceFactory = new Webapp22ResourceFactoryImpl();
        } else if (version.equalsIgnoreCase("2.3")) {
            modiscoResourceFactory = new Webapp23ResourceFactoryImpl();
        } else if (version.equalsIgnoreCase("2.4")) {
            modiscoResourceFactory = new Webapp24ResourceFactoryImpl();
        } else if (version.equalsIgnoreCase("2.5")) {
            modiscoResourceFactory = new Webapp25ResourceFactoryImpl();
        } else if (version.equalsIgnoreCase("3.0")) {
            modiscoResourceFactory = new Webapp30ResourceFactoryImpl();
        } else {
            throw new DiscoveryException("No known version of web.xml detected; aborting the process");
        }
    }

    private void discoverResourceInternal(URI sourceURI) throws DiscoveryException {
        try {
            Resource resource = WebXmlDiscoverer2.getModiscoResourceFactory().createResource(sourceURI);
            this.getResourceSet().getResources().add((Object)resource);
            resource.load(null);
            this.setTargetModel(resource);
            Map unknowFeature = ((XMLResource)resource).getEObjectToExtensionMap();
            for (AnyType anyType : unknowFeature.values()) {
                Logger.logWarning((String)("Unknown feature detected:" + anyType.toString()), (Plugin)WebXmlActivator.getDefault());
            }
        }
        catch (IOException e) {
            throw new DiscoveryException("An error occurred during model discovery from: " + sourceURI.toString(), (Throwable)e);
        }
    }

    protected static Resource.Factory getModiscoResourceFactory() {
        return modiscoResourceFactory;
    }

    protected static void setModiscoResourceFactory(Resource.Factory modiscoResourceFactory) {
        WebXmlDiscoverer2.modiscoResourceFactory = modiscoResourceFactory;
    }

    protected void saveTargetModel() throws IOException {
        Resource xmlResource = this.getTargetModel();
        Resource xmiResource = this.createTargetModel();
        xmiResource.getContents().addAll((Collection)xmlResource.getContents());
        xmlResource.getResourceSet().getResources().remove((Object)xmlResource);
        super.saveTargetModel();
    }
}

