/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.io.library.LibraryReader;
import org.eclipse.modisco.java.emf.JavaFactory;

public class DiscoverJavaModelFromLibrary
extends AbstractModelDiscoverer<IPackageFragmentRoot> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.library";

    public boolean isApplicableTo(IPackageFragmentRoot packageFragmentRoot) {
        try {
            return packageFragmentRoot.getKind() == 2;
        }
        catch (JavaModelException e) {
            Logger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return false;
        }
    }

    protected static JavaFactory getEFactory() {
        return JavaFactory.eINSTANCE;
    }

    protected static LibraryReader getLibraryReader() {
        return new LibraryReader(DiscoverJavaModelFromLibrary.getEFactory());
    }

    protected void basicDiscoverElement(IPackageFragmentRoot packageFragmentRoot, IProgressMonitor monitor) throws DiscoveryException {
        IJavaProject javaProject = packageFragmentRoot.getJavaProject();
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)project.getFullPath().append(packageFragmentRoot.getElementName()).toString().concat("_java.xmi"), (boolean)true));
        Model model = DiscoverJavaModelFromLibrary.getEFactory().createModel();
        this.createTargetModel().getContents().add((Object)model);
        LibraryReader reader = DiscoverJavaModelFromLibrary.getLibraryReader();
        reader.readModel(packageFragmentRoot, model, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        reader.terminate(monitor);
    }
}

