/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.modisco.facet.widgets.celleditors.ICompositeEditorFactory;
import org.eclipse.modisco.facet.widgets.celleditors.IListener;
import org.eclipse.modisco.facet.widgets.celleditors.core.composite.registry.ICompositeEditorFactoriesRegistry;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.DiscovererUpdate;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplay;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplayImpl;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.DiscovererParametersComposite;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.IEditingSupportListener;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.ParametersTableComposite;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.utils.LaunchConfigUtils;
import org.eclipse.modisco.infra.discovery.ui.internal.util.LaunchModelUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DiscoverersMainTab
extends AbstractLaunchConfigurationTab
implements DiscovererUpdate {
    private Group sourceGroup = null;
    private Group discovererKindGroup = null;
    private Combo discovererKindCombo = null;
    private Label discoverKindLabel = null;
    private Composite rootContainer = null;
    private DiscovererParametersComposite parametersContainer = null;
    private Button checkboxOpenModel = null;
    private final List<DiscovererParameterDisplay> displayParameters = new ArrayList<DiscovererParameterDisplay>();
    private boolean inCellEditorOpened;
    private boolean inoutCellEditorOpened;
    private AbstractCellEditorComposite<Object> sourceCellEditorComposite;

    private final void createDiscovererParametersContainer() {
        this.parametersContainer = new DiscovererParametersComposite(this.rootContainer, 0);
        ParametersTableComposite inParametersGroup = this.parametersContainer.getInParametersGroup();
        inParametersGroup.getEditingSupport().addListener(new IEditingSupportListener(){

            @Override
            public void cellEditorOpened() {
                if (!DiscoverersMainTab.this.inCellEditorOpened) {
                    DiscoverersMainTab.this.inCellEditorOpened = true;
                    DiscoverersMainTab.this.update();
                }
            }

            @Override
            public void cellEditorClosed() {
                if (DiscoverersMainTab.this.inCellEditorOpened) {
                    DiscoverersMainTab.this.inCellEditorOpened = false;
                    DiscoverersMainTab.this.update();
                }
            }
        });
        this.parametersContainer.getInoutParametersGroup().getEditingSupport().addListener(new IEditingSupportListener(){

            @Override
            public void cellEditorOpened() {
                if (!DiscoverersMainTab.this.inoutCellEditorOpened) {
                    DiscoverersMainTab.this.inoutCellEditorOpened = true;
                    DiscoverersMainTab.this.update();
                }
            }

            @Override
            public void cellEditorClosed() {
                if (DiscoverersMainTab.this.inoutCellEditorOpened) {
                    DiscoverersMainTab.this.inoutCellEditorOpened = false;
                    DiscoverersMainTab.this.update();
                }
            }
        });
    }

    private void createOpenModelCheckbox() {
        this.checkboxOpenModel = new Button(this.rootContainer, 32);
        this.checkboxOpenModel.setText(Messages.DiscoverersMainTab_openModelInEditorAfterDiscovery);
        this.checkboxOpenModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoverersMainTab.this.update();
            }
        });
    }

    private final void createSourceGroup(DiscovererDescription discoverer) {
        if (this.sourceGroup == null) {
            this.sourceGroup = new Group(this.rootContainer, 0);
            this.sourceGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.sourceGroup.setText(Messages.DiscoverersMainTab_sourceElement);
            this.sourceGroup.setLayout((Layout)new GridLayout());
        }
        Control[] controlArray = this.sourceGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (discoverer == null) {
            Text placeholder = new Text((Composite)this.sourceGroup, 2048);
            placeholder.setEnabled(false);
            placeholder.setLayoutData((Object)new GridData(4, 4, true, false));
        } else {
            Class sourceType = discoverer.getSourceType();
            ICompositeEditorFactory compositeEditorFactory = ICompositeEditorFactoriesRegistry.INSTANCE.getCompositeEditorFactory(sourceType);
            if (compositeEditorFactory != null) {
                this.sourceCellEditorComposite = compositeEditorFactory.createCompositeEditor((Composite)this.sourceGroup, 2048);
                this.sourceCellEditorComposite.setLayoutData((Object)new GridData(4, 4, true, false));
                this.sourceCellEditorComposite.addChangeListener(new IListener(){

                    public void handleEvent() {
                        DiscoverersMainTab.this.sourceChanged();
                    }
                });
            } else {
                Text placeholder = new Text((Composite)this.sourceGroup, 2048);
                placeholder.setLayoutData((Object)new GridData(4, 4, true, false));
                placeholder.setEnabled(false);
                placeholder.setText(NLS.bind((String)Messages.DiscoverersMainTab_noCellEditorRegisteredForType, (Object)sourceType.getName()));
                placeholder.setForeground(Display.getDefault().getSystemColor(4));
            }
        }
        this.sourceGroup.layout();
    }

    protected void sourceChanged() {
        this.parametersContainer.getInParametersGroup().getTableViewer().cancelEditing();
        this.parametersContainer.getInoutParametersGroup().getTableViewer().cancelEditing();
        for (DiscovererParameterDisplay parameter : this.displayParameters) {
            parameter.initialize(this.sourceCellEditorComposite.getValue());
        }
        this.update();
    }

    private final void createDiscovererKindGroup() {
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.grabExcessHorizontalSpace = true;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        this.discovererKindGroup = new Group(this.rootContainer, 0);
        this.discovererKindGroup.setLayout((Layout)new GridLayout());
        this.discovererKindGroup.setLayoutData((Object)gridData11);
        this.discovererKindGroup.setText(Messages.DiscoverersMainTab_discovererKind);
        this.discoverKindLabel = new Label((Composite)this.discovererKindGroup, 0);
        this.discoverKindLabel.setText(Messages.DiscoverersMainTab_selectDiscoverer);
        this.discovererKindCombo = new Combo((Composite)this.discovererKindGroup, 8);
        this.discovererKindCombo.setLayoutData((Object)gridData1);
        this.discovererKindCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoverersMainTab.this.updateDiscovererParametersContainer(null);
                DiscoverersMainTab.this.update();
                DiscoverersMainTab.this.discovererChanged();
            }
        });
    }

    protected void discovererChanged() {
        String text = this.discovererKindCombo.getText();
        IDiscoverer discoverer = IDiscoveryManager.INSTANCE.createDiscovererImpl(text);
        DiscovererDescription discovererDescription = IDiscoveryManager.INSTANCE.getDiscovererDescription(text);
        if (discoverer != null) {
            this.checkboxOpenModel.setEnabled(discoverer instanceof AbstractModelDiscoverer);
        }
        this.createSourceGroup(discovererDescription);
    }

    protected final void updateDiscovererParametersContainer(LaunchConfiguration configurationModel) {
        String kind = this.discovererKindCombo.getText();
        DiscovererDescription discoverer = IDiscoveryManager.INSTANCE.getDiscovererDescription(kind);
        this.displayParameters.clear();
        if (discoverer != null) {
            for (DiscovererParameter parameter : discoverer.getParameterDefinitions()) {
                DiscovererParameterDisplayImpl displayParameter = new DiscovererParameterDisplayImpl(parameter, discoverer, this);
                if (configurationModel != null) {
                    Object value = LaunchModelUtils.getDiscoveryParameterValue(configurationModel, parameter);
                    displayParameter.setValue(value);
                } else {
                    displayParameter.initialize(null);
                }
                this.displayParameters.add(displayParameter);
            }
            this.parametersContainer.updateDiscoveryParameters(this.displayParameters);
        } else {
            this.setErrorMessage(Messages.DiscoverersMainTab_discovererNotFound);
        }
    }

    public void createControl(Composite parent) {
        this.rootContainer = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.rootContainer.setLayout((Layout)gridLayout);
        this.rootContainer.setLayoutData((Object)gridData);
        this.createDiscovererKindGroup();
        this.createSourceGroup(null);
        this.createDiscovererParametersContainer();
        this.createOpenModelCheckbox();
        this.initializeDiscoverersKindList();
        this.setControl((Control)this.rootContainer);
    }

    private final void initializeDiscoverersKindList() {
        for (DiscovererDescription desc : IDiscoveryManager.INSTANCE.getDiscoverers()) {
            this.discovererKindCombo.add(desc.getId());
        }
    }

    public String getName() {
        return Messages.DiscoverersMainTab_discoverer;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        LaunchConfiguration configurationModel = LaunchConfigUtils.getConfigurationModel(configuration);
        DiscovererDescription discovererDescription = configurationModel.getDiscoverer();
        if (discovererDescription != null) {
            this.discovererKindCombo.setText(discovererDescription.getId());
            this.discovererChanged();
        }
        this.displayParameters.clear();
        Object source = configurationModel.getSource();
        if (this.sourceCellEditorComposite != null && !this.sourceCellEditorComposite.isDisposed()) {
            this.sourceCellEditorComposite.setValue(source);
        }
        this.updateDiscovererParametersContainer(configurationModel);
        this.checkboxOpenModel.setSelection(configurationModel.isOpenModelAfterDiscovery());
        this.update();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String kind = this.discovererKindCombo.getText();
        DiscovererDescription discoverer = IDiscoveryManager.INSTANCE.getDiscovererDescription(kind);
        LaunchConfiguration configurationModel = LaunchConfigUtils.getConfigurationModel((ILaunchConfiguration)configuration);
        configurationModel.setDiscoverer(discoverer);
        configurationModel.getParameterValues().clear();
        if (kind.length() > 0) {
            for (DiscovererParameterDisplay parameter : this.displayParameters) {
                LaunchModelUtils.setDiscoveryParameterValue(configurationModel, parameter.getParameterDescription(), parameter.getValue());
            }
        }
        if (this.sourceCellEditorComposite != null && !this.sourceCellEditorComposite.isDisposed()) {
            Object value = this.sourceCellEditorComposite.getValue();
            configurationModel.setSource(value);
        }
        configurationModel.setOpenModelAfterDiscovery(this.checkboxOpenModel.getSelection());
        LaunchConfigUtils.saveConfigurationModel(configurationModel, configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block4: {
            this.setErrorMessage(null);
            this.setMessage(null);
            if (this.discovererKindCombo.getText() != null && this.discovererKindCombo.getText().length() != 0) break block4;
            this.setMessage(Messages.DiscoverersMainTab_pleaseSelectDiscoverer);
            return false;
        }
        try {
            LaunchConfiguration configurationModel = LaunchConfigUtils.getConfigurationModel(launchConfig);
            String error = LaunchModelUtils.validate(configurationModel);
            if (error != null) {
                this.setErrorMessage(error);
                return false;
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return !this.inCellEditorOpened && !this.inoutCellEditorOpened;
    }

    @Override
    public void update() {
        try {
            if (this.getLaunchConfigurationDialog().getTabs() != null) {
                this.updateLaunchConfigurationDialog();
            }
        }
        catch (SWTException e) {
            Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
    }
}

