/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.actions.MoDiscoMenuSelectionListener;
import org.eclipse.modisco.infra.discovery.ui.internal.registry.DiscovererUI;
import org.eclipse.modisco.infra.discovery.ui.internal.registry.DiscovererUIRegistry;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class ContributionItemForMoDiscoMenu
extends ContributionItem
implements IWorkbenchContribution {
    private Shell shell;
    private ISelectionService selectionService;
    private static final Comparator<DiscovererDescription> DISCOVERERS_COMPARATOR = new Comparator<DiscovererDescription>(){

        @Override
        public int compare(DiscovererDescription o1, DiscovererDescription o2) {
            DiscovererUI ui2;
            DiscovererUI ui1;
            String str1 = null;
            String str2 = null;
            if (o1 != null && o1.getId() != null && (ui1 = DiscovererUIRegistry.getInstance().getDiscovererUI(o1.getId())) != null) {
                str1 = ui1.getLabel();
            }
            if (str1 == null) {
                return 1;
            }
            if (o2 != null && o2.getId() != null && (ui2 = DiscovererUIRegistry.getInstance().getDiscovererUI(o2.getId())) != null) {
                str2 = ui2.getLabel();
            }
            if (str2 == null) {
                return -1;
            }
            return str2.compareToIgnoreCase(str1);
        }
    };

    public void initialize(IServiceLocator serviceLocator) {
        this.selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
    }

    public void fill(Menu menu, int index) {
        super.fill(menu, index);
        this.shell = menu.getShell();
        ISelection selection = this.selectionService.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            final IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            MenuItem modiscoItem = new MenuItem(menu, 64, index);
            modiscoItem.setText(Messages.ContributionItemForMoDiscoMenu_discoverersMenuLabel);
            final Menu modiscoMenu = new Menu(modiscoItem);
            modiscoItem.setMenu(modiscoMenu);
            modiscoMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent event) {
                    MenuItem[] menuItemArray = modiscoMenu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        menuItem.dispose();
                        ++n2;
                    }
                    ArrayList<DiscovererDescription> discoverers = new ArrayList<DiscovererDescription>();
                    try {
                        Object[] selectedObjects = structuredSelection.toArray();
                        for (DiscovererDescription discoverer : IDiscoveryManager.INSTANCE.getDiscoverers()) {
                            boolean applicable = true;
                            Object[] objectArray = selectedObjects;
                            int n3 = selectedObjects.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object selectedObject = objectArray[n4];
                                try {
                                    if (!IDiscoveryManager.INSTANCE.isApplicable(discoverer, selectedObject)) {
                                        applicable = false;
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                                }
                                ++n4;
                            }
                            if (!applicable) continue;
                            discoverers.add(discoverer);
                        }
                        if (discoverers.size() > 0) {
                            Collections.sort(discoverers, DISCOVERERS_COMPARATOR);
                            for (DiscovererDescription discoverer : discoverers) {
                                ContributionItemForMoDiscoMenu.this.createMenuForDiscoverer(discoverer, modiscoMenu, selectedObjects);
                            }
                        } else {
                            MenuItem discovererMenu = new MenuItem(modiscoMenu, 8);
                            discovererMenu.setText(Messages.ContributionItemForMoDiscoMenu_noApplicableDiscoverer);
                            discovererMenu.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
    }

    private final void createMenuForDiscoverer(DiscovererDescription discoverer, Menu modiscoMenu, Object[] selectedObjects) {
        Menu parentMenu = modiscoMenu;
        DiscovererUI discovererUI = DiscovererUIRegistry.getInstance().getDiscovererUI(discoverer.getId());
        if (discovererUI == null) {
            if (Platform.inDebugMode()) {
                Logger.logWarning((String)("No discoverer UI defined for discoverer " + discoverer.getId() + ". It will not appear in the MoDisco menu."), (Plugin)Activator.getDefault());
            }
            return;
        }
        String[] pathParts = discovererUI.getPath().length() == 0 ? new String[]{} : discovererUI.getPath().split("/");
        if (pathParts.length > 0) {
            String[] stringArray = pathParts;
            int n = pathParts.length;
            int n2 = 0;
            while (n2 < n) {
                String pathEntry = stringArray[n2];
                MenuItem intermediateMenu = null;
                MenuItem[] menuItemArray = parentMenu.getItems();
                int n3 = menuItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MenuItem item = menuItemArray[n4];
                    if (item.getText().equalsIgnoreCase(pathEntry)) {
                        intermediateMenu = item;
                    }
                    ++n4;
                }
                if (intermediateMenu == null) {
                    intermediateMenu = new MenuItem(parentMenu, 64, parentMenu.getItemCount());
                    intermediateMenu.setText(pathEntry);
                    parentMenu = new Menu(intermediateMenu);
                    intermediateMenu.setMenu(parentMenu);
                } else {
                    parentMenu = intermediateMenu.getMenu();
                }
                ++n2;
            }
        }
        MenuItem discovererMenu = new MenuItem(parentMenu, 8, 0);
        Object label = discovererUI.getLabel();
        if (!((String)label).trim().endsWith("...") && !MoDiscoMenuSelectionListener.getExpectedInputParameters(discoverer).isEmpty()) {
            label = (String)label + "...";
        }
        discovererMenu.setText((String)label);
        if (discovererUI.getImageIcon() != null) {
            discovererMenu.setImage(discovererUI.getImageIcon());
        }
        MoDiscoMenuSelectionListener handler = new MoDiscoMenuSelectionListener(discoverer, selectedObjects, this.shell);
        discovererMenu.addSelectionListener((SelectionListener)handler);
    }

    public boolean isDynamic() {
        return true;
    }
}

