/*******************************************************************************
 * Copyright (c) 2008, 2026 Mia-Software and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Fabien Giquel (Mia-Software)
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/

package org.eclipse.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.osgi.framework.Bundle;

/** @author Gabriel Barbier */
@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.FileUtils or TestFileUtils */
public final class FolderUtils {
	private static final int COPY_BUFFER_SIZE = 512 * 1024;

	private static boolean debug = false;

	private static FolderUtils.ConfigurationManagementFilter configurationManagementFilter;

	private static class ConfigurationManagementFilter implements FilenameFilter {
		private static final String FILTER_NAME = "CVS"; //$NON-NLS-1$

		/**
		 * Tests if a specified file should be included in a file list.
		 *
		 *
		 * @param dir
		 *            the directory in which the file was found.
		 * @param name
		 *            the name of the file.
		 *
		 * @return <code>true</code> if and only if the name should be included
		 *         in the file list; <code>false</code> otherwise.
		 */
		@Override
		public boolean accept(final File dir, final String name) {
			boolean result = false;
			if (!name.equals(FolderUtils.ConfigurationManagementFilter.FILTER_NAME)) {
				result = true;
			}
			return result;
		}
	}

	private FolderUtils() {
		// prevent instantiation
	}

	@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.TestFileUtils */
	public static final void clearFolder(final File dirtyFolder) {
		assert dirtyFolder != null;
		assert dirtyFolder.exists();
		assert dirtyFolder.isDirectory();
		/*
		 * To delete the contents of this folder, we recurse on all elements
		 * (File) in this folder. In the case of a directory, we first delete
		 * its own contents before deleting it. In the case of a file, we just
		 * delete the file.
		 */
		File[] files = dirtyFolder.listFiles();
		for (File file : files) {
			if (file.isDirectory()) {
				FolderUtils.clearFolder(file);
			}
			file.delete();
		}
	}

	/**
	 * This method compares two folders (in fact the contents of these two
	 * folders). It is recursive into each folder
	 */
	@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.TestFileUtils */
	public static final boolean compareFolders(final File folderSource, final File folderTarget) {
		return FolderUtils.compareFolders(folderSource, folderTarget,
				FolderUtils.configurationManagementFilter, FolderUtils.getDefaultFileComparator());
	}

	@Deprecated /* not used */
	public static final boolean compareFolders(final File folderSource, final File folderTarget,
			final FilenameFilter filter) {
		return FolderUtils.compareFolders(folderSource, folderTarget, filter,
				FolderUtils.getDefaultFileComparator());
	}

	@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.TestFileUtils */
	public static final boolean compareFolders(final File folderSource, final File folderTarget,
			final FilenameFilter filter, final Comparator<File> fileComparison) {
		assert ((folderSource != null) && (folderTarget != null));
		assert ((folderSource.isDirectory()) && (folderTarget.isDirectory()));
		boolean result = false;
		if (folderSource.equals(folderTarget)) {
			result = true;
		} else {
			result = recursiveCompareFolders(folderSource, folderTarget, filter,
					fileComparison);
			if (FolderUtils.debug && !result) {
				Logger
						.logError(
								"folders " + folderSource.getName() + " and " + folderTarget.getName() + " are not equal.", CommonModiscoActivator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		return result;
	}

	@Deprecated /* not used */
	public static final boolean compareFiles(final File source, final File target) {
		return FolderUtils.compareFiles(source, target, FolderUtils.getDefaultFileComparator());
	}

	@Deprecated /* not used */
	private static final Comparator<File> getDefaultFileComparator() {
		return new Comparator<File>() {
			@Override
			public int compare(final File source, final File target) {
				boolean result = true;
				if (!source.getName().equals(target.getName())) {
					result = false;
				} else {
					// Compare file line by line
					BufferedReader sourceReader = null;
					BufferedReader targetReader = null;
					try {
						sourceReader = new BufferedReader(new FileReader(source));
						targetReader = new BufferedReader(new FileReader(target));
						String sourceLine = sourceReader.readLine();
						String targetLine = targetReader.readLine();
						while ((sourceLine != null) && (targetLine != null)) {
							result = result && sourceLine.equals(targetLine);
							sourceLine = sourceReader.readLine();
							targetLine = targetReader.readLine();
						}
						if ((sourceLine != null) || (targetLine != null)) {
							result = false;
							Logger
									.logError(
											"These files do not have the same number of lines.", CommonModiscoActivator.getDefault()); //$NON-NLS-1$
						}
					} catch (FileNotFoundException e) {
						result = false;
					} catch (IOException e) {
						result = false;
					} finally {
						if (sourceReader != null) {
							try {
								sourceReader.close();
							} catch (IOException e) {
								Logger.logError(e, CommonModiscoActivator.getDefault());
							}
						}
						if (targetReader != null) {
							try {
								targetReader.close();
							} catch (IOException e) {
								Logger.logError(e, CommonModiscoActivator.getDefault());
							}
						}
					}
				}
				if (result) {
					return 0;
				}
				return -1;
			}
		};
	}

	@Deprecated
	public static final boolean compareFiles(final File source, final File target,
			final Comparator<File> fileComparator) {
		assert ((source.isFile()) && (target.isFile()));
		boolean result = (fileComparator.compare(source, target) == 0);
		if (FolderUtils.debug && result) {
			Logger
					.logInfo(
							"Files " + source.getName() + " and " + target.getName() + " are equal.", CommonModiscoActivator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		return result;
	}

	@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.TestFileUtils */
	public static final String getFileContent(final File source) {
		return org.eclipse.modisco.common.core.files.FileUtils.getFileContent(source);
	}

	/**
	 * This method compares two folders (in fact the contents of these two
	 * folders). It is recursive into each folder
	 */
	@Deprecated /* not used */
	private static final boolean recursiveCompareFolders(final File folderSource,
			final File folderTarget, final FilenameFilter filter,
			final Comparator<File> fileComparison) {
		if (FolderUtils.debug) {
			Logger
					.logError(
							"comparison of " + folderSource.getName() + " and " + folderTarget.getName(), CommonModiscoActivator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		boolean result = true;

		File[] sourceContents = folderSource.listFiles(filter);
		File[] targetContents = folderTarget.listFiles(filter);
		if (sourceContents.length != targetContents.length) {
			result = false;
			if (FolderUtils.debug) {
				Logger.logError("folders " + folderSource.getName() + " and " //$NON-NLS-1$//$NON-NLS-2$
						+ folderTarget.getName() + " do not have the same number of children (" //$NON-NLS-1$
						+ sourceContents.length + ", " + targetContents.length + ")", //$NON-NLS-1$ //$NON-NLS-2$
						CommonModiscoActivator.getDefault());
			}
		} else {
			for (File sourceContent : sourceContents) {
				/*
				 * For each File in the current directory, we test if it has a
				 * counterpart in the contents of the target directory. The
				 * search is based on the path name, so there can be problems if
				 * a file has the same name as a directory.
				 */
				File targetContent = FolderUtils.getCorrespondingTargetContent(sourceContent,
						targetContents);
				if (targetContent == null) {
					result = false;
					if (FolderUtils.debug) {
						Logger
								.logError(
										"There is no corresponding element in target folder for " + sourceContent.getName(), CommonModiscoActivator.getDefault()); //$NON-NLS-1$
					}
				} else {
					/*
					 * Two cases: for a directory, recurse into its contents,
					 * and for a file, compare the contents of the two files.
					 */
					if (sourceContent.isDirectory()) {
						boolean subResult = FolderUtils.recursiveCompareFolders(sourceContent,
								targetContent, filter, fileComparison);
						result = result && subResult;

						if (FolderUtils.debug && !subResult) {
							Logger
									.logError(
											"folders " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", CommonModiscoActivator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
					} else {
						boolean subResult = FolderUtils.compareFiles(sourceContent, targetContent,
								fileComparison);
						result = result && subResult;
						if (FolderUtils.debug && !subResult) {
							Logger
									.logError(
											"files " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", CommonModiscoActivator.getDefault()); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						}
					}
				}
			}
		}
		return result;
	}

	@Deprecated /* not used */
	private static final File getCorrespondingTargetContent(final File sourceContent,
			final File[] targetContents) {
		File targetContent = null;
		for (File temp : targetContents) {
			if (sourceContent.getName().equals(temp.getName())) {
				targetContent = temp;
			}
		}
		return targetContent;
	}

	/**
	 * Copies the source directory to the target directory. The target is
	 * created if it does not exist.
	 */
	@Deprecated /* not used */
	public static final void copyDirectory(final File srcDir, final File destDir)
			throws IOException {
		FolderUtils.copyDirectory(srcDir, destDir, new org.eclipse.modisco.common.core.files.IFilter() {
			@Override
			public boolean filter(final Object object) {
				return true;
			}
		});
	}

	@Deprecated /* not used */
	public static final void copyDirectory(final File srcDir, final File destDir,
			final org.eclipse.modisco.common.core.files.IFilter filter) throws IOException {
		//
		//	Build Map of folders to copy before copying to avoid recursion for Maven.
		//
		Map<File, File> src2dest = new HashMap<File, File>();
		copyDirectory2(srcDir, destDir, filter, src2dest);
		for (File srcDir2 : src2dest.keySet()) {
			File destDir2 = src2dest.get(srcDir2);
			if (!destDir2.exists()) {
				destDir2.mkdirs();
			}
			// Copies each file and directory, one by one
			for (File src : srcDir2.listFiles()) {
				if (!src.isDirectory()) {
					File dest = new File(destDir2.getPath() + File.separator + src.getName());
					if (filter.filter(dest)) {
						org.eclipse.modisco.common.core.files.FileUtils.copyFile(src, dest);
					}
				}
			}
		}
	}

	/* Recurse to gather the directories to be copied in src2dest */
	@Deprecated /* not used */
	private static final void copyDirectory2(final File srcDir, final File destDir,
			final org.eclipse.modisco.common.core.files.IFilter filter, Map<File, File> src2dest) throws IOException {
		src2dest.put(srcDir, destDir);
		for (File src : srcDir.listFiles()) {
			if (src.isDirectory()) {
				File dest = new File(destDir.getPath() + File.separator + src.getName());
				if (filter.filter(dest)) {
					FolderUtils.copyDirectory2(src, dest, filter, src2dest);
				}
			}
		}

	}

	/**
	 * Copies the source directory to the target directory. The target is
	 * created if it does not exist.
	 * 
	 * @Deprecated Use Plugin argument to avoid wrong 'bundle' on Tycho.
	 */
	@Deprecated /* @deprecated use org.eclipse.modisco.common.tests.FileUtils.copyFolderFromBundle */
	public static void copyFolderFromBundle(final String sourcePath, final Bundle sourceBundle,
			final String targetPath, final IProject targetProject) throws IOException, CoreException {
		org.eclipse.modisco.common.core.files.FileUtils.copyFolderFromBundle(sourceBundle, sourcePath, targetProject, targetPath);
	}

	/**
	 * Copies the source file to the target file.
	 *
	 * @return <code>true</code> if successful, <code>false</code> otherwise
	 */
	@Deprecated /* @deprecated use org.eclipse.modisco.common.core.files.FileUtils.copyFile */
	public static final boolean copyFile(final File source, final File destination) {
		return org.eclipse.modisco.common.core.files.FileUtils.copyFile(source, destination);
	}

	/**
	 * Recursively delete a directory.
	 *
	 * @param directory
	 *            directory to delete
	 * @throws IOException
	 *             in case deletion is unsuccessful
	 */
	@Deprecated /* not used */
	public static final void deleteDirectory(final File directory) throws IOException {
		if (!directory.exists()) {
			return;
		}

		FolderUtils.clearFolder(directory);
		if (directory.list().length == 0) {
			// delete directory
			if (!directory.delete()) {
				String message = "Unable to delete directory " + directory + "."; //$NON-NLS-1$ //$NON-NLS-2$
				throw new IOException(message);
			}
		}
	}

	@Deprecated /* not used */
	public static void createFolder(final IFolder folder) throws CoreException {
		if (!folder.getParent().exists()) {
			FolderUtils.createFolder((IFolder) folder.getParent());
		}
		if (!folder.exists()) {
			folder.create(true, true, new NullProgressMonitor());
		}
	}

	/**
	 * write a new content into a given file.
	 *
	 * @param source
	 *            source file. It will be created if it does not exist.
	 * @param newContent
	 * @throws IOException
	 */
	@Deprecated /* not used */
	public static final void writeFileContent(final File source, final String newContent)
			throws IOException {
		FileWriter fw = new FileWriter(source, false);
		fw.write(newContent);
		fw.close();
	}
}
