/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class NonBlockingElementComputation<T> {
    private static final boolean DEBUG = false;
    private static final int MAX_SYNCHRONOUS_WAIT_DELAY = 200;
    private final Set<Object> computing = Collections.synchronizedSet(new HashSet());
    private final IWorkbenchSiteProgressService progressService;

    public NonBlockingElementComputation(IWorkbenchSiteProgressService progressService) {
        this.progressService = progressService;
    }

    protected abstract T basicCompute(Object var1);

    protected abstract T getTemporaryDefaultValue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeValue(final Object element) {
        ValueRef valueRef;
        block9: {
            if (this.computing.contains(element)) {
                return this.getTemporaryDefaultValue();
            }
            valueRef = new ValueRef();
            final Object signal = new Object();
            final boolean[] finished = new boolean[1];
            final boolean[] needsRefresh = new boolean[1];
            Job job = new Job(Messages.BrowserContentProvider_computingChildren){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean localNeedsRefresh;
                        NonBlockingElementComputation.this.debugPrint("computing");
                        NonBlockingElementComputation.this.computing.add(element);
                        Object value = NonBlockingElementComputation.this.basicCompute(element);
                        valueRef.setValue(value);
                        finished[0] = true;
                        Object object = signal;
                        synchronized (object) {
                            signal.notify();
                            localNeedsRefresh = needsRefresh[0];
                        }
                        if (localNeedsRefresh) {
                            NonBlockingElementComputation.this.computationFinished();
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        NonBlockingElementComputation.this.computing.remove(element);
                    }
                }
            };
            job.setSystem(true);
            job.setPriority(30);
            this.progressService.schedule(job, 0L);
            try {
                Object object = signal;
                synchronized (object) {
                    signal.wait(200L);
                }
                if (finished[0]) break block9;
                this.debugPrint("asynchronous");
                object = signal;
                synchronized (object) {
                    needsRefresh[0] = true;
                }
                return this.getTemporaryDefaultValue();
            }
            catch (InterruptedException e) {
                Logger.logError((Throwable)e, (Plugin)MoDiscoBrowserPlugin.getPlugin());
            }
        }
        this.debugPrint("synchronous");
        return valueRef.getValue();
    }

    private void debugPrint(String message) {
    }

    protected abstract void computationFinished();

    public boolean isComputing() {
        return !this.computing.isEmpty();
    }

    private class ValueRef {
        private T value;

        private ValueRef() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

