/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.core.internal.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.modisco.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.modisco.facet.efacet.core.internal.Activator;
import org.eclipse.modisco.facet.efacet.core.internal.query.QueryUtils;
import org.eclipse.modisco.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.modisco.facet.efacet.core.query.IQueryImplementationFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.modisco.facet.util.emf.core.ICatalogSetManagerFactory;
import org.osgi.framework.Bundle;

public class QueryImplementationFactoryRegistry {
    private static final String EXT_ID = "org.eclipse.modisco.facet.efacet.core.queryImplementationRegistration";
    private static final String CLASS = "class";
    public static final QueryImplementationFactoryRegistry INSTANCE = new QueryImplementationFactoryRegistry();
    private final List<IQueryImplementationFactory> factories = new ArrayList<IQueryImplementationFactory>();

    public QueryImplementationFactoryRegistry() {
        this.initRegisteredEntries();
    }

    private void initRegisteredEntries() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXT_ID);
        if (extPoint != null) {
            IExtension[] iExtensionArray = extPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElt = iConfigurationElementArray[n4];
                    try {
                        Object impl = configElt.createExecutableExtension(CLASS);
                        if (impl instanceof IQueryImplementationFactory) {
                            IQueryImplementationFactory factory = (IQueryImplementationFactory)impl;
                            this.factories.add(factory);
                        } else {
                            Logger.logError((String)("Invalid extension in " + ext.getNamespaceIdentifier() + "." + ". The factory must be an instance of " + IQueryImplementationFactory.class.getName()), (Plugin)Activator.getDefault());
                        }
                    }
                    catch (CoreException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public IQueryImplementation getEvaluatorFor(Query query, IDerivedTypedElementManager manager) throws DerivedTypedElementException {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        IQueryImplementation queryImpl = null;
        boolean factoryFound = false;
        for (IQueryImplementationFactory queryImplFactory : this.factories) {
            boolean bl = factoryFound = queryImplFactory.getManagedQueryType() == query.eClass();
            if (!factoryFound) continue;
            Resource queryResource = query.eResource();
            Bundle bundle = null;
            if (queryResource != null) {
                bundle = ICatalogSetManagerFactory.DEFAULT.createICatalogSetManager(query.eResource().getResourceSet()).getBundleByResource(queryResource);
            }
            queryImpl = queryImplFactory.create(query, bundle, manager);
            break;
        }
        if (!factoryFound) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("No factory implementation found for ");
            buffer.append(QueryUtils.getQueryDescription(query));
            buffer.append(".\nA factory should be registered through the ");
            buffer.append(EXT_ID);
            buffer.append(" extension point.");
            buffer.append("\nAvailable Query types are: ");
            int i = 0;
            while (i < this.factories.size()) {
                if (i > 0) {
                    buffer.append(", ");
                }
                IQueryImplementationFactory factory = this.factories.get(i);
                buffer.append(factory.getManagedQueryType().getName());
                ++i;
            }
            throw new DerivedTypedElementException(buffer.toString());
        }
        return queryImpl;
    }
}

