/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.eclipseplugin.discoverer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.eclipseplugin.EclipsePlugin;
import org.eclipse.modisco.eclipseplugin.EclipsepluginFactory;
import org.eclipse.modisco.eclipseplugin.discoverer.Activator;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.discoverer.DiscoverJavaModelFromJavaProject;
import org.eclipse.modisco.kdm.source.discoverer.DiscoverSourceModelFromJavaElement;
import org.eclipse.modisco.manifest.Bundle;
import org.eclipse.modisco.manifest.discoverer.ManifestModelDiscoverer2;
import org.eclipse.modisco.omg.kdm.code.CompilationUnit;
import org.eclipse.modisco.omg.kdm.kdm.Segment;
import org.eclipse.modisco.omg.kdm.source.InventoryModel;
import org.eclipse.modisco.omg.kdm.source.Project;
import org.eclipse.modisco.properties.discoverer.PropertiesModelDiscoverer2;
import org.eclipse.modisco.xml.Attribute;
import org.eclipse.modisco.xml.Element;
import org.eclipse.modisco.xml.Node;
import org.eclipse.modisco.xml.Root;
import org.eclipse.modisco.xml.discoverer.XMLModelDiscoverer;

public class DiscoverEclipsePluginFromJavaProject2
extends AbstractModelDiscoverer<IJavaProject> {
    public boolean isApplicableTo(IJavaProject source) {
        try {
            return source.getProject().isAccessible() && source.getProject().getNature("org.eclipse.pde.PluginNature") != null;
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
    }

    protected void basicDiscoverElement(IJavaProject source, IProgressMonitor monitor) throws DiscoveryException {
        IProject project = source.getProject();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(project.getFullPath().append(project.getName()) + "_eclipseplugin.xmi"), (boolean)true));
        this.discoverEclipsePluginModel(source, monitor);
    }

    private static IFile getFile(IJavaProject javaProject, String filePath) {
        IFile resource = javaProject.getProject().getFile((IPath)new Path(filePath));
        if (resource instanceof IFile) {
            return resource;
        }
        return null;
    }

    private void discoverEclipsePluginModel(IJavaProject javaProject, IProgressMonitor monitor) throws DiscoveryException {
        IFile manifestFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, "META-INF/MANIFEST.MF");
        IFile buildPropertiesFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, "build.properties");
        IFile pluginPropertiesFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, "plugin.properties");
        IFile bundlePropertiesFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, "OSGI-INF/I10n/bundle.properties");
        IFile classPathFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, ".classpath");
        IFile projectXmlFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, ".project");
        IFile pluginXmlFile = DiscoverEclipsePluginFromJavaProject2.getFile(javaProject, "plugin.xml");
        Resource kdmSourceResource = this.discoverKdmSourceModel(javaProject, monitor);
        Resource javaResource = this.discoverJavaModel(javaProject, monitor);
        Resource manifestResource = this.discoverManifestModel(manifestFile, monitor);
        Resource buildPropertiesResource = this.discoverBuildPropertiesModel(buildPropertiesFile, monitor);
        Resource pluginPropertiesResource = this.discoverPluginPropertiesModel(pluginPropertiesFile, monitor);
        Resource bundlePropertiesResource = this.discoverBundlePropertiesModel(bundlePropertiesFile, monitor);
        Resource classPathResource = this.discoverXmlModel(classPathFile, "classpath", monitor);
        Resource projectResource = this.discoverXmlModel(projectXmlFile, "project", monitor);
        Resource pluginXmlResource = this.discoverXmlModel(pluginXmlFile, "plugin.xml", monitor);
        EclipsePlugin eclipsePlugin = EclipsepluginFactory.eINSTANCE.createEclipsePlugin();
        this.createTargetModel().getContents().add((Object)eclipsePlugin);
        eclipsePlugin.setJavaModel((Model)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(javaResource));
        eclipsePlugin.setBuildProperties((CompilationUnit)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(buildPropertiesResource));
        eclipsePlugin.setBundleProperties((CompilationUnit)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(bundlePropertiesResource));
        eclipsePlugin.setPluginProperties((CompilationUnit)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(pluginPropertiesResource));
        eclipsePlugin.setInventoryProject(DiscoverEclipsePluginFromJavaProject2.getKdmProject(kdmSourceResource));
        Bundle bundle = (Bundle)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(manifestResource);
        if (bundle != null) {
            eclipsePlugin.setBundle(bundle);
            eclipsePlugin.setName(bundle.getSymbolicName());
        }
        eclipsePlugin.setClassPathRoot((Root)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(classPathResource));
        eclipsePlugin.setProject((Root)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(projectResource));
        eclipsePlugin.setPluginXml((Root)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(pluginXmlResource));
        eclipsePlugin.setOutputDirectory(DiscoverEclipsePluginFromJavaProject2.getClassPathEntry("output", classPathResource));
        eclipsePlugin.setSrcDirectory(DiscoverEclipsePluginFromJavaProject2.getClassPathEntry("src", classPathResource));
    }

    private Resource discoverKdmSourceModel(IJavaProject javaProject, IProgressMonitor monitor) throws DiscoveryException {
        DiscoverSourceModelFromJavaElement kdmSourceDiscoverer = new DiscoverSourceModelFromJavaElement();
        kdmSourceDiscoverer.setSerializeTarget(this.isTargetSerializationChosen());
        kdmSourceDiscoverer.setTargetURI(this.deriveTargetURI(null, null, "_kdm.xmi"));
        kdmSourceDiscoverer.discoverElement((Object)javaProject, monitor);
        Resource kdmSourceResource = kdmSourceDiscoverer.getTargetModel();
        kdmSourceResource.setURI(kdmSourceDiscoverer.getTargetURI());
        return kdmSourceResource;
    }

    private Resource discoverJavaModel(IJavaProject javaProject, IProgressMonitor monitor) throws DiscoveryException {
        DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, null, "_java.xmi"));
        discoverer.discoverElement((Object)javaProject, monitor);
        Resource resource = discoverer.getTargetModel();
        resource.setURI(discoverer.getTargetURI());
        return resource;
    }

    private Resource discoverManifestModel(IFile manifestFile, IProgressMonitor monitor) throws DiscoveryException {
        if (manifestFile == null || !manifestFile.exists()) {
            return null;
        }
        ManifestModelDiscoverer2 discoverer = new ManifestModelDiscoverer2();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, "MANIFEST.MF", ".xmi"));
        discoverer.discoverElement((Object)manifestFile, monitor);
        Resource targetModel = discoverer.getTargetModel();
        targetModel.setURI(discoverer.getTargetURI());
        return targetModel;
    }

    private Resource discoverBuildPropertiesModel(IFile buildPropertiesFile, IProgressMonitor monitor) throws DiscoveryException {
        if (buildPropertiesFile == null || !buildPropertiesFile.exists()) {
            return null;
        }
        PropertiesModelDiscoverer2 discoverer = new PropertiesModelDiscoverer2();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, "build.properties", ".xmi"));
        discoverer.discoverElement((Object)buildPropertiesFile, monitor);
        Resource targetModel = discoverer.getTargetModel();
        targetModel.setURI(discoverer.getTargetURI());
        return targetModel;
    }

    private Resource discoverPluginPropertiesModel(IFile pluginPropertiesFile, IProgressMonitor monitor) throws DiscoveryException {
        if (pluginPropertiesFile == null || !pluginPropertiesFile.exists()) {
            return null;
        }
        PropertiesModelDiscoverer2 discoverer = new PropertiesModelDiscoverer2();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, "plugin.properties", ".xmi"));
        discoverer.discoverElement((Object)pluginPropertiesFile, monitor);
        Resource targetModel = discoverer.getTargetModel();
        targetModel.setURI(discoverer.getTargetURI());
        return targetModel;
    }

    private Resource discoverBundlePropertiesModel(IFile bundlePropertiesFile, IProgressMonitor monitor) throws DiscoveryException {
        if (bundlePropertiesFile == null || !bundlePropertiesFile.exists()) {
            return null;
        }
        PropertiesModelDiscoverer2 discoverer = new PropertiesModelDiscoverer2();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, "bundle.properties", ".xmi"));
        discoverer.discoverElement((Object)bundlePropertiesFile, monitor);
        Resource targetModel = discoverer.getTargetModel();
        targetModel.setURI(discoverer.getTargetURI());
        return targetModel;
    }

    private Resource discoverXmlModel(IFile xmlFile, String basename, IProgressMonitor monitor) throws DiscoveryException {
        if (xmlFile == null || !xmlFile.exists()) {
            return null;
        }
        XMLModelDiscoverer discoverer = new XMLModelDiscoverer();
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetURI(this.deriveTargetURI(null, basename, ".xmi"));
        discoverer.discoverElement((Object)xmlFile, monitor);
        Resource targetModel = discoverer.getTargetModel();
        targetModel.setURI(discoverer.getTargetURI());
        return targetModel;
    }

    private static Project getKdmProject(Resource kdmSourceResource) {
        InventoryModel kdmModel;
        EList inventoryElements;
        EList models;
        Segment kdmSegment = (Segment)DiscoverEclipsePluginFromJavaProject2.getFirstRoot(kdmSourceResource);
        if (kdmSegment != null && (models = kdmSegment.getModel()).size() > 0 && (inventoryElements = (kdmModel = (InventoryModel)kdmSegment.getModel().get(0)).getInventoryElement()).size() > 0) {
            return (Project)inventoryElements.get(0);
        }
        return null;
    }

    private static EObject getFirstRoot(Resource resource) {
        if (resource != null && resource.getContents() != null && resource.getContents().size() > 0) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    private static String getClassPathEntry(String kindSearch, Resource classPathResource) {
        String kind = "";
        String path = "";
        String output = "";
        TreeIterator i = classPathResource.getAllContents();
        while (i.hasNext()) {
            Element element;
            EObject eo = (EObject)i.next();
            if (!(eo instanceof Element) || !(element = (Element)eo).getName().equals("classpathentry")) continue;
            for (Node children : element.getChildren()) {
                if (!(children instanceof Attribute)) continue;
                Attribute attribute = (Attribute)children;
                if (attribute.getName().equals("kind")) {
                    kind = attribute.getValue();
                }
                if (!attribute.getName().equals("path")) continue;
                path = attribute.getValue();
            }
            if (!kind.equals(kindSearch)) continue;
            output = path;
        }
        return output;
    }

    private URI deriveTargetURI(String directory, String filename, String suffix) {
        String baseName = filename;
        URI mainURI = this.getTargetURI();
        if (mainURI == null || mainURI.toString().trim().length() == 0) {
            mainURI = this.getDefaultTargetURI();
        }
        String lastSegment = mainURI.lastSegment();
        if (baseName == null) {
            baseName = lastSegment.endsWith("_eclipseplugin.xmi") ? lastSegment.substring(0, lastSegment.length() - "_eclipseplugin.xmi".length()) : (lastSegment.endsWith(".xmi") ? lastSegment.substring(0, lastSegment.length() - ".xmi".length()) : lastSegment);
        }
        mainURI = mainURI.trimSegments(1);
        if (directory != null) {
            mainURI = mainURI.appendSegment(directory);
        }
        return mainURI.appendSegment(String.valueOf(baseName) + suffix);
    }
}

