/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.common.core.files;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.common.core.files.FileUtils;
import org.eclipse.modisco.common.core.files.IFilter;
import org.eclipse.modisco.common.core.internal.Activator;
import org.eclipse.modisco.common.core.internal.Messages;
import org.eclipse.modisco.common.core.internal.MoDiscoCommonRuntimeException;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class ProjectUtils {
    private static final String JAVA_VERSION = "JavaSE-1.8";

    protected ProjectUtils() {
        throw new IllegalStateException();
    }

    public static void addNature(IProject project, IProgressMonitor monitor, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(natureId)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static void addPdeClassPath(IProject project) throws JavaModelException {
        IClasspathEntry[] oldClassPath;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = oldClassPath = javaProject.getRawClasspath();
        int n = oldClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getPath().equals((Object)new Path("org.eclipse.pde.core.requiredPlugins"))) {
                return;
            }
            ++n2;
        }
        IClasspathEntry[] newClassPath = new IClasspathEntry[oldClassPath.length + 1];
        System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
        newClassPath[oldClassPath.length] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
        javaProject.setRawClasspath(newClassPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addPdeNature(IProject project) throws CoreException {
        String pluginNature = "org.eclipse.pde.PluginNature";
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(pluginNature)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = pluginNature;
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static String bundleActivatorQualifiedName(String packageName) {
        return String.valueOf(packageName) + ".Activator";
    }

    public static void configureAsJavaProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry[] existingClassPath;
        ProjectUtils.addNature(project, monitor, "org.eclipse.jdt.core.javanature");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append("bin");
        javaProject.setOutputLocation(path, null);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IFolder sourceFolder = project.getFolder("src");
        if (!sourceFolder.exists()) {
            sourceFolder.create(false, true, monitor);
            classpathEntries.add(JavaCore.newSourceEntry((IPath)javaProject.getPath().append((IPath)new Path("src"))));
        }
        Path jrePath = new Path(String.valueOf(JavaRuntime.JRE_CONTAINER) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + JAVA_VERSION);
        boolean hasJrePath = false;
        IClasspathEntry[] iClasspathEntryArray = existingClassPath = javaProject.getRawClasspath();
        int n = existingClassPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (jrePath.equals((Object)classpathEntry.getPath())) {
                hasJrePath = true;
            }
            ++n2;
        }
        if (!hasJrePath) {
            classpathEntries.add(JavaCore.newContainerEntry((IPath)jrePath));
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[0]), monitor);
        }
    }

    public static void configureAsPluginProject(IProject project) throws CoreException {
        ProjectUtils.addPdeNature(project);
        ProjectUtils.addPdeClassPath(project);
        ProjectUtils.createManifest(project);
        ProjectUtils.createActivator(project);
    }

    private static void createActivator(IProject project) throws CoreException {
        String packageName = ProjectUtils.packageName(project.getName());
        String qualifiedName = ProjectUtils.bundleActivatorQualifiedName(packageName);
        String path = qualifiedName.replaceAll("\\.", "/");
        IFile activatorFile = project.getFile(new Path("src").append(path).addFileExtension("java"));
        FileUtils.createFolder((IFolder)activatorFile.getParent());
        if (!activatorFile.exists()) {
            try {
                String template = FileUtils.getFileContents(Activator.getDefault().getBundle(), "resources/Activator.java.template");
                String activatorContents = template.replace("{0}", packageName);
                ByteArrayInputStream source = new ByteArrayInputStream(activatorContents.getBytes());
                activatorFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                Logger.logError(e, "Couldn't create Activator", Activator.getDefault());
            }
        }
    }

    public static void createBuildProperties(IProject project) throws CoreException {
        IFile buildFile = project.getFile("build.properties");
        if (!buildFile.exists()) {
            StringBuffer buildSB = new StringBuffer();
            buildSB.append("source.. = src/\n");
            buildSB.append("output.. = bin/\n");
            buildSB.append("bin.includes = META-INF/,\\\n");
            buildSB.append("               .\n");
            ByteArrayInputStream source = new ByteArrayInputStream(buildSB.toString().getBytes());
            buildFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void createManifest(IProject project) throws CoreException {
        IFile manifestFile;
        IFolder folder = project.getFolder("META-INF");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(manifestFile = folder.getFile("MANIFEST.MF")).exists()) {
            StringBuffer manifestSB = new StringBuffer();
            manifestSB.append("Manifest-Version: 1.0\n");
            manifestSB.append("Bundle-ManifestVersion: 2\n");
            manifestSB.append("Bundle-Name: " + project.getName() + "\n");
            String packageName = ProjectUtils.packageName(project.getName());
            manifestSB.append("Bundle-SymbolicName: " + packageName + ";singleton:=true\n");
            manifestSB.append("Bundle-Version: 0.0.1.qualifier\n");
            manifestSB.append("Bundle-Activator: " + ProjectUtils.bundleActivatorQualifiedName(packageName) + "\n");
            manifestSB.append("Require-Bundle: org.eclipse.core.runtime,\n");
            manifestSB.append(" org.eclipse.modisco.infra.common.core,\n");
            manifestSB.append(" org.eclipse.modisco.infra.query.core\n");
            manifestSB.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.8\n");
            manifestSB.append("Bundle-ActivationPolicy: lazy\n");
            manifestSB.append("Bundle-ClassPath: .,bin\n");
            ByteArrayInputStream source = new ByteArrayInputStream(manifestSB.toString().getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void createPluginProject(IProject project, IProgressMonitor monitor, boolean monitorDone) throws CoreException {
        IPath projectLocation = project.getLocation();
        monitor.beginTask(Messages.ProjectUtils_0, -1);
        if (!project.exists()) {
            IProjectDescription description = project.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)projectLocation)) {
                description.setLocation(projectLocation);
            }
            project.create(monitor);
            project.open(monitor);
            monitor.subTask(Messages.ProjectUtils_1);
            ProjectUtils.configureAsJavaProject(project, monitor);
            monitor.subTask(Messages.ProjectUtils_2);
            ProjectUtils.configureAsPluginProject(project);
            ProjectUtils.createBuildProperties(project);
        } else {
            Logger.logWarning("Project creation aborted : the project already exists", (Plugin)Activator.getDefault());
        }
        if (monitorDone) {
            monitor.done();
        }
    }

    protected static IProject createProjectWithUniqueName(String baseName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(baseName);
        if (project.exists()) {
            int version = 1;
            int maxIter = 100;
            while (project.exists() && version < 100) {
                String uniqueName = String.valueOf(baseName) + " (" + version + ')';
                project = root.getProject(uniqueName);
                ++version;
            }
        }
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        return project;
    }

    public static void enableAPT(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                ProjectScope context = new ProjectScope(project);
                IEclipsePreferences node = context.getNode("org.eclipse.jdt.apt.core");
                node.put("org.eclipse.jdt.apt.aptEnabled", "true");
                node.sync();
                IEclipsePreferences javaNode = context.getNode("org.eclipse.jdt.core");
                javaNode.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
                javaNode.sync();
            }
            catch (Exception e) {
                Logger.logError(e, "Error enabling apt processing", Activator.getDefault());
            }
        }
    }

    public static IProject importPlugin(Bundle bundle) throws CoreException, IOException {
        return ProjectUtils.importPlugin(bundle, new IFilter(){

            @Override
            public boolean filter(Object fileName) {
                return true;
            }
        });
    }

    public static IProject importPlugin(Bundle bundle, IFilter filter) throws CoreException, IOException {
        IProject project;
        block19: {
            String bundleName = bundle.getSymbolicName();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
            if (project.exists()) {
                int n = 1;
                int maxIter = 100;
                while (project.exists() && n < 100) {
                    String uniqueName = String.valueOf(bundleName) + " (" + n + ")";
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName);
                    ++n;
                }
            }
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
            try (ZipFile zip = null;){
                File bundleFile;
                String filePath;
                String bundlePath = bundle.getLocation();
                Location platformInstall = Platform.getInstallLocation();
                URL url = platformInstall.getURL();
                String installPath = url.toString().replaceAll(".*file:", "");
                if (bundlePath.startsWith("initial@reference:file:")) {
                    filePath = bundlePath.replaceAll("initial@reference:file:", "");
                    if (filePath.startsWith(".")) {
                        filePath = String.valueOf(installPath) + filePath;
                    }
                } else {
                    filePath = bundlePath.replaceFirst("^reference:file:", "");
                }
                if ((bundleFile = new File(filePath)).isDirectory()) {
                    FileUtils.copyDirectory(bundleFile, project.getLocation().toFile(), filter);
                    break block19;
                }
                try {
                    zip = new ZipFile(new File(filePath));
                }
                catch (Exception e1) {
                    throw new MoDiscoCommonRuntimeException("Failed to open the zip file :" + filePath, e1);
                }
                Enumeration<? extends ZipEntry> entries = zip.entries();
                ArrayList<Status> errors = new ArrayList<Status>();
                while (entries.hasMoreElements()) {
                    try {
                        ZipEntry zipEntry = entries.nextElement();
                        if (!filter.filter(zipEntry.getName())) continue;
                        if (zipEntry.isDirectory()) {
                            IFolder f = project.getFolder(zipEntry.getName());
                            if (f.exists()) continue;
                            f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            continue;
                        }
                        InputStream inputStream = zip.getInputStream(zipEntry);
                        IFile f = project.getFile(zipEntry.getName());
                        if (!f.getParent().exists() && f.getParent() instanceof IFolder) {
                            IFolder folder = (IFolder)f.getParent();
                            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (f.exists()) {
                            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        f.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        errors.add(new Status(4, "org.eclipse.modisco.common.core", e.getMessage(), (Throwable)e));
                    }
                }
                if (errors.size() > 0) {
                    IStatus[] statusArray = errors.toArray(new IStatus[0]);
                    MultiStatus status = new MultiStatus("org.eclipse.modisco.common.core", 4, statusArray, "Errors happened", (Throwable)new Exception());
                    CoreException exception = new CoreException((IStatus)status);
                    throw exception;
                }
            }
        }
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        return project;
    }

    public static void joinJobs(IProgressMonitor monitor) throws InterruptedException {
        IJobManager jobManager = Job.getJobManager();
        jobManager.join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
        jobManager.join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
        jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
        jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
    }

    public static String packageName(String name) {
        IStatus status;
        StringBuilder builder = new StringBuilder();
        int prev = 32;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                builder.append(c);
                prev = c;
            } else if (c >= '0' && c <= '9') {
                if (builder.length() == 0 || prev == 46) {
                    builder.append("_");
                }
                builder.append(c);
                prev = c;
            } else if (c == '.') {
                if (prev != 46) {
                    if (builder.length() == 0 || prev >= 48 && prev <= 57) {
                        builder.append("_");
                    }
                    builder.append(c);
                    prev = c;
                }
            } else {
                builder.append("_");
            }
            ++i;
        }
        String result = builder.toString();
        if (result.length() > 0 && Character.isUpperCase(result.charAt(0))) {
            result = String.valueOf(Character.toLowerCase(result.charAt(0))) + result.substring(1);
        }
        if (!(status = JavaConventions.validatePackageName((String)result, (String)"1.5", (String)"1.5")).isOK()) {
            Logger.logWarning("Couldn't make valid package name from project name: " + status.getMessage(), (Plugin)Activator.getDefault());
            return name;
        }
        return result;
    }

    public static void refresh(IProject project) throws CoreException, InterruptedException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.refreshLocal(2, (IProgressMonitor)monitor);
        ProjectUtils.joinJobs((IProgressMonitor)monitor);
    }
}

