/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.ocl.Logger;
import org.eclipse.m2m.internal.qvt.oml.ocl.metainfo.OclMetainfoOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperationException;

class LibraryOperationImpl
implements LibraryOperation {
    private Library myLibrary;
    private String myName;
    private String myContext;
    private String myReturnType;
    private List<String> myParameterTypes;
    private Method myMethod;
    private static final List<String> IMPLICIT_PARAMETERS_LIST = new LinkedList<String>();

    public LibraryOperationImpl(OclMetainfoOperation meta, Library library) throws LibraryOperationException, LibraryCreationException {
        this.myLibrary = library;
        this.myName = meta.getMethod().getName();
        this.myMethod = meta.getMethod();
        this.myContext = meta.getContextType();
        this.myReturnType = meta.getType();
        this.myParameterTypes = new LinkedList<String>(meta.getParameterTypes());
    }

    @Override
    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public void load() throws LibraryOperationException {
    }

    @Override
    public String getContext() {
        return this.myContext;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getReturnType() {
        return this.myReturnType;
    }

    @Override
    public List<String> getParameterTypes() {
        return this.myParameterTypes;
    }

    @Override
    public List<String> getImplicitParameterNames() {
        return IMPLICIT_PARAMETERS_LIST;
    }

    @Override
    public Object run(Object context, Object[] explicitParameterValues, Object[] implicitParameterValues, Class<?> returnTypeClass) {
        Object[] explicitParameterValuesWithContext = this.getJoinArray(new Object[]{context}, explicitParameterValues);
        Object[] parameters = this.getJoinArray(implicitParameterValues, explicitParameterValuesWithContext);
        if (!(this.isMethodApplicable(parameters, returnTypeClass) || this.isMethodApplicable(parameters = explicitParameterValuesWithContext, returnTypeClass) || this.isMethodApplicable(parameters = explicitParameterValues, returnTypeClass))) {
            throw new RuntimeException("Unable to execute native method -- incorrect parameters passed: " + Arrays.asList(parameters));
        }
        Method method = this.getMethod();
        try {
            return method.invoke(this.getLibrary().getLibraryInstance(), parameters);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    @Override
    public String getOperationReference(String[] parameterNames) {
        String className = this.getLibrary().getLibraryClassName().replaceAll("\\$", ".");
        StringBuffer paramString = new StringBuffer();
        int i = 0;
        int len = parameterNames.length;
        while (i < len) {
            paramString.append(parameterNames[i]);
            if (i < len - 1) {
                paramString.append(", ");
            }
            ++i;
        }
        String call = "new " + className + "()." + this.getName() + "(" + paramString + ")";
        return call;
    }

    private Object[] getJoinArray(Object[] first, Object[] second) {
        Object[] result = new Object[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private boolean isMethodApplicable(Object[] parameterValues, Class<?> returnType) {
        Method method;
        Class<?>[] methodParameters;
        Class<?>[] parameterClasses = this.getParameterClasses(parameterValues);
        if (parameterClasses.length != (methodParameters = (method = this.getMethod()).getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < parameterClasses.length) {
            Class<?> required = methodParameters[i];
            Class<?> actual = parameterClasses[i];
            if (actual != null && !required.isAssignableFrom(actual)) {
                Logger.getLogger().log(Logger.WARNING, "Type " + required + " is not assignable from " + actual);
                return false;
            }
            ++i;
        }
        if (returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
            Logger.getLogger().log(Logger.SEVERE, "Required return type " + returnType + " is not assignable from method return type " + method.getReturnType());
            return false;
        }
        return true;
    }

    private Class<?>[] getParameterClasses(Object[] parameters) {
        ArrayList parameterClasses = new ArrayList();
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            parameterClasses.add(param == null ? null : param.getClass());
            ++n2;
        }
        return parameterClasses.toArray(new Class[parameterClasses.size()]);
    }

    private Method getMethod() {
        return this.myMethod;
    }

    public String toString() {
        return String.valueOf(this.myName) + this.myParameterTypes + "/" + this.myLibrary;
    }
}

