/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.wtp.overlay.internal.OverlayPluginActivator;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.m2e.wtp.overlay.internal.utilities.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemResourceFilter
implements IResourceFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemResourceFilter.class);
    private SimpleScanner scanner;

    public FileSystemResourceFilter(Collection<String> inclusions, Collection<String> exclusions, IPath baseDirPath) {
        this.scanner = new SimpleScanner(baseDirPath);
        if (inclusions != null && !inclusions.isEmpty()) {
            this.scanner.setIncludes(inclusions.toArray(new String[inclusions.size()]));
        } else {
            this.scanner.setIncludes(new String[]{"**/**"});
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            this.scanner.addExcludes(exclusions.toArray(new String[exclusions.size()]));
        }
        this.scanner.addDefaultExcludes();
        this.scanner.scan();
    }

    @Override
    public boolean accepts(String resourcePath, boolean isFile) {
        return this.scanner.accepts(resourcePath, isFile);
    }

    static class ScanResult
    implements Externalizable {
        private static final String COLLECTION_SEPARATOR = ";";
        private static final long serialVersionUID = 1L;
        private String baseDirAsString;
        private String scanId;
        private Set<String> includedFiles;
        private Set<String> excludedFiles;
        private Set<String> includedFolders;
        private Set<String> excludedFolders;

        public ScanResult() {
            this.includedFiles = new HashSet<String>(0);
            this.excludedFiles = new HashSet<String>(0);
            this.includedFolders = new HashSet<String>(0);
            this.excludedFolders = new HashSet<String>(0);
        }

        public ScanResult(String scanId, String baseDirAsString, String[] incFiles, String[] excFiles, String[] incDirs, String[] excDirs) {
            this.scanId = scanId;
            this.baseDirAsString = baseDirAsString;
            this.includedFiles = new HashSet<String>(Arrays.asList(incFiles));
            this.excludedFiles = new HashSet<String>(Arrays.asList(excFiles));
            this.includedFolders = new HashSet<String>(Arrays.asList(incDirs));
            this.excludedFolders = new HashSet<String>(Arrays.asList(excDirs));
            this.completeIncludedFolders();
        }

        public String getBaseDirAsString() {
            return this.baseDirAsString;
        }

        public void setBaseDirAsString(String baseDirAsString) {
            this.baseDirAsString = baseDirAsString;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public void setIncludedFiles(Set<String> includedFiles) {
            this.includedFiles = includedFiles;
        }

        public Set<String> getExcludedFiles() {
            return this.excludedFiles;
        }

        public void setExcludedFiles(Set<String> excludedFiles) {
            this.excludedFiles = excludedFiles;
        }

        public Set<String> getIncludedFolders() {
            return this.includedFolders;
        }

        public void setIncludedFolders(Set<String> includedFolders) {
            this.includedFolders = includedFolders;
        }

        public Set<String> getExcludedFolders() {
            return this.excludedFolders;
        }

        public void setExcludedFolders(Set<String> excludedFolders) {
            this.excludedFolders = excludedFolders;
        }

        private String getId() {
            return this.scanId;
        }

        static File getScanResultFile(String scanResultId) {
            IPath location = OverlayPluginActivator.getWorkspacePluginPath();
            File root = location.toFile();
            File scanFile = new File(root, scanResultId + ".scan");
            return scanFile;
        }

        boolean accepts(String name, boolean isFile) {
            if ((name = PathUtil.useSystemSeparator(name)).startsWith(this.baseDirAsString)) {
                name = name.substring(this.baseDirAsString.length() + 1);
            }
            boolean res = isFile ? this.includedFiles.contains(name) && !this.excludedFiles.contains(name) : this.includedFolders.contains(name) && !this.excludedFolders.contains(name);
            return res;
        }

        private void completeIncludedFolders() {
            IPath parentPath;
            Path filePath;
            HashSet<String> missingParentFolders = new HashSet<String>();
            for (String folder : this.includedFolders) {
                filePath = new Path(folder);
                parentPath = filePath.removeLastSegments(1);
                while (parentPath.segmentCount() > 0) {
                    String pathAsString = parentPath.toOSString();
                    if (!this.includedFolders.contains(pathAsString)) {
                        missingParentFolders.add(pathAsString);
                    }
                    parentPath = parentPath.removeLastSegments(1);
                }
            }
            this.includedFolders.addAll(missingParentFolders);
            block2: for (String file : this.includedFiles) {
                filePath = new Path(file);
                parentPath = filePath.removeLastSegments(1);
                while (parentPath.segmentCount() > 0) {
                    if (!this.includedFolders.add(parentPath.toOSString())) continue block2;
                    parentPath = parentPath.removeLastSegments(1);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.scanId);
            out.writeUTF(this.baseDirAsString);
            out.writeObject(this.toString(this.includedFiles));
            out.writeObject(this.toString(this.excludedFiles));
            out.writeObject(this.toString(this.includedFolders));
            out.writeObject(this.toString(this.excludedFolders));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.scanId = in.readUTF();
            this.baseDirAsString = in.readUTF();
            this.includedFiles = this.toSet((String)in.readObject());
            this.excludedFiles = this.toSet((String)in.readObject());
            this.includedFolders = this.toSet((String)in.readObject());
            this.excludedFolders = this.toSet((String)in.readObject());
        }

        private Set<String> toSet(String arrayAsString) {
            if (arrayAsString == null) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(arrayAsString.split(COLLECTION_SEPARATOR)));
        }

        private String toString(Set<String> stringSet) {
            if (stringSet == null || stringSet.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String s : stringSet) {
                sb.append(s).append(COLLECTION_SEPARATOR);
            }
            int lastSeparatorIdx = sb.lastIndexOf(COLLECTION_SEPARATOR);
            if (lastSeparatorIdx > -1) {
                sb.deleteCharAt(lastSeparatorIdx);
            }
            return sb.toString();
        }

        public static void write(ScanResult scanResult) {
            File scanResultFile = ScanResult.getScanResultFile(scanResult.getId());
            ObjectOutputStream oos = null;
            try {
                try {
                    FileOutputStream fos = new FileOutputStream(scanResultFile);
                    oos = new ObjectOutputStream(fos);
                    scanResult.writeExternal(oos);
                    oos.flush();
                }
                catch (Exception ex) {
                    LOG.error("Unable to serialize scan results", (Throwable)ex);
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public static ScanResult read(String scanResultId) {
            File scanResultFile = ScanResult.getScanResultFile(scanResultId);
            if (!scanResultFile.isFile()) {
                return null;
            }
            ScanResult scanResult = null;
            ObjectInputStream ois = null;
            try {
                try {
                    FileInputStream fis = new FileInputStream(scanResultFile);
                    ois = new ObjectInputStream(fis);
                    scanResult = new ScanResult();
                    scanResult.readExternal(ois);
                }
                catch (Exception ex) {
                    LOG.error("Unable to read scan results", (Throwable)ex);
                    scanResultFile.delete();
                    scanResult = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception exception) {}
            }
            return scanResult;
        }
    }

    static class SimpleScanner
    extends DirectoryScanner {
        private ScanResult scanResult;
        private String[] includePatterns;
        private String[] excludePatterns;
        private String baseDirAsString;
        private long folderTimestamp;

        public synchronized void setIncludes(String[] includes) {
            this.includePatterns = this.setFileSeparator(includes);
            super.setIncludes(this.includePatterns);
        }

        public String[] getIncludePatterns() {
            return this.includePatterns;
        }

        public String[] getExcludePatterns() {
            return this.excludePatterns;
        }

        public boolean accepts(String resourcePath, boolean isFile) {
            if (this.scanResult != null) {
                return this.scanResult.accepts(resourcePath, isFile);
            }
            return false;
        }

        public synchronized void setExcludes(String[] excludes) {
            this.excludePatterns = this.setFileSeparator(excludes);
            super.setExcludes(this.excludePatterns);
        }

        private String[] setFileSeparator(String[] patterns) {
            if (patterns != null) {
                int i = 0;
                while (i < patterns.length) {
                    patterns[i] = PathUtil.useSystemSeparator(patterns[i]);
                    ++i;
                }
            }
            return patterns;
        }

        public SimpleScanner(IPath baseDirPath) {
            this.baseDirAsString = baseDirPath.toOSString();
            this.setBasedir(this.baseDirAsString);
            this.folderTimestamp = this.basedir.lastModified();
        }

        public void scan() throws IllegalStateException {
            String scanId = Integer.toString(this.hashCode());
            this.scanResult = ScanResult.read(scanId);
            if (this.scanResult == null) {
                super.scan();
                this.scanResult = new ScanResult(scanId, this.baseDirAsString, this.getIncludedFiles(), this.getExcludedFiles(), this.getIncludedDirectories(), this.getExcludedDirectories());
                ScanResult.write(this.scanResult);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseDirAsString == null ? 0 : this.baseDirAsString.hashCode());
            result = 31 * result + Arrays.hashCode(this.excludePatterns);
            result = 31 * result + Arrays.hashCode(this.includePatterns);
            result = 31 * result + (int)(this.folderTimestamp ^ this.folderTimestamp >>> 32);
            return result;
        }
    }
}

