/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.relaxng.utils.RelaxNGUtils;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class RNGHighlightingParticipant
implements IHighlightingParticipant {
    @Override
    public void findDocumentHighlights(DOMNode node, Position position, int offset, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        DOMDocument document = node.getOwnerDocument();
        if (!DOMUtils.isRelaxNGXMLSyntax(document)) {
            return;
        }
        DOMAttr attr = node.findAttrAt(offset);
        if (attr == null || attr.getNodeAttrValue() == null) {
            return;
        }
        RelaxNGUtils.BindingType bindingType = RelaxNGUtils.getBindingType(attr);
        if (bindingType != RelaxNGUtils.BindingType.NONE) {
            DOMAttr originAttr = attr;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(originAttr.getNodeAttrValue().getStart(), originAttr.getNodeAttrValue().getEnd(), document), DocumentHighlightKind.Read));
            boolean searchInExternalSchema = false;
            RelaxNGUtils.searchRNGTargetAttributes(originAttr, bindingType, true, searchInExternalSchema, (targetNamespacePrefix, targetAttr) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetAttr.getNodeAttrValue().getStart(), targetAttr.getNodeAttrValue().getEnd(), targetAttr.getOwnerDocument()), DocumentHighlightKind.Write)));
        } else if (RelaxNGUtils.isRNGTargetElement(attr.getOwnerElement())) {
            DOMAttr targetAttr2 = attr;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetAttr2.getNodeAttrValue().getStart(), targetAttr2.getNodeAttrValue().getEnd(), targetAttr2.getOwnerDocument()), DocumentHighlightKind.Write));
            RelaxNGUtils.searchRNGOriginAttributes(targetAttr2, (origin, target) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(origin.getNodeAttrValue().getStart(), origin.getNodeAttrValue().getEnd(), origin.getOwnerDocument()), DocumentHighlightKind.Read)), cancelChecker);
        }
    }
}

