/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;

public class ExpandTemplateTask
extends CDOTask {
    private final List<TemplateProperty> templateProperties = new ArrayList<TemplateProperty>();
    private File template;
    private File target;
    private String placeholderPrefix = "%%";
    private String placeholderSuffix = "%%";

    public TemplateProperty createTemplateProperty() {
        TemplateProperty templateProperty = new TemplateProperty();
        this.templateProperties.add(templateProperty);
        return templateProperty;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        ExpandTemplateTask.assertTrue("'template' must be specified.", this.template != null);
        ExpandTemplateTask.assertTrue("'template' must be point to an existing file.", this.template.isFile());
        ExpandTemplateTask.assertTrue("'target' must be specified.", this.target != null);
        ExpandTemplateTask.assertTrue("'placeholderPrefix' must be specified.", this.placeholderPrefix != null && this.placeholderPrefix.length() != 0);
        ExpandTemplateTask.assertTrue("'placeholderSuffix' must be specified.", this.placeholderSuffix != null && this.placeholderSuffix.length() != 0);
        for (TemplateProperty templateProperty : this.templateProperties) {
            String name = templateProperty.getName();
            ExpandTemplateTask.assertTrue("'name' of property must be specified.", name != null && name.length() != 0);
        }
    }

    @Override
    protected void doExecute() throws Exception {
        this.verbose("Expanding template " + String.valueOf(this.template) + " to target " + String.valueOf(this.target));
        String content = ExpandTemplateTask.readTextFile(this.template);
        Map<String, String> properties = this.getProperties();
        String result = this.generate(content, properties);
        ExpandTemplateTask.writeTextFile(this.target, result);
    }

    protected String generate(String content, Map<String, String> properties) throws Exception {
        StringBuilder result = new StringBuilder(content);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            int pos;
            String placeholder = this.formatPlaceholder(entry.getKey());
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            int placeholderLength = placeholder.length();
            int valueLength = value.length();
            int start = 0;
            while ((pos = result.indexOf(placeholder, start)) != -1) {
                this.verbose("Expanding template property '" + entry.getKey() + "' at position " + pos);
                result.replace(pos, pos + placeholderLength, value);
                start = pos + valueLength;
            }
        }
        return result.toString();
    }

    protected String formatPlaceholder(String name) {
        return this.placeholderPrefix + name + this.placeholderSuffix;
    }

    protected Map<String, String> getProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (TemplateProperty templateProperty : this.templateProperties) {
            result.put(templateProperty.getName(), templateProperty.getValue());
        }
        return result;
    }

    public static final class TemplateProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            builder.append(" = ");
            builder.append(this.value);
            return builder.toString();
        }
    }
}

