/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.properties;

import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.prefs.OMPreferencePage;
import org.eclipse.net4j.util.ui.prefs.PrefBoolean;
import org.eclipse.net4j.util.ui.prefs.PrefIntegerAndDisable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExplorerPreferencePage
extends OMPreferencePage {
    private PrefIntegerAndDisable repositoryTimeout;
    private PrefBoolean rememberOpenEditors;
    private PrefBoolean showObjectsInExplorer;

    public ExplorerPreferencePage() {
        super(OM.PREFS);
    }

    protected Control createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)UIUtil.createGridData());
        new Label(composite, 0).setText("Repository inactivity timeout:");
        this.repositoryTimeout = new PrefIntegerAndDisable(composite, 2048, OM.PREF_REPOSITORY_TIMEOUT_MINUTES, OM.PREF_REPOSITORY_TIMEOUT_DISABLED){

            protected GridData createTextLayoutData() {
                return UIUtil.createGridData((boolean)true, (boolean)false);
            }
        };
        this.repositoryTimeout.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        this.rememberOpenEditors = new PrefBoolean(composite, 32, OM.PREF_REMEMBER_OPEN_EDITORS);
        this.rememberOpenEditors.getButton().setText("Remember open model editors");
        this.rememberOpenEditors.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        UIUtil.setIndentation((Control)this.rememberOpenEditors, (int)-1, (int)10);
        this.showObjectsInExplorer = new PrefBoolean(composite, 32, OM.PREF_SHOW_OBJECTS_IN_EXPLORER);
        this.showObjectsInExplorer.getButton().setText("Show objects in project explorer");
        this.showObjectsInExplorer.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.initValues();
        return composite;
    }

    protected void initValues() {
        this.repositoryTimeout.loadPreferences();
        this.rememberOpenEditors.loadPreferences();
        this.showObjectsInExplorer.loadPreferences();
    }

    public boolean performOk() {
        this.repositoryTimeout.savePreferences();
        this.rememberOpenEditors.savePreferences();
        this.showObjectsInExplorer.savePreferences();
        return super.performOk();
    }
}

